<?php
class Coach
{
    public $coid;
    public $fname;
    public $lname;
    public $email;
    public $phone;
    public $calid;
    public $HF;
    public $superuser = 0;
    public $rdvs;
    public $rdv4;
    public $rdv2;
    public $fkey;
    public $crkey;
    public $cavails;
    public $ncoachings;
    public $pcoachings;
    public $ncoachingdates;
    public $poscoachings;
    public $tworvs;
    public $availabilities;
    public $active_users;
    public $poss_coach_sess;
    public $poss_coach_compl;
    public $alltags;
    public $dropmsgs;
    
    public function populate($dbh, $fkey)
    {
        // get the superuser status
        $strsql = "SELECT COUNT(co.coid) as superuser FROM selectusers AS se JOIN coach AS co ON se.fname = co.fname AND se.lname = co.lname
				AND se.phone = co.phone AND se.HF = co.HF WHERE fkey = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $fkey
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        $this->superuser = 0;
        if ($CID ["superuser"] == 1) {
            $this->superuser = 1;
        } else {
            return;
        }

        $this->fkey = $fkey;
        $strsql = "SELECT co.coid as mycoid, se.crkey as mycrkey FROM selectusers AS se JOIN coach AS co ON se.fname = co.fname AND se.lname = co.lname
				AND se.phone = co.phone AND se.HF = co.HF WHERE fkey = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $fkey
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        $mycoid = $CID ["mycoid"];
        $this->crkey = $CID["mycrkey"];
        
        // get data from coach
        
        $strsql = "SELECT * FROM coach WHERE coid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $mycoid
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // put in the right boxes
        
        $this->coid = $CID ["coid"];
        $this->fname = $CID ["fname"];
        $this->lname = $CID ["lname"];
        $this->email = $CID ["email"];
        $this->phone = $CID ["phone"];
        $this->calid = $CID["calid"];
        $this->HF = $CID ["HF"];
        // get the current rdvs 2 to be treated
        
        $strsql = "SELECT * FROM rdv_2 WHERE coid = ? ORDER BY cdat ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        foreach ($CID as $lcid) {
            $this->rdv2 [] = $lcid;
        }


        // get the current rdvs 3 to be treated
        
        $strsql = "SELECT * FROM rdv WHERE coid = ? ORDER BY cdat ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        foreach ($CID as $lcid) {
            $this->rdvs [] = $lcid;
        }

        // get the current rdvs 4 to be treated
        
        $strsql = "SELECT * FROM rdvuni WHERE coid = ? ORDER BY cdat ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        foreach ($CID as $lcid) {
            $this->rdv4 [] = $lcid;
        }

        // get the current possibilities to be treated
        
        $strsql = "SELECT * FROM tworvs WHERE coid = ? ORDER BY cdat ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        foreach ($CID as $lcid) {
            $this->tworvs [] = $lcid;
        }

        // get the availabilities for this coach not already booked for coaching
        
        $strsql = "SELECT * FROM cavailabilities WHERE coid = ? and cavid NOT IN (SELECT cavid from cwho where coid = ?) ORDER BY cdat, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid,
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // store those
        foreach ($CID as $lcid) {
            $this->cavails [] = $lcid;
        }
        
        // get the next coachings for this coach
        
        $strsql = "SELECT * FROM allcoachings WHERE cwdate >= curdate() AND coid = ? ORDER BY cwdate, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // store those
        foreach ($CID as $lcid) {
            $this->ncoachings [] = $lcid;
        }

        // get the past coachings for this coach
        
        $strsql = "SELECT * FROM allcoachings WHERE cwdate < curdate() AND coid = ? ORDER BY cwdate, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // store those
        foreach ($CID as $lcid) {
            $this->pcoachings [] = $lcid;
        }

        // get the next coachings dates for this coach
        
        $strsql = "SELECT DISTINCT cwdate FROM allcoachings WHERE cwdate >= (curdate() - INTERVAL 15 day) AND coid = ? ORDER BY cwdate ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // store those
        foreach ($CID as $lcid) {
            $this->ncoachingdates [] = $lcid;
        }


        // get the next coachings dates for this coach
        
        $strsql = "SELECT * FROM poscoachings WHERE coid = ? ORDER BY cdat, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // store those
        foreach ($CID as $lcid) {
            $this->poscoachings [] = $lcid;
        }

        // if any possible coaching is there, put it !
        $this->poss_coach_sess = 0;
        $n4s = count_coaching_sessions($dbh, "rdvuni", $this->coid);
        $n3s = count_coaching_sessions($dbh, "rdv", $this->coid);
        $n2s = count_coaching_sessions($dbh, "rdv_2", $this->coid);
        $n1s = count_coaching_sessions($dbh, "poscoachings", $this->coid);
        switch (NMINPDAY) {
            case "4" : $this->poss_coach_sess = $n4s;
                break;
            case "3" : $this->poss_coach_sess = $n4s + $n3s;
                break;
            case "2" : $this->poss_coach_sess = $n4s + $n3s + $n2s;
                break;
            case "1" : $this->poss_coach_sess = $n4s + $n3s + $n2s + $n1s;
                break;   
        }
        $this->poss_coach_compl = count_coaching_completions($dbh, $this->coid);

        // get the tags from the db
            
        $strsql = 'SELECT DISTINCT tag FROM users WHERE tag IS NOT NULL AND tag != "" ORDER BY tag ASC';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                        $this->coid
                ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        foreach ($CID as $lcid) {
            $this->alltags [] = $lcid;
        }

        // get the number of dispos to give back
                
        $strsql = 'SELECT COUNT(id) AS cid FROM dropmsg_current WHERE sent IS NOT TRUE';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                            $this->coid
                    ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        $this->dropmsgs = $CID["cid"];
    }
    public function echo_completions($dbh)
    {
        dblog();
        $strsql = "select distinct p.usid, p.cdat, p.fname, p.lname, p.cavid, p.slid, p.loid, p.loc, p.coid, p.slot,
		 cw.salle from poscoachings as p JOIN cwho_current AS cw on cw.cwdate = p.cdat AND cw.coid = p.coid
		 AND cw.cslid != p.slid AND cw.usid != p.usid AND cw.cwlocid = p.loid AND p.coid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        echo "<p>Voici les rendez-vous individuels de coaching avec lesquels vous pouvez compléter une journée déjà programmée. Merci d'en sélectionner <strong>un seul</strong> à la fois.</p>";
        foreach ($CID as $rdv) {
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho_manual">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            echo '<p>' . $rdv["fname"] . " " . $rdv["lname"] . ' le ' . strftime("%A %d %B %Y", strtotime($rdv ["cdat"])) . ' (' . $rdv ["slot"] . ')'
        . ' à ' . $rdv ["loc"] ;
            if ($rdv["salle"] !== null) {
                echo 'Salle réservée : ' . $rdv["salle"];
                echo '<input type="hidden" name="salle" value="' . $rdv["salle"]. '">';
            }
            echo '</p>';
            echo '(envoyer un email <INPUT TYPE="checkbox" name="upmail" value="1" checked>)<br />';
            echo '(envoyer une invitation via agenda <INPUT TYPE="checkbox" name="upgoogle" value="1" checked>)<br />';
            echo '(mettre à jour la base de données <INPUT TYPE="checkbox" name="upcwho" value="1" checked>)<br />';
            echo '<input type="hidden" name="usid'.$rdv["slid"].'" value="' . $rdv["usid"] . '">';
            echo '<input type="hidden" name="slotini" value="' . $rdv["slid"] . '">';
            echo '<input type="hidden" name="slotend" value="' . $rdv["slid"]. '">';
            echo '<input type="hidden" name="datet" value="' . $rdv["cdat"]. '">';
            echo '<input type="hidden" name="loid" value="' . $rdv["loid"]. '">';
            echo '<input type="hidden" name="coid" value="' . $rdv["coid"]. '">';
            echo '<input type="submit" value="Confirmer ce choix"></form>';
        }
    }
    public function get_all_active_users($dbh)
    {
        dblog();
        // Get all active users
        $strsql = "SELECT CONCAT(u.fname,' ',u.lname) AS name, CONCAT(c.fname,' ',c.lname) AS cname, u.email AS email, 
		u.usid AS usid, u.coid AS coid, u.crkey AS crkey, u.tag AS tag FROM sessbyuser AS s
		JOIN users AS u ON u.usid = s.usid
		JOIN coach as c ON c.coid = u.coid WHERE s.nsess < s.cnum AND u.usid <> 0 AND c.coid <> 0 ORDER BY u.lname, c.lname";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute();
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // store those
        $this->active_users = array();
        foreach ($CID as $lcid) {
            $this->active_users [] = $lcid;
        }
    }
    public function echo_cavails($dbh, $fkey)
    {
        dblog();
        if (!empty($this->cavails)) {
            echo "<p>Voici vos disponibilités telles qu'enregistrées. Toutes les dates désélectionnées seront supprimées
				du système. Les sessions en <strong>gras</strong> sont celles où déjà deux participants au moins ont confirmé leur disponibilité/</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="delete_cavails">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            echolog("D", "printing availabilities with " . count($this->cavails));
            echolog("D", $this->cavails);
            echo '<div class="ltable">';
            $i = - 1;
            foreach ($this->cavails as $ploc) {
                $i ++;
                // are there already possibilities on the same day ?
                /* if (false) {
                  $boldit = false;

                  if (is_array ( $this->tworvs ) and (! $boldit)) {
                  echolog ( "D", "Searching for " . $ploc ["cavid"] . "inside  tworvs" );
                  echolog ( "D", $this->tworvs );
                  foreach ( $this->tworvs as $bloc ) {
                  if ($bloc ["cavid"] == $ploc ["cavid"]) {
                  $boldit = true;
                  echolog ( "D", "FOUND" );
                  }
                  }
                  }
                  }
                  $strsql = "SELECT ncavid FROM ncavidbyday WHERE cavid = ? AND coid = ? LIMIT 1";
                  try {
                  $sth = $dbh->prepare ( $strsql );
                  $sth->execute ( array (
                  $ploc["cavid"],
                  $this->coid
                  ) );
                  $CID = $sth->fetch ( PDO::FETCH_ASSOC );
                  $sth->closeCursor ();
                  } catch ( PDOException $e ) {
                  echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
                  exit ();
                  }
                  $boldit = ($CID["ncavid"] >= 2) ? true : false ; */
                // new algorithm - better !
                $strsql = "SELECT COUNT(usid) AS cusid FROM poscoachings WHERE cavid = ? AND coid = ?";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $ploc["cavid"],
                        $this->coid
                    ));
                    $CID = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                $boldit = ($CID["cusid"] >= 2) ? true : false;


                $strongi = $boldit ? "<strong>" : "";
                $strongf = $boldit ? "</strong>" : "";

                if ($i % 4 == 0) {
                    echo '<div class="trow">';
                }
                echo '<div class="tcell"><input type="checkbox" name="cavail' . $i . '" value="' . $ploc ["cavid"] . '" ' . 'checked="checked"> ' . $strongi . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . '<br/>' . $ploc ["slot"] . $strongf . '</div>';
                if (($i + 1) % 4 == 0 or ($i + 1) == count($this->cavails)) {
                    echo '</div>';
                }
            }
            echo '</div><input type="hidden" name="ncavail" value="' . $i . '">';
            echo '<input type="submit" value="Mettre à jour mes disponibilités"></form>';
        } else {
            echo "<p><strong>Vous n'avez plus de disponibilités enregistrées. C'est le moment d'en ajouter.</strong></p>";
        }
    }
    public function echo_poscoachings()
    {
        dblog();
        
        if (!empty($this->poscoachings)) {
            echo '<p>Liste des ' . count($this->poscoachings) . ' sessions possible de coaching.</p>';
            echo '<div class="ltable">';
            echo '<div class="trow"><div class="tcell ca">Lieu</div><div class="tcell ca">Date</div><div class="tcell ca">
					Heure</div><div class="tcell ca">Client</div><div class="tcell ca">Coach</div></div>';
            foreach ($this->poscoachings as $ploc) {
                echo '<div class="trow"><div class="tcell ca">' . $ploc ["loc"] . '</div><div class="tcell ca">' . $ploc ["cdat"] . '</div><div class="tcell ca">' . $ploc ["slot"] . '</div><div class="tcell ca">' . $ploc ["fname"] . " " . $ploc ["lname"] . '</div><div class="tcell ca">' . $ploc ["cname"] . '</div></div>';
            }
            echo "</div>";
        } else {
            echo "<p>Pas de sessions de coaching possibles avec les données entrées par les participants.</p>";
        }
    }
    
    // get the next coachings dates for this coach
    
    public function get_availabilities($dbh, $cdat, $myloid)
    {
        dblog();
        
        if ($cdat == null) {
            $strsql = "SELECT * FROM availabilities WHERE coid = ? AND cdat >= CURDATE() AND loid = ? ORDER BY cdat, slid ASC";
        } else {
            $strsql = "SELECT * FROM availabilities WHERE coid = ? AND cdat = ? AND loid LIKE %?% ORDER BY cdat, slid ASC";
        }

        try {
            $sth = $dbh->prepare($strsql);
            if ($cdat == null) {
                $sth->execute(array(
                    $this->coid,
                    $myloid
                ));
            } else {
                $sth->execute(array(
                    $this->coid,
                    $cdat,
                    $myloid
                ));
            }
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
    
        // store those
        foreach ($CID as $lcid) {
            $this->availabilities [] = $lcid;
        }
    }
    
    public function echo_availabilities($dbh, $cdat, $myloid)
    {
        dblog("Cdat = " . $cdat. " and loid = " .$myloid);
        
        $this->get_availabilities($dbh, $cdat, $myloid);
        if (!empty($this->availabilities)) {
            echo '<p>Liste des ' . count($this->availabilities) . ' disponibilités de vos participants.</p>';
            echo '<div class="ltable">';
            echo '<div class="trow"><div class="tcell ca">Date</div><div class="tcell ca">
					Heure</div><div class="tcell ca">Client</div><div class="tcell ca">Localisations</div></div>';
            foreach ($this->availabilities as $ploc) {
                echo '<div class="trow"><div class="tcell ca">' . $ploc ["cdat"] . '</div><div class="tcell ca">' . $ploc ["slot"] . '</div><div class="tcell ca">' . $ploc ["uname"] . '</div><div class="tcell ca">' . $ploc ["loc"] . '</div></div>';
            }
            echo "</div>";
        } else {
            echo "<p>Pas de disponibilités avec les données entrées par les participants.</p>";
        }
    }
    public function echo_rdv($dbh, $fkey)
    {
        dblog();
        
        //
        if (!empty($this->rdvs)) {
            echo "<p>Voici tous les rendez-vous de coaching possibles. Merci d'en sélectionner <strong>un seul</strong> à la fois.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            // echolog("D","printing rdvs with ". count($this->rdvs));
            // echolog("D",$this->rdvs);
            echo '<div class="ltable">';
            $i = - 1;
            foreach ($this->rdvs as $ploc) {
                $i ++;
                if ($i % 2 == 0) {
                    echo '<div class="trow">';
                }
                echo '<div class="tcell">
							<strong>Le ' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . ' à ' . $ploc ["loc"] . '</strong><br/>' . $ploc ["fname1"] . " " . $ploc ["lname1"] . '(' . $ploc ["nsess1"] . ')' . ' - ' . $ploc ["slot1"] . '<br />' . $ploc ["fname2"] . " " . $ploc ["lname2"] . '(' . $ploc ["nsess2"] . ')' . ' - ' . $ploc ["slot2"] . '<br />' . $ploc ["fname3"] . " " . $ploc ["lname3"] . '(' . $ploc ["nsess3"] . ')' . ' - ' . $ploc ["slot3"] . '<br />' . '</div><div class="tcell">' . '<input type="radio" name="rdv_id" value="' . $ploc ["rdv_id"] . '"> ' . '</div>';
                if (($i + 1) % 2 == 0 or ($i + 1) == count($this->rdvs)) {
                    echo '</div>';
                }
            }
            echo '</div><input type="hidden" name="nrdv" value="' . $i . '">';
            echo '<input type="submit" value="Confirmer la journée de coaching choisie"></form>';
        } else {
            echo "<p><strong>Il n'est plus possible de trouver des dates de coaching à trois sessions par jour à confirmer.</strong></p>";
        }
    }

    public function mail_free_slots($dbh, $fkey)
    {
    }
    public function echo_rdv_4($dbh, $fkey)
    {
        dblog();
        
        //
        if (!empty($this->rdv4)) {
            echo "<p>Voici les rendez-vous prioritaires de coaching possibles à 4 par jour. Merci d'en sélectionner <strong>un seul</strong> à la fois.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho_4">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey. '>';
            // echolog("D","printing rdvs with ". count($this->rdvs));
            // echolog("D",$this->rdvs);
            echo '<div class="ltable">';
            $i = - 1;
            foreach ($this->rdv4 as $ploc) {
                $i ++;
                if ($i % 2 == 0) {
                    echo '<div class="trow">';
                }
                echo '<div class="tcell">
							<strong>Le ' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) .
                ' à ' . $ploc ["loc"] . '</strong><br/>' .
                $ploc ["fname1"] . " " . $ploc ["lname1"] . '(' . $ploc ["nsess1"] . ')' . ' - ' . $ploc ["slot1"] . '<br />' .
                $ploc ["fname2"] . " " . $ploc ["lname2"] . '(' . $ploc ["nsess2"] . ')' . ' - ' . $ploc ["slot2"] . '<br />' .
                $ploc ["fname3"] . " " . $ploc ["lname3"] . '(' . $ploc ["nsess3"] . ')' . ' - ' . $ploc ["slot3"] . '<br />' .
                $ploc ["fname4"] . " " . $ploc ["lname4"] . '(' . $ploc ["nsess4"] . ')' . ' - ' . $ploc ["slot4"] . '<br />' .
                '</div><div class="tcell">' .
                '<input type="radio" name="rdv_id" value="' . $ploc ["rdv_id"] . '"> ' . '</div>';
                if (($i + 1) % 2 == 0 or ($i + 1) == count($this->rdv4)) {
                    echo '</div>';
                }
            }
            echo '</div><input type="hidden" name="nrdv" value="' . $i . '">';
            echo '<input type="submit" value="Confirmer la journée de coaching choisie"></form>';
        } else {
            echo "<p><strong>Il n'est plus possible de trouver des dates de coaching à quatre sessions par jour à confirmer.</strong></p>";
        }
    }

    public function echo_rdv_2($dbh, $fkey)
    {
        dblog();
        
        //
        if (!empty($this->rdv2)) {
            echo "<p>Voici les rendez-vous prioritaires de coaching possibles à deux par jour. Merci d'en sélectionner <strong>un seul</strong> à la fois.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho_2">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            // echolog("D","printing rdvs with ". count($this->rdvs));
            // echolog("D",$this->rdvs);
            echo '<div class="ltable">';
            $i = - 1;
            foreach ($this->rdv2 as $ploc) {
                $i ++;
                if ($i % 2 == 0) {
                    echo '<div class="trow">';
                }
                echo '<div class="tcell">
							<strong>Le ' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) .
                ' à ' . $ploc ["loc"] . '</strong><br/>' .
                $ploc ["fname1"] . " " . $ploc ["lname1"] . '(' . $ploc ["nsess1"] . ')' . ' - ' . $ploc ["slot1"] . '<br />' .
                $ploc ["fname2"] . " " . $ploc ["lname2"] . '(' . $ploc ["nsess2"] . ')' . ' - ' . $ploc ["slot2"] . '<br />' .
                '</div><div class="tcell">' .
                '<input type="radio" name="rdv_id" value="' . $ploc ["rdv_id"] . '"> ' . '</div>';
                if (($i + 1) % 2 == 0 or ($i + 1) == count($this->rdv2)) {
                    echo '</div>';
                }
            }
            echo '</div><input type="hidden" name="nrdv" value="' . $i . '">';
            echo '<input type="submit" value="Confirmer la journée de coaching choisie"></form>';
        } else {
            echo "<p><strong>Il n'est plus possible de trouver des dates de coaching à deux sessions par jour à confirmer.</strong></p>";
        }
    }
    
    public function printsess($dbh, $datef, $datet, $mycoid)
    {
        dblog("From " . $datef . " to " . $datet . " for " . $mycoid);
        
        $strsql = "SELECT * FROM allcoachings WHERE cwdate >= ? and cwdate <= ? ";
        if ($mycoid != 0) {
            $strsql .= ' AND coid = ? ';
        }
        $strsql .= 'ORDER BY cwdate, cname, slid ASC';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute($mycoid == 0 ? array(
                    $datef,
                    $datet
            ) : array($datef,
                    $datet, $mycoid));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            echo '<p>Liste des ' . count($CID) . ' sessions de coaching entre le ' . strftime("%A %d %B %Y", strtotime($datef)) . ' et le ' . strftime("%A %d %B %Y", strtotime($datet)) . ' : </p>';
            echo '<div class="ltable">';
            echo '<div class="trow"><div class="tcell ca">Lieu</div><div class="tcell ca">Date</div><div class="tcell ca">
					Heure</div><div class="tcell ca">Client</div><div class="tcell ca">Coach</div></div>';
            foreach ($CID as $ploc) {
                echo '<div class="trow"><div class="tcell ca">' . $ploc ["loc"] . '</div><div class="tcell ca">' . strftime("%A %d %B %Y", strtotime($ploc ["cwdate"])) . '</div><div class="tcell ca">' . $ploc ["slot"] . '</div><div class="tcell ca">' . $ploc ["fname"] . " " . $ploc ["lname"] . '</div><div class="tcell ca">' . $ploc ["cfname"] . " " . $ploc ["clname"] . '</div></div>';
            }
            echo "</div>";
        } else {
            echo "<p>Pas de sessions de coaching entre le " . strftime("%A %d %B %Y", strtotime($datef)) . ' et le ' . strftime("%A %d %B %Y", strtotime($datet)) . ".</p>";
        }
    }
        public function echo_rdv_1($dbh, $fkey)
    {
        dblog();
        
        //
        if (!empty($this->poscoachings)) {
            echo "<p>Voici les rendez-vous prioritaires de coaching possibles à un seul par jour. Merci d'en sélectionner <strong>un seul</strong> à la fois.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho_1">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            // echolog("D","printing rdvs with ". count($this->rdvs));
            // echolog("D",$this->rdvs);
            echo '<div class="ltable">';
            $i = - 1;
            foreach ($this->poscoachings as $ploc) {
                $i ++;
                if ($i % 2 == 0) {
                    echo '<div class="trow">';
                }
                echo '<div class="tcell">
							<strong>Le ' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) .
                ' à ' . $ploc ["loc"] . '</strong><br/>' .
                $ploc ["fname"] . " " . $ploc ["lname"] . '(' . $ploc ["nsess"] . ')' . ' - ' . $ploc ["slot"] . '<br />'  .
                '</div><div class="tcell">' .
                '<input type="radio" name="rdv_id" value="' . $ploc ["rdv_id"] .'"> ' . '</div>';
                if (($i + 1) % 2 == 0 or ($i + 1) == count($this->poscoachings)) {
                    echo '</div>';
                }
            }
            echo '</div><input type="hidden" name="nrdv" value="' . $i . '">';
            echo '<input type="submit" value="Confirmer la session de coaching choisie"></form>';
        } else {
            echo "<p><strong>Il n'est plus possible de trouver des dates de coaching à une session par jour à confirmer.</strong></p>";
        }
    }
    
    public function xlssess($dbh, $datef, $datet, $mycoid)
    {
        dblog("From " . $datef . " to " . $datet . " for " . $mycoid);
        $strsql = 'SELECT loc, DATE_FORMAT(cwdate, "%W %e %M %Y") AS cdat, slot, concat(fname," ",lname) as uname, concat(cfname," ",clname) as cname
		FROM allcoachings WHERE cwdate >= ? and cwdate <= ? ';
        if ($mycoid != 0) {
            $strsql .= ' AND coid = ? ';
        }
        $strsql .= 'ORDER BY cwdate, cname, slid ASC';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute($mycoid == 0 ? array(
                    $datef,
                    $datet
            ) : array($datef,
                    $datet, $mycoid));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            require("php-excel.class.php");
            $xls = new Excel_XML();
            array_unshift($CID, array("Lieu","Date","Heure","Client","Coach"));
            $xls->addWorksheet('Coaching ' . USRV, $CID);
            $xls->sendWorkbook('Coaching' .SRV. '_' . $datef . '_' . $datet . '.xml');
        }
    }
    public function export_vcard($dbh)
    {
        // to export the vcards of all my coacheess that have a phone in the db
        dblog();
        $strsql = 'SELECT * FROM selectusers WHERE coid = ?';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        $vcards = "";
        $dtstart = DATE("Y-m-d\TH:i:s");
        
        if (!empty($CID)) {
            // export the vcards
            foreach ($CID as $myuser) {
                $vcards .= "BEGIN:VCARD
			VERSION:3.0
			REV:". $dtstart. "
			N:" . $myuser["lname"].";".$myuser["fname"].";;;
			EMAIL;TYPE=WORK,INTERNET:".$myuser["email"]."
			ORG:".USRV.";;
			X-HF:".$myuser["HF"] ."
			X-TAG:".$myuser["tag"] ."
			X-CRKEY:".$myuser["crkey"] ."
			NOTE:Coaching: ". $myuser["nsess"] . " sessions suivies/bookées sur " . $myuser["cnum"]."\\nX-HF:".$myuser["HF"] ."\\nX-TAG:".$myuser["tag"] ."\\nX-CRKEY:".$myuser["crkey"] ."
			FN:". $myuser["fname"] . " ".$myuser["lname"] . "
			TEL;TYPE=CELL:+32" . substr($myuser["phone"], 1, 9) ."
			END:VCARD\n";
            }
        }
        // output
        $filename = "VCards".SRV."for".$this->fname.".vcf";
        Header("Content-Length: ".strlen($vcards));
        //Header("Connection: close");
        Header("Content-Type: text/x-vcard; charset=utf-8");
        Header("Content-Disposition: attachment; filename=$filename");
        echo $vcards;
        exit();
    }
    
    public function echo_next_coachings($dbh)
    {
        dblog();
        
        $strsql = 'SELECT cwdate, loc, salle, group_concat(concat (fname," ",lname) ORDER BY slid SEPARATOR ", ") as parts,
		 group_concat(IFNULL(`phone`,"-") ORDER BY slid SEPARATOR ", ") as phones
 		FROM allcoachings WHERE cwdate >= curdate() AND coid = ? GROUP BY cwdate LIMIT 5';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid,
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            echo "<p>Voici vos " . count($CID) . " prochaines sessions de coaching :</p>";
            echo '<div class="ltable">';
            foreach ($CID as $cwdate) {
                echo '<div class="trow">Le ' . strftime("%A %d %B %Y", strtotime($cwdate ["cwdate"])) . ' à ' . $cwdate ["loc"]
                . " (" . ($cwdate["salle"] == null ? 'Pas de salle précisée' : $cwdate["salle"]) . ')</div>
			<div class = "trow"><em>' . $cwdate["parts"] . '</em></div>
			<div class = "trow"><em>' . $cwdate["phones"] . '</em></div>
			<div class="trow"> 
			<FORM ACTION="mng.php" METHOD="post">
			<INPUT TYPE="hidden" NAME="step" VALUE="update_salle">
 			<INPUT TYPE="hidden" NAME="debug" VALUE="' . DEBUGLEVEL . '">
			<INPUT TYPE="hidden" NAME="uid" VALUE="' . filter_var($_SESSION ['uid'],FILTER_VALIDATE_INT) . '">
			<INPUT TYPE="hidden" NAME="coid" VALUE="' . $this->coid . '">
			<INPUT TYPE="hidden" NAME="cdat" VALUE="' . $cwdate ["cwdate"] . '">
			<INPUT TYPE="text" NAME="salle" SIZE="30" VALUE="' . ($cwdate["salle"] == null ? 'Pas de salle précisée' : $cwdate["salle"]) . '">
			<INPUT TYPE="submit" VALUE="Mettre à jour">
			</FORM>
			<FORM ACTION="mng.php" METHOD="post">
			<INPUT TYPE="hidden" NAME="step" VALUE="ask_salle">
 			<INPUT TYPE="hidden" NAME="debug" VALUE="' . DEBUGLEVEL . '">
			<INPUT TYPE="hidden" NAME="uid" VALUE="' . filter_var($_SESSION ['uid'],FILTER_VALIDATE_INT) . '">
			<INPUT TYPE="hidden" NAME="coid" VALUE="' . $this->coid . '">
			<INPUT TYPE="hidden" NAME="cdat" VALUE="' . $cwdate ["cwdate"] . '">Demander aux participants de trouver une salle
			<INPUT TYPE="submit" VALUE="Demander">
			</FORM>
					</div><hr />';
            }
            echo "</div>";
        } else {
            echo "<p>Pas de prochaine session de coaching qui soit déjà planifiée.</p>";
        }
    }
    public function transfer_coach($dbh, $c_old, $c_new, $myusid)
    {
        dblog("Transfert de ".$myusid. " de coid ".$c_old." vers coid " . $c_new);
        // récupération des transferts à effectuer
        $strsql = "SELECT a.avid, a.cavid AS old_cavid, c.cavid AS new_cavid FROM cavail AS c JOIN availabilities AS a ON a.cdat = c.cdat AND a.slid = c.slid 
			AND a.coid = ? AND a.usid = ? WHERE c.coid = ? AND CONCAT (c.cdat,"-",c.slid) IN (SELECT CONCAT(a.cdat,"-", a.slid) 
			FROM availabilities AS a WHERE a.usid = ?) ";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $c_old,
                    $myusid,
                    $c_new,
                    $myusid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // destruction des availabilities précédentes
        $strsql = "DELETE FROM avail WHERE usid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $myusid
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // changement de coach
        $strsql = "UPDATE users SET coid = ? WHERE usid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $c_new,
                    $myusid
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // injection des nouvelles availabilities
        $newa = 0;
        foreach ($CID as $avail) {
            $newa++;
            $strsql = "INSERT INTO avail (usid,cavid) VALUES (?,?)";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                    $myusid,
                    $avail["new_cavid"]
            ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
        }
        // envoi d'un email de confirmation
        // get the new coach
        $strsql = "SELECT * FROM coach WHERE coid = ? LIMIT 1";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $c_new
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // get the full user data
        $strsql = "SELECT * FROM users WHERE usid = ? LIMIT 1";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $myusid
            ));
            $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // compose the email
        $strsql = "<p>Bonjour " . $CID2["fname"] . " " . $CID2["lname"] . ",</p>
<p>Nous avons bien reçu votre demande, et j'ai le plaisir de vous confirmer que je suis désormais votre coach dans le cadre du suivi de la formation-accompagnement au management.</p>
<p>Je vous demande de bien vouloir mettre vos disponibilités à jour dans notre application de coaching.</p>
<p>Pourquoi ?<br/>Chaque coach a un calendrier différent. Si par chance des disponibilités étaient communes entre votre ancien et nouveau coach, elles ont été transférées et vous les retrouverez déjà encodées dans l'application.</p>
<p>Vous pouvez dès maintenant accéder à vos données via le lien suivant : ".
'<a href="https://coaching'.SRV.'.lateral.be/?uid=' . $CID2["crkey"] . '">https://coaching'.SRV.'.lateral.be/?uid=' .$CID2["crkey"] ."</a>. Merci de les mettre à jour.</p>
<p>Je me réjouis de vous retrouver lors d'une session de coaching.</p>
<p>" . $CID["fname"] . " " . $CID["lname"] ."</p>" . MAILSIG .
"<br />" . $CID["phone"] ."<br />". $CID["email"] ."</p>";
        sendLatEmail(
            $CID["email"],
            $CID["fname"] . " " . $CID["lname"] . " (".CTR.")",
                $CID2["email"],
            "[" . USRV . "] Coaching de suivi - attribution d'un nouveau coach ",
            $strsql
        );
        
        return($newa);
    }
    
    public function sendlinkuser($dbh, $myusid)
    {
        dblog("Envoyer le lien à ".$myusid);
        // get the full user data
        $strsql = "SELECT * FROM users WHERE usid = ? LIMIT 1";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $myusid
            ));
            $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // get the new coach
        $strsql = "SELECT * FROM coach WHERE coid = ? LIMIT 1";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $CID2["coid"]
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }

        // compose the email
       
        $strsql = "<p>Bonjour " . $CID2["fname"] . ",</p>
<p>Vous recevez ce courriel pour vous confirmer que vous pouvez bénéficier de séances de coaching au sein " .DUDELA . " " .  USRV. ".</p><p>Les disponibilités de votre coach sont
accessibles au moyen d'une application, grâce à laquelle vous pouvez indiquer les disponibilités qui vous conviennent également, en utilisant le lien suivant : " .
'<a href="https://coaching'.SRV.'.lateral.be/?uid=' . $CID2["crkey"] . '">https://coaching'.SRV.'.lateral.be/?uid=' .$CID2["crkey"] ."</a>. Comme ce lien est personnel, je vous remercie de ne pas le partager.</p>
<p>Vous pouvez l'utiliser à chaque fois que vous voulez ajouter ou supprimer vos disponibilités.</p>
<p>Les données de base demandées dans cette application sont :</p>
<ul>
	<li>Votre numéro de téléphone portable (pour les communications urgentes).</li>";
if (LOCSGT1) {
            $strsql .= "<li>Les localisations que vous estimez possibles pour les sessions de coaching (plus il y en a, plus c'est possible de trouver une session de coaching rapidement).</li>";
        }
        $strsql .= "<li>Toutes vos <strong>disponibilités</strong> pour les sessions de coaching.</li>
</ul>
<p>Les règles de fonctionnement :</p>
<ul>
	<li>Vous pouvez bénéficier de <strong>" . $CID2["cnum"] . "</strong> séances de coaching.</li>";
if (NMINPDAY > 1) {
            $strsql .= "<li>Il suffit que " . NMINPDAY . " participants aient réservé " . NMINPDAY . " tranches horaires successives d'un même jour pour que ces sessions puissent être confirmées - <strong>choisissez donc de manière à consolider les dates déjà -presque- remplies : celles-ci sont indiquées en gras dans le sondage.</strong></li>";
        }
        $strsql .= "<li>Chaque coaching concerne un ou deux problèmes pratiques que vous avez rencontrés dans votre métier de manager.</li>
	<li><strong>Le coaching est confirmé quand vous recevez une invitation formelle de ma part</strong>, par courriel et/ou par invitation dans votre calendrier électronique. Cette application n'est pas une confirmation de rendez-vous, elle sert uniquement à établir une correspondance entre vos disponibilités et les miennes.</li>
	<li><strong>Une fois confirmé, un rendez-vous de coaching ne peut plus être annulé</strong>. Ceci signifie qu'il sera porté au compte " . DUDELA . " " . USRV . ", sauf si vous trouvez un(e) remplaçant(e) pour le même jour, la même heure et le même endroit. Je vous conseille donc de mettre vos données à jour dans l'application en fonction de l'évolution de vos disponibilités réelles.</li>
</ul>
<p>Je me réjouis de vous retrouver lors d'une future séance de coaching.</p>
<p>
<p>Bien cordialement,</p>
<p>" . $CID["fname"] . " " . $CID["lname"] ."</p>" .
MAILSIG ."<br />" . $CID["phone"] ."<br />". $CID["email"] ."</p>";
        $msent = sendLatEmail($CID["email"], $CID["fname"] . " " . $CID["lname"] . " (".CTR.")", $CID2["email"], "[" . USRV . "] Coaching de suivi - lien d'accès à l'application ", $strsql);
        
        return($msent ? 1 : 0);
    }
    public function sendalllinkstome($dbh)
    {
        dblog("Envoyer les liens au coach ".$this->coid);
        // get the full user data
        $strsql = "SELECT fname, lname, email, phone, crkey, nsess, cnum FROM selectusers WHERE coid = ? AND nsess < cnum ORDER BY lname ASC, fname ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array($this->coid));
            $CID2 = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // compose the email
        $strsql = "<p>Bonjour " . $this->fname . " " .  $this->lname . ",</p>
<p>Voici la liste de vos utilisateurs, ainsi que les liens qui leurs permettent d'utiliser l'application de coaching : </p>" .
"<table><tr><td>Prénom</td><td>Nom</td><td>email</td><td>téléphone</td><td>session utilisées</td><td>lien</td></tr>";
        foreach ($CID2 as $coachee) {
            $strsql .= '<tr><td>' . $coachee["fname"] .  '</td><td>' . $coachee["lname"] .  '</td><td>' . $coachee["email"] .  '</td><td>'
                    . $coachee["phone"] .  '</td><td>' . $coachee["nsess"] . " sur " . $coachee["cnum"] .  '</td><td><a href="https://coaching'.SRV.'.lateral.be/?uid=' . $coachee["crkey"] .
                    '">https://coaching'.SRV.'.lateral.be?/uid=' .$coachee["crkey"] .'</a></td></tr>';
        }
        $strsql .= '</table>';
        $strsql .= "<p>Chacun de ces liens est personnel.</p>
<p>
<p>Bien cordialement,</p>
<p>Patrick Demaret</p>"
.MAILSIG."<br />0475/649901<br />patrick@lateral.be</p>";
        $msent = sendLatEmail(
            "patrick@lateral.be",
            "Patrick Demaret (".CTR.")",
            $this->email,
                "[" . USRV . "] Coaching de suivi - lien d'accès à l'application pour tes clients ",
            $strsql
        );
        
        return($msent ? 1 : 0);
    }
    public function generateuuids($dbh)
    {
        dblog("générer les UUIDs");
        // get the full user data
        $strsql = "SELECT usid, foreignkey AS fkey FROM users ORDER BY usid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute();
            $CID2 = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // compose the email
        $strsql = "<p>Bonjour " . $this->fname . " " .  $this->lname . ",</p>
<p>Voici le code sql pour mettre à jour les uuids des utilisateurs : </p>" ;
        foreach ($CID2 as $coachee) {
            $strsql .= 'UPDATE users SET crkey = "' . fkey_encode($coachee["fkey"]) .  '" WHERE usid = ' . $coachee["usid"] . ";<br />";
        }
        $strsql .= "<p>Chacun de ces liens est personnel.</p>
<p>
<p>Bien cordialement,</p>
<p>Patrick Demaret</p>" . MAILSIG .
"<br />0475/649901<br />patrick@lateral.be</p>";
        $msent = sendLatEmail(
            "patrick@lateral.be",
            "Patrick Demaret (".CTR.")",
            $this->email,
                "[" . USRV . "] Coaching de suivi - lien d'accès à l'application pour tes clients ",
            $strsql
        );
        
        return($msent ? 1 : 0);
    }
    
    public function optoutuser($dbh, $myusid)
    {
        dblog("Opt-out de ".$myusid);
        // select how many sessions myusid had
        $strsql = "SELECT nsess FROM sessbyuser WHERE usid = ? LIMIT 1";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $myusid
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // changement du nombre de sessions permises au nombre déjà reçu
        $strsql = "UPDATE users SET cnum = ? WHERE usid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $CID["nsess"],
                    $myusid
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // envoi d'un email de confirmation
        // get the full user data
        $strsql = "SELECT * FROM users WHERE usid = ? LIMIT 1";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $myusid
            ));
            $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // compose the email
        $strsql = "<p>Bonjour " . $CID2["fname"] . " " . $CID2["lname"] . ",</p>
<p>Nous avons bien reçu votre demande, et nous vous confirmons que vous avez été retiré de notre application de coaching.</p>
<p>Si vous changiez d'avis dans le futur, n'hésitez pas à nous envoyer un email à ce sujet.</p>
<p>Bien cordialement,</p>
<p>" . $this->fname . " " . $this->lname ."</p>" . MAILSIG .
"<br />" . $this->phone ."<br />". $this->email ."</p>";
        sendLatEmail($this->email, $this->fname. " " . $this->lname. " (".CTR.")", $CID2["email"], "[" . USRV . "] Coaching de suivi - désinscription ", $strsql);
        
        return(1);
    }
    public function update_salle($dbh, $mycdat, $mycoid, $mysalle, $gservice)
    {
        dblog();
        $strsql = "UPDATE cwho SET salle = ? WHERE coid = ? AND cwdate = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $mysalle,
                    $mycoid,
                    $mycdat
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // update the related google events
        $strsql = "SELECT google_id FROM cwho WHERE coid = ? AND cwdate = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $mycoid,
                    $mycdat
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        foreach ($CID as $gid) {
            if ($gid["google_id"] !== null) {
                ModifyEventLocation($gid["google_id"], $mysalle, $gservice) ;
            }
        }
        
        return;
    }
    public function echo_nsessions($dbh, $fkey)
    {
        dblog();
        
        $strsql = "SELECT * FROM allcoachings WHERE cwdate >= curdate() AND coid = ? order by cwdate, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            echo "<p>Voici les futures sessions de coaching telles qu'enregistrées.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="modify_sessions">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            echo '<div class="ltable">';
            echo '<div class="trow"><div class="tcell ca">Lieu</div><div class="tcell ca">Date</div><div class="tcell ca">
					Heure</div><div class="tcell ca">Client</div><div class="tcell ca">Supprimer</div>
					<div class="tcell ca">Changer de client</div></div>';
            $i = - 1;
            foreach ($CID as $ploc) {
                $i ++;
                echo '<div class="trow"><div class="tcell ca">' . $ploc ["loc"] . '</div><div class="tcell ca">' . strftime("%A %d %B %Y", strtotime($ploc ["cwdate"])) . '</div><div class="tcell ca">' . $ploc ["slot"] . '</div><div class="tcell ca">' . $ploc ["fname"] . " " . $ploc ["lname"] . '</div><div class="tcell ca">' . '<input type="checkbox" name="cwid' . $i . '" value="' . $ploc ["cwid"] . '">' . '</div></div>';
            }
            echo "</div>";
            echo '<input type="hidden" name="ncwid" value="' . $i . '">';
            echo '<input type="submit" value="Mettre à jour ces sessions de coaching"></form>';
        } else {
            echo "<p>Pas de futures sessions de coaching.</p>";
        }
    }
    
    public function echo_sessions($dbh, $fkey)
    {
        dblog();
        
        $strsql = "SELECT * FROM allcoachings WHERE cwdate >= curdate() AND coid = ? order by cwdate, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            $mytxt = "<p>Bonjour [FNAME] [LNAME],<br /><br/>
Suite à votre demande, ou au désistement des autres participants de cette journée, votre session de coaching planifiée le [DATETIMESESSION]
à [LOC] ([SALLE]) ([SLOT]) est annulée.<br/>
Sachez que j'en suis vraiment désolé.<br/>N'hésitez pas à vous rendre disponible pour d'autres dates en utilisant le lien suivant :<br />".
'<a href="https://coaching'.SRV.'.lateral.be/?uid=[FKEY]">https://coaching'.SRV.'.lateral.be/?uid=[FKEY]</a><br/><br/>' .
"Bien cordialement,<br/><br/>
[CFNAME] [CLNAME]<br/><br/>" . MAILSIG .
"<br />[CTEL]<br />[CEMAIL]</p>";
            echo "<p>Voici les futures sessions de coaching telles qu'enregistrées. Toutes les dates <strong>sélectionnées</strong> seront supprimées
				du système.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="delete_sessions">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey. '>';
            echo '<div class="ltable">';
            echo '<div class="trow"><div class="tcell ca">Lieu</div><div class="tcell ca">Date</div><div class="tcell ca">
					Heure</div><div class="tcell ca">Client</div><div class="tcell ca">Supprimer</div></div>';
            $i = - 1;
            foreach ($CID as $ploc) {
                $i ++;
                echo '<div class="trow"><div class="tcell ca">' . $ploc ["loc"] . '</div><div class="tcell ca">' . strftime("%A %d %B %Y", strtotime($ploc ["cwdate"])) . '</div><div class="tcell ca">' . $ploc ["slot"] . '</div><div class="tcell ca">' . $ploc ["fname"] . " " . $ploc ["lname"] . '</div><div class="tcell ca">' . '<input type="checkbox" name="cwid' . $i . '" value="' . $ploc ["cwid"] . '">' . '</div></div>';
            }
            echo "</div>";
            echo '<input type="hidden" name="ncwid" value="' . $i . '">';
            echo "<hr />Voici le texte qui sera envoyé. Le texte entre [] comme [NAME] sera remplacé par le texte correspondant au participant. Merci de ne pas modifier.<br/>";
            echo '<textarea id="mytext" name="mytext">' . $mytxt . '</textarea><br />';
            echo '<input type="submit" value="Mettre à jour ces sessions de coaching"></form>';
        } else {
            echo "<p>Pas de futures sessions de coaching.</p>";
        }
    }
    public function prepare_end_email($dbh, $fkey)
    {
        dblog();
        $strsql = "SELECT * FROM allcoachings WHERE cwdate >= curdate() AND coid = ? order by cwdate, slid ASC";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            $mytxt = "<p>Bonjour [FNAME] [LNAME],<br /><br/>
Suite à votre demande, ou au désistement des autres participants de cette journée, votre session de coaching planifiée le [DATETIMESESSION]
à [LOC] ([SALLE]) ([SLOT]) est annulée.<br/>
Sachez que j'en suis vraiment désolé.<br/>N'hésitez pas à vous rendre disponible pour d'autres dates en utilisant le lien suivant :<br />".
'<a href="https://coaching'.SRV.'.lateral.be/?uid=[FKEY]">https://coaching'.SRV.'.lateral.be/?uid=[FKEY]</a><br/><br/>' .
"Bien cordialement,<br/><br/>
[CFNAME] [CLNAME]<br/><br/>" . MAILSIG .
"<br />[CTEL]<br />[CEMAIL]</p>";
            echo "<p>Voici les futures sessions de coaching telles qu'enregistrées. Toutes les dates <strong>sélectionnées</strong> seront supprimées
				du système.</p>";
            echo '<form action="mng.php" method="post">';
            echo '<input type="hidden" name="step" value="delete_sessions">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            echo '<div class="ltable">';
            echo '<div class="trow"><div class="tcell ca">Lieu</div><div class="tcell ca">Date</div><div class="tcell ca">
					Heure</div><div class="tcell ca">Client</div><div class="tcell ca">Supprimer</div></div>';
            $i = - 1;
            foreach ($CID as $ploc) {
                $i ++;
                echo '<div class="trow"><div class="tcell ca">' . $ploc ["loc"] . '</div><div class="tcell ca">' . strftime("%A %d %B %Y", strtotime($ploc ["cwdate"])) . '</div><div class="tcell ca">' . $ploc ["slot"] . '</div><div class="tcell ca">' . $ploc ["fname"] . " " . $ploc ["lname"] . '</div><div class="tcell ca">' . '<input type="checkbox" name="cwid' . $i . '" value="' . $ploc ["cwid"] . '">' . '</div></div>';
            }
            echo "</div>";
            echo '<input type="hidden" name="ncwid" value="' . $i . '">';
            echo "<hr />Voici le texte qui sera envoyé. Le texte entre [] comme [NAME] sera remplacé par le texte correspondant au participant. Merci de ne pas modifier.<br/>";
            echo '<textarea id="mytext" name="mytext">' . $mytxt . '</textarea><br />';
            echo '<input type="submit" value="Mettre à jour ces sessions de coaching"></form>';
        } else {
            echo "<p>Pas de futures sessions de coaching.</p>";
        }
    }
    
    public function skim_dropmsg($dbh)
    {
        dblog();
        // update max group_conct answer
        $strsql = "SET SESSION group_concat_max_len = ?;";
        echolog("D", "Setting max value of group reply to 3600");
        //
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(3600));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        $strsql = "SELECT
	s.usid AS usid,
   `s`.`fname` AS `fname`,
   `s`.`lname` AS `lname`,
   `s`.`email` AS `email`,
   `s`.`coach` AS `coach`,
   `s`.`coachemail` AS `coachemail`,
   `s`.`coachphone` AS `coachphone`,
s.active as active,
   `s`.`crkey` AS `crkey`,concat('<ul><li>',group_concat(concat('le ',date_format(`d`.`cdat`,'%W %e %M %Y'),' de ',`d`.`hb`,' à ',`d`.`hf`) order by `d`.`cdat` ASC,`d`.`hb` ASC separator '</li><li>'),'</li></ul>') AS `html`,group_concat(`d`.`id` separator ',') AS `listids`
FROM (`dropmsg` `d` join `selectusers` `s` on((`s`.`usid` = `d`.`usid`))) where ((`d`.`sent` is not true) and (`d`.`cdat` >= curdate())) group by `s`.`email`";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute();
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // send an email to all participants
        $nrp = 0;
        foreach ($CID as $myuser) {
            //send good news as well
            // get the coaching future for this person
            
            $strsql = 'SELECT cwdate as "Date", loc as "Lieu", slot as "Séance", concat(cfname," ",clname) as "Coach"
				FROM allcoachings WHERE cwdate >= curdate() AND usid = ? order by cwdate, slid ASC';
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $myuser["usid"]
                ));
                $CID2 = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
                
            //dblog("skimming ". $myuser["lname"]);
            // compose the email
            $strsql = "<p>Bonjour " . $myuser["fname"] . " " . $myuser["lname"] . ",</p>
<p>Je vous remercie de m'avoir communiqué vos disponibilités via l'application de coaching.</p>
<p>En raison de la programmation globale des sessions de coaching, les disponibilités suivantes que vous avez enregistrées
dans le système peuvent être libérées : " .
$myuser["html"];
            
            if (!empty($CID2)) {
                $strsql .= "<p>Voici vos prochaines sessions de coaching programmées : <ul>";
                foreach ($CID2 as $ploc) {
                    $strsql .= '<li>le ' . strftime("%A %e %B %Y", strtotime($ploc ["Date"])) . ' à ' . $ploc ["Lieu"] . ' de ' . str_replace("-", "à", $ploc ["Séance"]) . '</li>';
                }
                $strsql .= '</ul>';
            }
            if ($myuser[active] == 1) {
                $strsql .= "<p>Si vous voulez mettre à jour vos disponibilités, voici le lien à utiliser : " .
                        '<a href="https://coaching'.SRV.'.lateral.be/?uid=' . $myuser["crkey"] . '">https://coaching'.SRV.'.lateral.be/?uid=' . $myuser["crkey"] . '</a>' . "</p>";
            } else {
                $strsql .= "<p>Vous avez utilisé toutes vos opportunités de coaching dans le cadre de cette formation. 
J'espère que vous aurez apprécié l'utilité de ces sessions.</p>";
            }

            $strsql .= "<p>Bien cordialement,</p>
<p>" . $myuser["coach"] ."</p>" . MAILSIG .
"<br />" .  $myuser["coachphone"]."<br />". $myuser["coachemail"]."</p>";
            $issent = sendLatEmail($myuser["coachemail"], $myuser["coach"]. " (".CTR.")", $myuser["email"], "[" . USRV . "] Coaching de suivi - libération de certaines de vos disponibilités ", $strsql);
            //$issent = 0;
            $nrp += ($issent ? 1 : 0);
            // indicate as sent
            if (true) {
                $strsql = "UPDATE dropmsg SET sent = 1 WHERE id IN ( ". $myuser["listids"] . ")";
                try {
                    //dblog("Updating dropmsg ". $strsql. " with (" . $myuser["listids"] . ")");
                    $sth = $dbh->prepare($strsql);
                    $sth->execute();
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
            }
        }
        return($nrp);
    }
    public function update_cavails($dbh, $cavails, $gservice)
    {
        dblog();
        
        // all the cavids existing must be compared to $cavails to know which one is kept.
        foreach ($this->cavails as $old_cavail) {
            echolog("D", "Treating now old cavail " . $old_cavail ["cavid"]);
            $cavail_found = false;
            foreach ($cavails as $new_cavail) {
                echolog("D", "Comparing with new cavail " . $new_cavail ["cavid"]);
                echolog("D", ($old_cavail ["cavid"] == $new_cavail ["cavid"]) ? "Found" : "Not found");
                $cavail_found = ($cavail_found) || ($old_cavail ["cavid"] == $new_cavail ["cavid"]);
                echolog("D", $cavail_found);
            }
            $cavid = $old_cavail ["cavid"] ;
            if ($cavail_found == false) {
                // delete this old cavail !
                echolog("D", "Cavid " . $cavid . " not present anymore and will be deleted");
                // Store the drop message to send to people
                store_dropmsg($dbh, $cavid, null);
                // get event id from cavail
                $strsql = "SELECT * FROM cavail WHERE cavid = ? LIMIT 1";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $cavid
                    ));
                    $CID = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                $iCaluid = $CID ["uuid"];
                // delete cavid
                $strsql = "DELETE FROM cavail WHERE cavid = ?";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $old_cavail ["cavid"]
                    ));
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                // get the remaining count of cavids for the same day and the same coach
                $strsql = "SELECT COUNT(cavid) AS cc FROM cavail WHERE coid = ? AND cdat = ?";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $CID ["coid"],
                        $CID ["cdat"]
                    ));
                    $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                dblog($CID2["cc"] . " cavids left");
                // if none left, delete the google event
                dblog("Ref. Google Id  = " . $CID["google_id"]);
                $event_id = GetEventId($iCaluid, $gservice);
                dblog("Google Event Id = " . $event_id);
                if ($CID2["cc"] == 0) {
                    // check if this event still exists
                    //$event_id = $CID ["google_id"];
                    if ($event_id !== 0) {
                        if ($CID["google_id"] === $event_id) {
                            $event = $gservice->events->delete(CALENDAR_ID, $event_id);
                            dblog("Event deleted !");
                        } else {
                            dblog("Event NOT deleted");
                        }
                    }
                } else {
                    // update end and beginning
                    $strsql = "SELECT MIN(slid) AS minslid FROM cavail WHERE coid = ? AND cdat = ?";
                    try {
                        $sth = $dbh->prepare($strsql);
                        $sth->execute(array(
                            $CID ["coid"],
                            $CID ["cdat"]
                        ));
                        $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
                        $sth->closeCursor();
                    } catch (PDOException $e) {
                        echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                        exit();
                    }
                    $minslid = $CID2["minslid"];
                    $strsql = "SELECT MAX(slid) AS maxslid FROM cavail WHERE coid = ? AND cdat = ?";
                    try {
                        $sth = $dbh->prepare($strsql);
                        $sth->execute(array(
                            $CID ["coid"],
                            $CID ["cdat"]
                        ));
                        $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
                        $sth->closeCursor();
                    } catch (PDOException $e) {
                        echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                        exit();
                    }
                    $maxslid = $CID2["maxslid"];
                    // Get the slots
                    // get meeting start and end from the slid
                    $strsql = "SELECT hb FROM slots WHERE slid = ? LIMIT 1";
                    try {
                        $sth = $dbh->prepare($strsql);
                        $sth->execute(array(
                            $minslid
                        ));
                        $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
                        $sth->closeCursor();
                    } catch (PDOException $e) {
                        echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                        exit();
                    }
                    $minslid = $CID2["hb"];
                    $strsql = "SELECT hf FROM slots WHERE slid = ? LIMIT 1";
                    try {
                        $sth = $dbh->prepare($strsql);
                        $sth->execute(array(
                            $maxslid
                        ));
                        $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
                        $sth->closeCursor();
                    } catch (PDOException $e) {
                        echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                        exit();
                    }
                    $maxslid = $CID2["hf"];
                    //
                    ModifyEventTiming($event_id, $CID["cdat"], $minslid, $maxslid, $gservice);
                }
            } else {
                echolog("D", "Cavid " . $cavid . " is found and will be kept");
            }
        }
    }
    public function print_presence($dbh, $pdate, $coid)
    {
        dblog();
        
        $strsql = "SELECT * FROM allcoachings WHERE cwdate = ? and coid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $pdate,
                    $coid
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        include("../fpdf-utf8/tfpdf.php");
        include("../fpdf-utf8/myfpdf.php");
        
        $pdf = new myFPDF('P', 'mm', 'a4');
        $pdf->SetDisplayMode("fullpage", "single");
        $pdf->SetAutoPageBreak(true);
        $pdf->AliasNbPages();
        $pdf->AddPage();
        $pdf->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
        $pdf->SetAuthor("Lateral SPRL");
        $pdf->SetCreator("www.fpdf.org");
        $pdf->SetSubject("Liste des présences coaching de suivi ".USRV." du " . strftime("%A %d %B %Y", strtotime($pdate)) . " à " . $CID [0] ["loc"], true);
        $pdf->SetTitle("Liste des présences coaching de suivi ".USRV." du " . strftime("%A %d %B %Y", strtotime($pdate)) . " à " . $CID [0] ["loc"], true);
        $pdf->SetFont('DejaVu', '', 16);
        $pdf->SetXY(20, 30);
        $pdf->MultiCell(0, 16, "Coaching de suivi de la Formation Initiale de Manager", 0, 'L', '');
        $pdf->SetFont('DejaVu', '', 12);
        $pdf->SetXY(20, 40);
        $pdf->MultiCell(0, 12, "Sessions du " . strftime("%A %d %B %Y", strtotime($pdate)) . " à " . $CID [0] ["loc"], 0, 'L', '');
        $pdf->SetXY(20, 60);
        $pdf->SetWidths(array(
                55,
                55,
                55
        ));
        $pdf->SetAligns(array(
                'L',
                'L',
                'L'
        ));
        $pdf->Row(array(
                "Heure\n",
                "Nom\n",
                "Signature\n"
        ));
        foreach ($CID as $ploc) {
            $pdf->SetX(20);
            $pdf->Row(array(
                    "\n\n\n" . $ploc ["slot"] . "\n\n\n",
                    "\n\n\n" . $ploc ["fname"] . " " . $ploc ["lname"] . "\n\n\n",
                    "\n"
            ));
        }
        $pdf->Image(CTR.'logo.png', 150, 10, - 150);
        $pdf->Image(SRV .'logo.png', 20, 10, - 150);
        if (SRV === "forem") {
            $pdf->Image('FSEForem.png', 20, 260, - 200);
        }
        $pdf->SetXY(20, $pdf->GetY() + 10);
        $pdf->MultiCell(0, 12, "Le formateur : " . $this->fname . " " . $this->lname . " (". CTR . ")", 0, 'L', '');
        $pdf->SetXY(20, $pdf->GetY() + 10);
        $pdf->MultiCell(0, 12, "Signature : ", 0, 'L', '');
        $pdf->Output("Coaching ". USRV . " du " . strftime("%A %d %B %Y", strtotime($pdate)) . " à " . $CID [0] ["loc"] . ".pdf", "I");
    }
    public function update_sessions($dbh, $gservice, $ncwids, $mytxt)
    {
        dblog($ncwids);
        // all the cwids received here will be deleted
        foreach ($ncwids as $cwid) {
            // remove from calendar first
            delete_event($dbh, $cwid ["cwid"], $gservice);
            // get who was involved
            $strsql = "SELECT fname, lname, cwdate, salle, loc, email, slot, cfname, clname, cemail, Tel, fkey, crkey FROM allcoachings WHERE cwid = ? LIMIT 1";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $cwid ["cwid"]
                ));
                $CID = $sth->fetch(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            // prepare an email to warn the participant that the meeting has been cancelled
            // compose the email
            dblog($mytxt);
            if ($mytxt == "-1") {
                $strsql = "<p>Bonjour " . $CID["fname"] . " " . $CID["lname"] . ",</p>
<p>Suite à votre demande, ou au désistement des autres participants de cette journée, votre session de coaching planifiée "
. "le ". strftime("%A %d %B %Y", strtotime($CID["cwdate"])) . " entre " . $CID["slot"] .
" à " . $CID["loc"] . ($CID["salle"] == null) ? "" : " - " . $CID["salle"] . " est annulée.</p>
<p>Sachez que j'en suis vraiment désolé.</p><p>N'hésitez pas à vous rendre disponible pour d'autres dates en utilisant le lien suivant :<br />" .
'<a href="https://coaching'.SRV.'.lateral.be/?uid=' . $CID["crkey"]. '">https://coaching'.SRV.'.lateral.be/?uid=' . $CID["crkey"]. '</a>' . "</p>
<p>Bien cordialement,</p>
<p>" . $CID["cfname"] . " " . $CID["clname"]."</p>" .MAILSIG .
"<br />" . $CID["Tel"] ."<br />". $CID["cemail"] ."</p>";
            } else {
                $strsql = str_replace('[FNAME]', $CID["fname"], $mytxt);
                $strsql = str_replace('[LNAME]', $CID["lname"], $strsql);
                $strsql = str_replace('[DATETIMESESSION]', strftime("%A %d %B %Y", strtotime($CID["cwdate"])), $strsql);
                $strsql = str_replace('[LOC]', $CID["loc"], $strsql);
                $strsql = str_replace('[SLOT]', $CID["slot"], $strsql);
                $strsql = str_replace('[SALLE]', ($CID["salle"] == null) ?" Salle non encore déterminée " : $CID["salle"], $strsql);
                $strsql = str_replace('[FKEY]', $CID["crkey"], $strsql);
                $strsql = str_replace('[CFNAME]', $CID["cfname"], $strsql);
                $strsql = str_replace('[CLNAME]', $CID["clname"], $strsql);
                $strsql = str_replace('[CTEL]', $CID["Tel"], $strsql);
                $strsql = str_replace('[CEMAIL]', $CID["cemail"], $strsql);
            }
            dblog($strsql);
            sendLatEmail(
            $CID["cemail"],
            $CID["cfname"]. " " . $CID["clname"] ,
            $CID["email"],
        "[" . USRV . "] Coaching de suivi - annulation de session",
            $strsql
        );
                    
            // delete this cwid from db
            echolog("D", "Cwid " . $cwid ["cwid"] . " not present anymore and will be deleted");
            $strsql = "DELETE FROM cwho WHERE cwid = ?";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $cwid ["cwid"]
                ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
        }
    }
    public function update_user_tag($dbh, $fkey, $tagid)
    {
        dblog("tagid = " . $tagid);
        
        $strsql = "SELECT COUNT(foreignkey) as nfk FROM users WHERE foreignkey = ?";
        echolog("D", "Checking existence of previous fkey  " . $fkey);
        // first check if it already exists...
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $fkey
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if ($CID ["nfk"] > 0) {
            // existing, update
            $strsql = "UPDATE users SET tag = ? WHERE foreignkey = ?";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $tagid,
                        $fkey
                ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
        }
        return (($CID ["nfk"] > 0) ? 1 : 0);
    }
    public function insert_user($dbh, $fkey, $fname, $lname, $email, $HF, $tu, $tagid, $mycoid)
    {
        dblog("Inserting " . $email);
        
        $strsql = "SELECT COUNT(foreignkey) as nfk FROM users WHERE foreignkey = ?";
        echolog("D", "Checking existence of previous fkey  " . $fkey);
        // first check if it already exists...
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $fkey
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if ($CID ["nfk"] == 0) {
            // compose the crkey from the fkey
            $strsql = "INSERT INTO users (foreignkey,fname,lname,email,HF,coid,cnum,tag,crkey) VALUES (?,?,?,?,?,?,?,?,?) ";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $fkey,
                        $fname,
                        $lname,
                        $email,
                        $HF,
                        $mycoid,
                        NMAXSESS,
                        $tagid,
                        fkey_encode($fkey)
                ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            // get back the usid
            $strsql = "SELECT usid FROM users WHERE foreignkey = ? LIMIT 1";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $fkey
                ));
                $CID2 = $sth->fetch(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            // insert at least one location : Charleroi
            $strsql = "INSERT INTO wwhere (loid,usid) VALUES (?,?)";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        1,
                        $CID2["usid"]
                ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
        }
        return (($CID ["nfk"] == 0) ? 1 : 0);
    }
    public function select_emails($dbh, $mynsmin, $mynsmax, $myloid, $mycoid, $myincl)
    {
        dblog("Session #:" . $mynsmin . "-" . $mynsmax . " - Location : " . $myloid . " - Coach : " . $mycoid . " - include : " . $myincl);
        $strsql = "SET SESSION group_concat_max_len = 2048";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute();
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // update max group_conct answer
        $strsql = "SET SESSION group_concat_max_len = ?;";
        echolog("D", "Setting max value of group reply to 3600");
        //
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(3600));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        //
        $strsql = "select GROUP_CONCAT(DISTINCT email SEPARATOR '<br/>') AS collected_emails, coid FROM users AS u ";
        //$strsql = "select DISTINCT email, coid FROM users AS u ";
        if ($myloid != 0) {
            $strsql .= " JOIN wwhere AS ww ON ww.usid = u.usid AND ww.loid = " . $myloid;
        }
        $strsql .= " JOIN sessbyuser AS sbu ON sbu.usid = u.usid AND sbu.nsess >= " . $mynsmin ." AND sbu.nsess <= " . $mynsmax ;
        if ($mycoid != 0) {
            $strsql .= " WHERE coid = " . $mycoid . " AND LOWER(email) LIKE '%".EMAIL."'";
        } else {
            $strsql .= " WHERE LOWER(email) LIKE '%".EMAIL."'";
        }
        if ($myincl === "no") {
            $strsql .= " AND sbu.nsess < u.cnum";
        }
        $strsql .= " GROUP BY coid";
        echolog("D", "Selecting the emails grouped by coach");
        //
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute();
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        return ($CID);
    }
    public function add_cavails($dbh, $cavdates, $gservice)
    {
        dblog("dates : " . $cavdates);
        
        $delim = ",/. ";
        $tok = strtok($cavdates, $delim);
        $ndates = 0;
        $ncins = 0;
        while ($tok !== false) {
            $ndates++;
            $cinserted = false;
            $meeting_id = uuid_v4();
            for ($slid = SLOTINI; $slid <= SLOTEND; $slid ++) {
                $strsql = "SELECT COUNT(cavid) as nc FROM cavail WHERE cdat = ? AND slid = ? and coid = ?";
                echolog("D", "Checking existence of previous cavail at date " . $tok . "and slid " . $slid);
                // first check if it already exists...
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                            $tok,
                            $slid,
                            $this->coid
                    ));
                    $CID = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                if ($CID ["nc"] == 0) {
                    $cinserted = true;
                    $ncins++;
                    echolog("D", "Inserting new cavail at date " . $tok . "and slid " . $slid);
                    $strsql = "INSERT INTO cavail (cdat,slid,coid,uuid) VALUES (?,?,?,?)";
                    try {
                        $sth = $dbh->prepare($strsql);
                        $sth->execute(array(
                                $tok,
                                $slid,
                                $this->coid,
                                $meeting_id
                        ));
                        $sth->closeCursor();
                    } catch (PDOException $e) {
                        echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                        exit();
                    }
                } else {
                    // check if there is a uuid, if not, insert it again !
                    echolog("D", "Inserting new cavail at date " . $tok . "and slid " . $slid);
                    $strsql = "SELECT uuid, cavid FROM cavail WHERE cdat = ? AND slid = ? and coid = ?";
                    try {
                        $sth = $dbh->prepare($strsql);
                        $sth->execute(array(
                                $tok,
                                $slid,
                                $this->coid
                        ));
                        $CID = $sth->fetch(PDO::FETCH_ASSOC);
                        $sth->closeCursor();
                    } catch (PDOException $e) {
                        echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                        exit();
                    }
                    if ($CID ["uuid"] == null) {
                        // create the uuid !
                        $strsql = "UPDATE cavail set uuid = ? WHERE cavid = ?";
                        try {
                            $sth = $dbh->prepare($strsql);
                            $sth->execute(array(
                                    $meeting_id,
                                    $CID ["cavid"]
                            
                            ));
                            $sth->closeCursor();
                        } catch (PDOException $e) {
                            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                            exit();
                        }
                        // flag insertion
                        $cinserted = true;
                        $ncins++;
                    }
                }
            }
            
            if ($cinserted) {
                // $mail_sent = sendIcalEmail ( $this->fname, $this->lname, $this->email, $tok, "09:00", "18:00", $this->fname . " " . $this->lname . " - l'endroit exact du coaching sera décidé en fonction des participants.", "déterminer", "[Possibilité [" . USRV . "] Coaching de suivi de la formation de management", uuid_v4 (), $this->fname . " " . $this->lname, $this->phone, $this->email );
                $event = $gservice->events->insert(CALENDAR_ID, 
                        new Google_Service_Calendar_Event(
                                makeGoogleAgendaEvent($this->fname, $this->lname, $this->email, $tok, "09:00", "18:00", 
                                        $this->fname . " " . $this->lname, 
                                        MSGLOC, "[Possibilité " . USRV . "] - " . $this->fname . " - Coaching " . CTR, 
                                        $meeting_id, $this->fname . " " . $this->lname, $this->phone, $this->email)), array('sendNotifications' => false));
                $google_id = $event->getId();
                // update the google_id
                $strsql = "UPDATE cavail set google_id = ? WHERE uuid = ?";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                            $google_id,
                            $meeting_id
                    ));
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
            }
            
            $tok = strtok($delim);
        }
        return (array($ndates,$ncins));
    }
}
