<?php
// some functions first
function find_in_array($array_in, $s_key, $s_value, $t_key)
{
    // iterates through an array searching $s_key with value $s_value, returns the last value of $t_key
    // false if nothing found
    $tfound = false;
    foreach ($array_in as $suba) {
        if ($suba [$s_key] == $s_value) {
            $tfound = true;
            $t_value = $suba [$t_key];
        }
    }
    return ($tfound ? $t_value : false);
}
function get_from_array($array_in, $s_key)
{
    // iterates through an array searching $s_key with value $s_value, returns the last value of $t_key
    // false if nothing found
    $tfound = false;
    foreach ($array_in as $suba) {
        if (in_array($s_key, $suba)) {
            $tfound = true;
            $t_value = $suba [$s_key];
        }
    }
    return ($tfound ? $t_value : false);
}
function fkey_simplify($fkey)
{
    if (strlen(strval($fkey)) < 10) {
        $newkey = $fkey;
    } else {
        $newkey = substr($fkey, 0, 3) . substr($fkey, 5, 2). substr($fkey, 10, 2). substr($fkey, 17, 2);
    }
    return (intval($newkey));
}
function fkey_encode($fkey)
{
    $strkey = sprintf("%09d", $fkey);
    $crkey = substr($strkey, 0, 3) . sprintf("%01d", mt_rand(0, 9)) .'-'. substr($strkey, 3, 2) . sprintf("%02d", mt_rand(0, 99)) .
'-'.substr($strkey, 5, 2) .  sprintf("%02d", mt_rand(0, 99)).'-'. sprintf("%02d", mt_rand(0, 99)) . substr($strkey, 7, 2) ;
    return($crkey);
}

function uuid_v4()
{
    return sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            
            // 32 bits for "time_low"
            mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
            
            // 16 bits for "time_mid"
            mt_rand(0, 0xffff),
            
            // 16 bits for "time_hi_and_version",
            // four most significant bits holds version number 4
            mt_rand(0, 0x0fff) | 0x4000,
            
            // 16 bits, 8 bits for "clk_seq_hi_res",
            // 8 bits for "clk_seq_low",
            // two most significant bits holds zero and one for variant DCE1.1
            mt_rand(0, 0x3fff) | 0x8000,
            
            // 48 bits for "node"
            mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0xffff)
    );
}
function daysdiff($endDate, $beginDate)
{
    // explode the date by "-" and storing to array
    $date_parts1 = explode("-", $beginDate);
    $date_parts2 = explode("-", $endDate);
    // gregoriantojd() Converts a Gregorian date to Julian Day Count
    $start_date = gregoriantojd($date_parts1 [1], $date_parts1 [2], $date_parts1 [0]);
    $end_date = gregoriantojd($date_parts2 [1], $date_parts2 [2], $date_parts2 [0]);
    return ($end_date - $start_date);
}
function daysbetween($endDate, $beginDate)
{
    // this is the difference + 1 !
    return (1 + daysdiff($endDate, $beginDate));
}
function GetPostVar($mymethod, $mypref, $myvar, $mydef)
{
    // to retrieve a value GETted or POSTed from the page
    $myget = filter_input(INPUT_GET, $myvar, FILTER_SANITIZE_STRING)   ;  // $_GET [$myvar];
    $get_status = ($myget !== NULL and $myget !== false) ? "OK" : "NOK";
    $mypost = filter_input(INPUT_POST, $myvar, FILTER_SANITIZE_STRING)   ;  //$_POST [$myvar];
    $post_status = ($mypost !== NULL and $mypost !== false) ? "OK" : "NOK";
    
    //echo("<br />GetPostVar<br />mymethod : " . $mymethod."<br />mypref : ". $mypref."<br />myvar : ".$myvar."<br />mydef : ". $mydef."<br />");
    //echo("<br />get ".$myget."-".$get_status." | post ".$mypost."-".$post_status."<br />");
   
    // what to return
    switch (strtolower($mymethod)) {
        case "get":
            $rtv = ($get_status === "OK")  ? $myget : $mydef;
            break;
        case "post":
             $rtv = ($post_status === "OK")  ? $mypost : $mydef;
            break;
        default:
            switch (strtolower($mypref)) {
                case "get":
                    $rtv = ($get_status === "OK")  ? $myget : (($post_status === "OK") ? $mypost : $mydef);
                     break;
                case "post":
                    $rtv = ($post_status === "OK")  ? $mypost : (($get_status === "OK") ? $myget : $mydef);
                    break;
            }
            break;
    }
    //echo("Return : " . $rtv);
    return($rtv);
}
