<?php
session_start();
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified my friend
define("SQLT", 1);
define("SQLF", 0);
include("db.php");
include("basics.php");
// Verify that there is no previious session data
$fkey = GetPostVar("", "GET", "uid", 0);
if ($fkey == 0 && isset($_SESSION ['uid'])) {
    $fkey = $_SESSION ['uid'];
}
if ($fkey == 0) {
    exit();
}
    $debugl = GetPostVar("", "GET", "debug", - 1);
    if ($debugl == - 1) {
        if (isset($_SESSION ['debug'])) {
            $debugl = $_SESSION ['debug'];
        } else {
            $debugl = "F";
        }
    }
    $fkey = fkey_simplify($fkey);
    // setup session
    $_SESSION ['uid'] = $fkey;
    $_SESSION ['debug'] = $debugl;
    define("DEBUGLEVEL", strtoupper($debugl));
    
    include("utils.php");
    require_once $myautoloadpath;
    ini_set("include_path", $myincludepath . ini_get("include_path"));
    require_once("Numbers/Words.php");
    //Create a new PHPMailer instance
    //require_once("/home2/forumlat/vendor/phpmailer/phpmailer/src/PHPMailer.php");
    //require_once("/home2/forumlat/vendor/phpmailer/phpmailer/src/SMTP.php");
    //require_once("/home2/forumlat/vendor/phpmailer/phpmailer/src/Exception.php");
    use  PHPMailer\PHPMailer\PHPMailer;

    $mail = new PHPMailer;
    preparePHPMailer();
    $datef = GetPostVar("", "POST", "datef", "");
    $datet = GetPostVar("", "POST", "datet", "");
    $datef = ($datef == "" ? $datemin : $datef);
    $datet = ($datet == "" ? $datemax : $datet);
    
    echolog("D", "Including classes");
    include("coach.def.php");
    // Get the #user first
    echolog("D", "Populating the new coach");
    $coach = new Coach();
    $coach->populate($dbh, $fkey);
    $coach->get_all_active_users($dbh);
    echolog("D", "Finished populating the new user");
    
    if ($coach->superuser != 1) {
        echolog("D", "Nope");
        exit();
    } else {
        echolog("D", "Coach catched");
    }
    @dblog("Coach " . $coach->fname . " entered.");
    // set the calendar id
    define("CALENDAR_ID", $coach->calid);
    // setup Google services
    $gclient = new Google_Client();
    $gclient->setAuthConfig($myjsonsecretpath);
    $gclient->setAccessType('offline'); // offline access
    $gclient->addScope(Google_Service_Calendar::CALENDAR);
    if (isset($_SESSION ['access_token']) && $_SESSION ['access_token']) {
        // sanity check
        //if (is_array($_SESSION ['access_token'])) echolog("F","Désolé, problème avec l'authentification Google. Veuillez redémarrer le navigateur internet.");
        $gclient->setAccessToken($_SESSION ['access_token']);
        if ($gclient->isAccessTokenExpired()) {
            // refresh
            $google_token = json_decode($_SESSION ['access_token']);
            $gclient->refreshToken($google_token->refresh_token);
            $_SESSION ['access_token'] = $client->getAccessToken();
            // $gclient->refreshToken($_SESSION['access_token']->refresh_token);
            // $_SESSION['access_token']= $gclient->getAccessToken();
            // $redirect_uri = 'http://' . $_SERVER['HTTP_HOST'] . '/oauth2callback.php';
            // header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
        }
        $gservice = new Google_Service_Calendar($gclient);
        $gcalendarId = 'primary';
    } else {
        // store the POSTed and the GETed data
        $_SESSION["POSTED"] = $_POST;
        $_SESSION["GETED"] = $_GET;
        $redirect_uri = 'http://' . $_SERVER ['HTTP_HOST'] . '/oauth2callback.php';
        header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
    }
    echolog("D", "Token");
    echolog("D", $_SESSION ['access_token']);
    // setup tags from db
    // initialisation de la session - recherche des tags possibles
    $mytags = array();
    $ch = curl_init();
    // configuration des options
    curl_setopt($ch, CURLOPT_URL, "https://lateral.highrisehq.com/tags.xml");
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_USERAGENT, "Using integration API - patrick@lateral.be");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, "c6f551c0ce830bcd8328ec7460a0fa97:X");
    // exécution de la session
    if ($xmlstr = curl_exec($ch)) {
        $HRtags = new SimpleXMLElement($xmlstr);
        if (count($HRtags) != 0) {
            foreach ($HRtags->tag as $htag) {
                if (stristr(( string ) $htag->name, SRV) !== false) {
                    $mytags [] = array(
                            "id" => ( integer ) $htag->id,
                            "name" => ( string ) $htag->name
                    );
                }
            }
        } else {
            $mytags [0] = array(
                    "id" => 0,
                    "name" => "No ".SRV." Tags!"
            );
        }
    } else {
        $mytags [0] = array(
                "id" => 0,
                "name" => "Curl Failed!"
        );
    }
    // fermeture des ressources
    curl_close($ch);
    //
    $step = GetPostVar("", "POST", "step", "display");
    $nrp = new Numbers_Words();
    // get all available tags from the db
    
    echolog("D", "Current step is $step");
    switch ($step) {
        case "display":
            break;
        case "remove_user":
            $myusid = GetPostVar("", "POST", "usid", "0");
            if ($myusid != 0) {
                $nr = $coach->optoutuser($dbh, $myusid);
                $coach->get_all_active_users($dbh);
            } else {
                $nr = 0;
            }
            break;
        case "change_coach":
            $coid = GetPostVar("", "POST", "allid", "0;0");
            $allid = explode(";", $coid);
            $newcoid = GetPostVar("", "POST", "coid", 0);
            if ($newcoid != 0 && $allid[0] != 0 && $allid[1] != 0) {
                $nr = $coach->transfer_coach($dbh, $allid[1], $newcoid, $allid[0]);
                // need to rescan the coch/user assoc !
                $coach->get_all_active_users($dbh);
            } else {
                $nr = 0;
            }
            break;
        case "send_all_links_to_me":
            $nr = $coach->sendalllinkstome($dbh);
            break;
        case "send_link_to_user":
            $myusid = GetPostVar("", "POST", "usid", "0");
            if ($myusid != 0) {
                $nr = $coach->sendlinkuser($dbh, $myusid);
            } else {
                $nr = 0;
            }
            break;
        case "send_all_links_to_users":
            // select all my users
            $coach->get_all_active_users($dbh);
            $nr = 0;
            foreach ($coach->active_users as $actuser) {
                if ($actuser["coid"] == $coach->coid) {
                    if ($actuser["usid"]!= 0) {
                        $nr += $coach->sendlinkuser($dbh, $actuser["usid"]);
                    }
                }
            }
            break;
        case "send_all_links_to_tag":
            // select all my users with tag
            $mytagid = GetPostVar("", "POST", "tagid", "0");
            $coach->get_all_active_users($dbh);
            $nr = 0;
            foreach ($coach->active_users as $actuser) {
                if (($actuser["coid"] == $coach->coid) && ($actuser["tag"] == $mytagid)) {
                    if ($actuser["usid"]!= 0) {
                        $nr += $coach->sendlinkuser($dbh, $actuser["usid"]);
                    }
                }
            }
            break;
        case "ask_salle":
            $mycdat = GetPostVar("", "POST", "cdat", "none");
            $nr = ask_for_salle($dbh, $mycdat, $coach->coid);
            break;
        case "update_salle":
            $mysalle = GetPostVar("", "POST", "salle", "Pas de salle précisée");
            $mycoid = GetPostVar("", "POST", "coid", $coach->coid);
            $mycdat = GetPostVar("", "POST", "cdat", "none");
            $nupd = $coach->update_salle($dbh, $mycdat, $mycoid, $mysalle, $gservice);
            break;
        case "print_sess":
            $xls = GetPostVar("", "POST", "xls", "no");
            $mycoid = GetPostVar("", "POST", "coid", 0);
            if ($xls == "set") {
                $coach->xlssess($dbh, $datef, $datet, $mycoid);
                exit();
            }
            break;
        case "send_vcards":
            $coach->export_vcard($dbh);
            exit();
        case "send_reminders":
            $nr = sendreminder($dbh, $datet, $coach->coid, 1);
            sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did send " . $nrp->toWords($nr, 'en_GB') . " reminder(s).</p>");
            break;
        case "update_cwho":
            // here we receive what can be updated for the current coach
            $rdv_id = GetPostVar("", "POST", "rdv_id", "0");
            echolog("D", "Updating CWHO with rdv_id = $rdv_id");
            if ($rdv_id != "0") {
                $rmesg = update_cwho($dbh, $rdv_id, $gservice);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did confirm a coaching session</p>");
                // exit;
            }
            // header ( 'Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey );
            break;
        case "update_cwho_4":
            // here we receive what can be updated for the current coach
            $rdv_id = GetPostVar("", "POST", "rdv_id", "0");
            echolog("D", "Updating CWHO with rdv_id = $rdv_id");
            if ($rdv_id != "0") {
                $rmesg = update_cwho_4($dbh, $rdv_id, $gservice);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did confirm a coaching session</p>");
                // exit;
            }
            // header ( 'Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey );
            break;
        case "update_cwho_1":
            // here we receive what can be updated for the current coach
            $rdv_id = GetPostVar("", "POST", "rdv_id", "0");
            echolog("D", "Updating CWHO with rdv_id = $rdv_id");
            if ($rdv_id != "0") {
                $rmesg = update_cwho_1($dbh, $rdv_id, $gservice);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did confirm a coaching session</p>");
                // exit;
            }
            // header ( 'Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey );
            break;
         case "update_cwho_2":
            // here we receive what can be updated for the current coach
            $rdv_id = GetPostVar("", "POST", "rdv_id", "0");
            echolog("D", "Updating CWHO with rdv_id = $rdv_id");
            if ($rdv_id != "0") {
                $rmesg = update_cwho_2($dbh, $rdv_id, $gservice);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did confirm a coaching session</p>");
                // exit;
            }
            // header ( 'Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey );
            break;
           
        case "check_manual_completions":
            break;
        case "delete_cavails":
            // here we receive what can be deleted for the current coach
            $ncavail = GetPostVar("", "POST", "ncavail", "-1");
            echolog("D", "Updating Cavails");
            if ($ncavail != "-1") {
                echolog("D", $ncavail . " availabilities received");
                // loop on possible avails that have been posted
                $cavailn = 0;
                for ($i = 0; $i <= $ncavail; $i ++) {
                    if (GetPostVar("", "POST", "cavail" . $i, 0) != 0) {
                        $cavailn ++;
                        $ncavails [] = array(
                                "availnum" => $i,
                                "cavid" => GetPostVar("", "POST", "cavail" . $i, 0)
                        );
                    }
                }
                $coach->update_cavails($dbh, $ncavails, $gservice);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did update his/her availabilities</p>");
                // exit;
            }
            header('Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey);
            break;
        case "delete_sessions":
            // here we receive what can be deleted for the current coach
            $ncwid = GetPostVar("", "POST", "ncwid", "-1");
            $mytxt = getPostVar("", "POST", "mytext", "-1");
            echolog("D", "Updating Sessions");
            if ($ncwid != "-1") {
                echolog("D", $ncwid . " possible sessions to delete received");
                // loop on possible avails that have been posted
                $cwidn = 0;
                for ($i = 0; $i <= $ncwid; $i ++) {
                    if (GetPostVar("", "POST", "cwid" . $i, 0) != 0) {
                        $cwidn ++;
                        $ncwids [] = array(
                                "availnum" => $i,
                                "cwid" => GetPostVar("", "POST", "cwid" . $i, 0)
                        );
                    }
                }
                $coach->update_sessions($dbh, $gservice, $ncwids, $mytxt);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did delete " . $cwidn . " coaching session(s).</p>");
                // exit;
            }
            header('Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey);
            
            break;
        case "print_presences":
            $coach->print_presence($dbh, $datet, $coach->coid);
            break;
        case "generateuuids":
            $nr = $coach->generateuuids($dbh);
            break;
        case "add_cavails":
            $cavdates = GetPostVar("", "POST", "cavdate", "-1");
            if ($cavdates != "") {
                $nci = array();
                $nci = $coach->add_cavails($dbh, $cavdates, $gservice);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did add availabilities for coaching session(s).</p>");
            }
            break;
        case "import_users_from_HR":
            $tagid = GetPostVar("", "POST", "tagid", "-1");
            $mycoid = GetPostVar("", "POST", "coid", "-1");
            if ($tagid != - 1) {
                $tagname = find_in_array($mytags, "id", $tagid, "name");
                $ch = curl_init();
                // configuration des options
                curl_setopt($ch, CURLOPT_URL, "https://lateral.highrisehq.com/tags/" . $tagid . ".xml");
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_USERAGENT, "Using integration API - patrick@lateral.be");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_USERPWD, "c6f551c0ce830bcd8328ec7460a0fa97:X");
                // exécution de la session
                if ($xmlstr = curl_exec($ch)) {
                    // fermeture des ressources
                    curl_close($ch);
                    $HRusers = new SimpleXMLElement($xmlstr);
                    $newucount = 0;
                    $tagucount = 0;
                    /* For each <party> node, we echo a the data */
                    if (count($HRusers->party) != 0) {
                        foreach ($HRusers->party as $party) {
                            $new_email = "";
                            foreach ($party->{'contact-data'}->{'email-addresses'} as $haddr) {
                                foreach ($haddr->{'email-address'} as $hemail) {
                                    if (strcasecmp($hemail->location, "Work") == 0) {
                                        $new_email = $hemail->address;
                                    }
                                }
                            }
                            $hmasc = false;
                            $htu = false;
                            foreach ($party->{'tags'}->tag as $htag) {
                                $hmasc = $hmasc || (strcasecmp($htag->name, "Masculin") == 0);
                                $htu = $htu || (strcasecmp($htag->name, "tu") == 0);
                            }
                            $new_HF = ($hmasc) ? 'M.' : 'Mme';
                            $new_tu = ($htu) ? 'tu' : 'vous';
                            // insert if not already existing in the db
                            $uinserted = $coach->insert_user($dbh, $party->id, $party->{'first-name'}, $party->{'last-name'}, $new_email, $new_HF, $new_tu, $tagname, $mycoid);
                            if ($uinserted == 0) {
                                $tagupdated = $coach->update_user_tag($dbh, $party->id, $tagname);
                                $tagucount += $tagupdated;
                            }
                            $newucount += $uinserted;
                            //
                        }
                    }
                }
            }
            
            break;
        case "list_poscoachings":
            $mysetdate = GetPostVar("", "POST", "dateset", "no");
            $mysetloc = GetPostVar("", "POST", "loid", 0);
            if ($mysetdate == "set") {
                $mycdat = GetPostVar("", "POST", "cdat", null);
            } else {
                    $mycdat = null;
                }
                    break;
        case "select_to_cwho":
            // Check if the date is not yet used...
            //
            $oktogo = false;
            $myloid = GetPostVar("", "POST", "loid", "0");
            $mycoid = GetPostVar("", "POST", "coid", "-1");
            $mynslots = GetPostVar("", "POST", "nslots", "0");
            if ($myloid * $mynslots > 0) {
                $myloc = find_in_array($locsarray, "loid", $myloid, "loc");
                // select users ok to go there !
                $myusers = get_users_ww($dbh, $myloid, $mycoid);
                if (count($myusers) > 0) {
                     $oktogo = true;
                }
            }
            break;
        case "update_events":
            $nevent = UpdateEventsIds($dbh, $gservice);
            // $myevents = GetEventId($iCaluid,$gservice);
            break;
        case "update_cwho_manual":
            $myloid = GetPostVar("", "POST", "loid", "-1");
            $mycoid = GetPostVar("", "POST", "coid", "-1");
            $slotini = GetPostVar("", "POST", "slotini", "-1");
            $slotend = GetPostVar("", "POST", "slotend", "-1");
            $ninserts = 1 + $slotend - $slotini;
            $upmail = GetPostVar("", "POST", "upmail", 0);
            $upgoogle = GetPostVar("", "POST", "upgoogle", 0);
            $upcwho = GetPostVar("", "POST", "upcwho", 0);
            $upsalle = GetPostVar("", "POST", "salle", null);
            
            echolog("D", "Updating cwho with manual data");
            if ($ninserts > 0) {
                echolog("D", $ninserts . " slots received");
                // loop on possible slots that have been posted
                $j = 0;
                for ($i = $slotini; $i <= $slotend; $i ++) {
                    if (GetPostVar("", "POST", "usid" . $i, 0) != 0) {
                        $j ++;
                        $nslots [] = array(
                                "slotnum" => $j,
                                "slid" => $i,
                                "usid" => GetPostVar("", "POST", "usid" . $i, 0)
                        );
                    }
                }
                echolog("D", "Entering CWHO manually with data : upcwho is " . $upcwho . " - upgoogle is " . $upgoogle . " - upmail is " . $upmail);
                $rmesg = update_manual_cwho($dbh, $mycoid, $datet, $myloid, $nslots, $gservice, $upcwho, $upgoogle, $upmail, $upsalle);
                sendLatEmail(FR_EMAIL, FR_NAME, $coach->email, "C".USRV." change", "<p>Coach $coach->fname $coach->lname did update coachings manually</p>");
                // exit;
            }
            // header ( 'Location:mng.php?step=display&debug=' . DEBUGLEVEL . '&uid=' . $coach->crkey );
            
            break;
        case "list_events":
            $mysearch = GetPostVar("", "POST", "searchstring", "coaching " . SRV);
            $myevents = GetEventsIds($dbh, $mysearch, $gservice);
            require("php-excel.class.php");
            $xls = new Excel_XML();
            $xls->addWorksheet('Coaching '. USRV, $myevents);
            $xls->sendWorkbook('ListUsers.xls');
            exit();
            break;
        case "select_emails":
            $mynsmin = GetPostVar("", "POST", "nsmin", -1);
            $mynsmax = GetPostVar("", "POST", "nsmax", -1);
            $myloid = GetPostVar("", "POST", "loid", 0);
            $mycoid = GetPostVar("", "POST", "coid", 1);
            $myincl = GetPostVar("", "POST", "inclall", "no");
            $collected_emails = $coach->select_emails($dbh, $mynsmin, $mynsmax, $myloid, $mycoid, $myincl);
            // no break
        case "skim_dropmsg":
            $nr = $coach->skim_dropmsg($dbh);
            break;
        default:
            break;
    }
    ?>
	<!DOCTYPE HTML>
	
<HTML>
	<HEAD>
		<TITLE>Gestion des rendez-vous de coaching | <?php echo USRV ?> - accès coach pour
			<?php echo $coach->fname ." " .  $coach->lname?>
		</TITLE>
		<META HTTP-EQUIV="content-type" CONTENT="text/html;charset=utf-8">
		<LINK REL="stylesheet" HREF="main.css" TYPE="text/css" />
  <script src="scripts/tinymce.min.js" type='text/javascript'></script>
  <script type="text/javascript">
  tinymce.init({
    selector: '#mytext',
    	  plugins: 'code lists link',  // note the comma at the end of the line!
    	  //toolbar: 'code numlist bullist', // last reminder, note the comma!
    	 // menubar: false
    	  code_dialog_height: 600
    	  //code_dialog_width: 350
  });
  </script>
		
	</HEAD>

	<BODY CLASS="NormalText">
		<?php

echo '<div id="lateral_wrapper">';
echo '<div id="lateral_content" class="NormalText la" style="width:970px">';
echo '<div class="trow">';
echo '<div class="box la" style="height:80px;width:600px;display:block">';
echo '<div class="VeryLargeText" style="float:left;"><img src="'.SRV.'logo.png" height="80px"></div>';
echo '<div class="VeryLargeText" style="float:right;"><img src="'.IMGREF.'logo.png" height="80px"></div>';
echo '</div>';
echo '<div class="trow">';
echo '<div class="box la" style="width:600px;display:block">';
?>
			<DIV CLASS="trow" style="font-weight: bold;">Gérer les disponibilités</DIV>
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="add_cavails">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Ajouter des disponibilités pour les jours suivants (format YYYY-MM-DD comme 2015-12-28, séparés par une virgule)
					<INPUT TYPE="text" NAME="cavdate" SIZE="43">
					<INPUT TYPE="submit" VALUE="Ajouter ces disponibilités">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="update_cavails">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">
					<INPUT TYPE="submit" VALUE="Gérer les disponibilités existantes">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="list_poscoachings">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">
					<INPUT TYPE="submit" VALUE="Lister les dispos de mes clients"> à
					<SELECT NAME="loid" SIZE="1">
<?php foreach ($locsarray as $hloc) {
    if ($hloc["loid"] != 0) {
        echo "<option value=" . $hloc["loid"] .">" . $hloc["loc"]. "</option>";
    }
} ?>
</SELECT> (
					<INPUT TYPE="checkbox" NAME="dateset" VALUE="set"> uniquement le
					<INPUT TYPE="text" NAME="cdat" SIZE="10">).
				</FORM>
			</DIV>
			<DIV CLASS="trow" style="font-weight: bold;">Gérer les sessions de coaching</DIV>
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="select_rdvs">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">Vous avez
					<?php echo $coach->poss_coach_sess ?> possibilités de coaching en attente :
					<INPUT TYPE="submit" VALUE="confirmer ces séances de coaching">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="check_manual_completions">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">Vous avez
					<?php echo $coach->poss_coach_compl ?> possibilités de compléter une de vos journées déjà programmées :
					<INPUT TYPE="submit" VALUE="Compléter mes journées de coaching">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="modify_sessions">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">
					<INPUT TYPE="submit" VALUE="Modifier des sessions de coaching déjà confirmées">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="update_sessions">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">
					<INPUT TYPE="submit" VALUE="Supprimer des sessions de coaching déjà confirmées">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="select_to_cwho">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Créer une journée de coaching pour
					<SELECT NAME="coid" SIZE="1">
<?php foreach ($coacharray as $hloc) {
    if ($hloc["coid"] != 0) {
        echo "<option value=" . $hloc["coid"] .">" . $hloc["fname"]. "</option>";
    }
} ?>
</SELECT> le
					<INPUT TYPE="text" NAME="datet" SIZE="10" VALUE="<?php echo $datet ?>"> à
					<SELECT NAME="loid" SIZE="1">
<?php foreach ($locsarray as $hloc) {
    if ($hloc["loid"] != 0) {
        echo "<option value=" . $hloc["loid"] .">" . $hloc["loc"]. "</option>";
    }
} ?>
</SELECT> avec
					<SELECT NAME="nslots" SIZE="1"><OPTION VALUE="4">4</OPTION>
				</SELECT> sessions.
					<INPUT TYPE="submit" VALUE="Créer">
				</FORM>
			</DIV>
			<DIV CLASS="trow" style="font-weight: bold;">Fonctions utilitaires</DIV>
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="print_presences">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Imprimer la feuille de présence du
					<SELECT NAME="datet" SIZE="1">
<?php foreach ($coach->ncoachingdates as $nc) {
    echo "<option value=" . $nc["cwdate"] . " " . ($nc["cwdate"] == $tomorrow ? "selected" : "") .">" . $nc["cwdate"]. "</option>";
} ?>
</SELECT>
					<INPUT TYPE="submit" VALUE="Imprimer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="send_reminders">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Envoyer un rappel par mail pour les coaching du
					<SELECT NAME="datet" SIZE="1">
<?php foreach ($coach->ncoachingdates as $nc) {
    echo "<option value=" . $nc["cwdate"] . " " . ($nc["cwdate"] == $tomorrow ? "selected" : "") .">" . $nc["cwdate"]. "</option>";
} ?>
</SELECT>
					<INPUT TYPE="submit" VALUE="Envoyer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="send_link_to_user">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">Envoyer un email avec le lien d'accès à 
					<SELECT NAME="usid" SIZE="1">  <?php foreach ($coach->active_users as $htag) {
    echo '<option value="' . $htag["usid"]
                . '">' . $htag["name"]. ' ('. $htag["cname"] .')</option>';
} ?>
</SELECT>
					<INPUT TYPE="submit" VALUE="Envoyer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="send_vcards">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">Télécharger les données de mes clients sous forme de vcards
					<INPUT TYPE="submit" VALUE="Télécharger">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="send_all_links_to_users">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">Envoyer un email avec le lien d'accès à tous mes clients <strong>actifs</strong>
					<INPUT TYPE="submit" VALUE="Envoyer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="send_all_links_to_tag">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">Envoyer un email avec le lien d'accès à tous mes clients <strong>actifs</strong> du groupe
					<SELECT NAME="tagid" SIZE="1">  <?php foreach ($coach->alltags as $htag) {
    echo "<option value=" . $htag["tag"] .">" . $htag["tag"]. "</option>";
} ?>
</SELECT><INPUT TYPE="submit" VALUE="Envoyer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="send_all_links_to_me">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"><strong>M'</strong>envoyer <strong>à moi-même</strong> un email avec le lien d'accès de tous mes clients <strong>actifs</strong>
					<INPUT TYPE="submit" VALUE="Envoyer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="select_emails">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Sélectionner les emails des participants sur base des critères suivants:<br /> Coach :
					<SELECT NAME="coid" SIZE="1">
<?php foreach ($coacharray as $hloc) {
    echo "<option value=" . $hloc["coid"] .">" . $hloc["fname"]. "</option>";
} ?>
</SELECT> <br /> Localisation possible :
					<SELECT NAME="loid" SIZE="1">
<?php foreach ($locsarray as $hloc) {
    echo "<option value=" . $hloc["loid"] .">" . $hloc["loc"]. "</option>";
} ?>
</SELECT> <br /> Nombre de sessions déjà utilisées entre
					<INPUT TYPE="text" NAME="nsmin" SIZE="2" VALUE="0"> et
					<INPUT TYPE="text" NAME="nsmax" SIZE="2" VALUE="3"><br />
					(inclure les participants qui ont épuisé leur quota d'heures <INPUT TYPE="checkbox" NAME="inclall" VALUE="set"> ?)
					<INPUT TYPE="submit" VALUE="Sélectionner">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="print_sess">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Lister les sessions de coaching entre le
					<INPUT TYPE="text" NAME="datef" SIZE="10" VALUE="<?php echo $datef?>"> et le
					<INPUT TYPE="text" NAME="datet" SIZE="10" VALUE="<?php echo $datet?>"> (excel
					<INPUT TYPE="checkbox" NAME="xls" VALUE="set"> ?)
					pour le coach <SELECT NAME="coid" SIZE="1">
<?php foreach ($coacharray as $hloc) {
    echo "<option value=" . $hloc["coid"] .">" . $hloc["fname"]. "</option>";
} ?>
</SELECT>
					<INPUT TYPE="submit" VALUE="Lister">
				</FORM>
			</DIV>
			<hr />
			<?php if ($coach->coid == 1) {
    ?>
			<DIV CLASS="trow" style="font-weight: bold;">Gestion du système de coaching</DIV>
			<DIV CLASS="trow">
				<FORM ACTION="index.php" METHOD="post" target="_blank">
					<INPUT TYPE="hidden" NAME="step" VALUE="display">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					Voir les données personnelles de 
					<SELECT NAME="uid" SIZE="1">  <?php foreach ($coach->active_users as $htag) {
        echo '<option value="' . $htag["crkey"]
                . '">' . $htag["name"]. ' ('. $htag["cname"] .')</option>';
    } ?>
</SELECT> <INPUT TYPE="submit" VALUE="Voir">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="change_coach">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Remplacer le coach de
					<SELECT NAME="allid" SIZE="1">  <?php foreach ($coach->active_users as $htag) {
        echo '<option value="' . $htag["usid"].";".$htag["coid"]
                . '">' . $htag["name"]. ' ('. $htag["cname"] .')</option>';
    } ?>
</SELECT> par
					<SELECT NAME="coid" SIZE="1">
<?php foreach ($coacharray as $hloc) {
        if ($hloc["coid"] != 0) {
            echo "<option value=" . $hloc["coid"] .">" . $hloc["fname"]. "</option>";
        }
    } ?>
</SELECT>
					<INPUT TYPE="submit" VALUE="Remplacer">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="remove_user">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Supprimer l'accès de
					<SELECT NAME="usid" SIZE="1">  <?php foreach ($coach->active_users as $htag) {
        echo '<option value="' . $htag["usid"]
                . '">' . $htag["name"]. ' ('. $htag["cname"] .')</option>';
    } ?>
</SELECT> au système de coaching (opt-out)
					<INPUT TYPE="submit" VALUE="Supprimer">
				</FORM>
			</DIV>
			<hr />
						<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="skim_dropmsg">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> 
					Envoyer des emails à tous les participants pour leur signaler leurs disponibilités libérées (<?php echo $coach->dropmsgs ?> dispos peuvent être libérées)
					<INPUT TYPE="submit" VALUE="Envoyer">
				</FORM>
			</DIV>
			<hr />
			
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="generateuuids">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">
					<INPUT TYPE="submit" VALUE="Génerer des UUIDS pour tous les utilisateurs existants">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="update_events">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>">
					<INPUT TYPE="submit" VALUE="Mettre à jour toutes les ID des events Google">
				</FORM>
			</DIV>
			<hr />
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="list_events">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Lister les events du calendrier Google contenant les mots suivants
					<INPUT TYPE="text" NAME="searchstring" SIZE="50" VALUE="coaching <?php echo SRV?>">
					<INPUT TYPE="submit" VALUE="Lister">
				</FORM>
			</DIV>
			<hr />
			
			
			<DIV CLASS="trow">
				<FORM ACTION="mng.php" METHOD="post">
					<INPUT TYPE="hidden" NAME="step" VALUE="import_users_from_HR">
					<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo DEBUGLEVEL ?>">
					<INPUT TYPE="hidden" NAME="uid" VALUE="<?php echo $coach->crkey ?>"> Importer les utilisateurs de Highrise avec le tag
					<SELECT NAME="tagid" SIZE="1">  <?php foreach ($mytags as $htag) {
        echo "<option value=" . $htag["id"] .">" . $htag["name"]. "</option>";
    } ?>
</SELECT> et attribuer le coach
					<SELECT NAME="coid" SIZE="1">
<?php foreach ($coacharray as $hloc) {
        if ($hloc["coid"] != 0) {
            echo "<option value=" . $hloc["coid"] .">" . $hloc["fname"]. "</option>";
        }
    } ?>
</SELECT>
					<INPUT TYPE="submit" VALUE="Importer">
				</FORM>
			</DIV>
                        <?php } ?>
        </div>
</div>
			<DIV CLASS="trow">
				<DIV CLASS="box" STYLE="width: 600px; display: block" ID="next_coachings">
					<?php $coach->echo_next_coachings($dbh); ?>
				</DIV>
			</DIV>


			<?php
            // echo '</div>';
            // echo '</div>';
            
            switch ($step) {
                case "select_rdvs":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="update_id_4">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">1</div>';
                    $coach->echo_rdv_4($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    if (NMINPDAY < 4) {
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="update_id">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->echo_rdv($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    if (NMINPDAY < 3) {
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="update_id_2">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">3</div>';
                    $coach->echo_rdv_2($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    if (NMINPDAY < 2) {
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="update_id_2">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">4</div>';
                    $coach->echo_rdv_1($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    }
                    }
                    }
                    break;
                    
                case "check_manual_completions":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="manual_update">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->echo_completions($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    break;
                case "update_cavails":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="delete_cavails">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->echo_cavails($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    break;
                case "update_sessions":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="update_sessions">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->echo_sessions($dbh, $coach->fkey);
                    echo '</div>';
                    echo '</div>';
                    break;
                case "print_sess":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="print_sess">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->printsess($dbh, $datef, $datet, $mycoid);
                    echo '</div>';
                    echo '</div>';
                    break;
                case "echo_attend":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="echo_attend">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->echo_attendance($dbh);
                    echo '</div>';
                    echo '</div>';
                    break;
                case "list_poscoachings":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="echo_attend">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    $coach->echo_availabilities($dbh, $mycdat, $mysetloc);
                    echo '</div>';
                    echo '</div>';
                    break;
                case "generateuuids":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="send_reminders">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ' mail a été envoyé</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "send_all_links_to_tag":
                case "send_all_links_to_me":
                case "send_link_to_user":
                case "send_all_links_to_users":
                case "skim_dropmsg":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="send_reminders">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                switch ($nr) {
                    case "0":
                        echo "<p>Aucun mail n'a été envoyé</p>";
                        break;
                    case "1":
                        echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ' mail a été envoyé</p>';
                        break;
                    default:
                        echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ' mails ont été envoyés</p>';
                        
                }
                    echo '</div>';
                    echo '</div>';
                    break;
                case "send_reminders":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="send_reminders">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ' rappels ont été envoyés</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "ask_salle":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="send_reminders">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ($nr == 1 ? 'e' : '') . ' demande(s) a(ont) été envoyée(s).</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "add_cavails":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="cavails inserted">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($nci[1], 'fr')) . ' slots de coaching ont été insérés sur les ' .
                    $nrp->toWords($nci[0], 'fr') . ' jours ajoutés.</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                    
                case "update_events":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="send_reminders">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . $nevent . ' ont été mis à jour</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "update_cwho_manual":
                case "update_cwho":
                case "update_cwho_4":
                case "update_cwho_2":
                case "update_cwho_1":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="send_reminders">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . $rmesg . '</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "import_users_from_HR":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="import_users_from_HR">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($newucount, 'fr')) . ' utilisateurs ont été ajoutés.<br />' . ucfirst($nrp->toWords($tagucount, 'fr')) . ' tags ont été mis à jour.</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "select_emails":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="select_emails">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    foreach ($collected_emails as $myevent) {
                        echo '<div class="trow">';
                        echo '<div class="tcell">' . find_in_array($coacharray, "coid", $myevent["coid"], "fname") . '</div><div class="tcell">' .
                                $myevent["collected_emails"] . '</div>';
                        echo '</div>';
                    }
                    echo '</div>';
                    echo '</div>';
                    break;
                case "change_coach":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="coach changed">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ' disponibilités ont pu être transférées.</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                case "remove_ser":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="coach changed">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    echo '<p>' . ucfirst($nrp->toWords($nr, 'fr')) . ' utilisateur a été retiré du système.</p>';
                    echo '</div>';
                    echo '</div>';
                    break;
                    case "list_events":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="list_events">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    foreach ($myevents as $myevent) {
                        foreach ($myevent as $mycont) {
                            echo $mycont . " - ";
                        }
                        echo '<br />';
                    }
                    echo '</div>';
                    echo '</div>';
                    break;
                case "select_to_cwho":
                    echo '<div class="trow">';
                    echo '<div class="box" style="width:600px;display:block" id="select_to_cwho">';
                    echo '<div class="VeryLargeText" style="float:left;width:30px">2</div>';
                    if ($oktogo) {
                        echo "<p>Voici toutes les possibilités de coaching pour la journée du " . strftime("%A %d %B %Y", strtotime($datet)) . " à " . $myloc . "</p>";
                        echo '<form action="mng.php" method="post">';
                        echo '<input type="hidden" name="step" value="update_cwho_manual">';
                        echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
                        echo '<input type="hidden" name="uid" value=' . $coach->crkey . '>';
                        for ($i = SLOTINI; $i <= SLOTEND; $i ++) {
                            echo "Slot de " . find_in_array($slotsarray, "slid", $i, "hb") . " à " . find_in_array($slotsarray, "slid", $i, "hf") . " : " . '<SELECT NAME="usid' . $i . '" SIZE="1">';
                            foreach ($myusers as $hloc) {
                                echo "<option value=" . $hloc ["usid"] . ">" . $hloc ["fname"] . " " . $hloc ["lname"] . "</option>";
                            }
                            echo '</SELECT><br />';
                        }
                        echo '(envoyer un email <INPUT TYPE="checkbox" name="upmail" value="1" checked>)<br />';
                        echo '(envoyer une invitation via agenda <INPUT TYPE="checkbox" name="upgoogle" value="1" checked>)<br />';
                        echo '(mettre à jour la base de données <INPUT TYPE="checkbox" name="upcwho" value="1" checked>)<br />';
                        echo '<input type="hidden" name="slotini" value="' . SLOTINI . '">';
                        echo '<input type="hidden" name="slotend" value="' . SLOTEND . '">';
                        echo '<input type="hidden" name="datet" value="' . $datet . '">';
                        echo '<input type="hidden" name="loid" value="' . $myloid . '">';
                        echo '<input type="hidden" name="coid" value="' . $mycoid . '">';
                        echo '<input type="submit" value="Confirmer la journée de coaching choisie"></form>';
                    } else {
                        echo "<p>Pas moyen de créer cette journée, les vérifications ont échoué.</p>";
                    }
                    echo '</div>';
                    echo '</div>';
                    
                    break;
                default:
                    break;
            }
            echo '</div>';
            echo '</div>';
            ?>
</BODY>
</HTML>