<?php
class Sec
{
    public $moid;
    public $fname;
    public $lname;
    public $email;
    public $phone;
    public $calid;
    public $HF;
    public $superuser = 0;
    public $fkey;
    public $crkey;
    
    public function populate($dbh, $fkey)
    {
        $this->fkey = $fkey;
        $strsql = "SELECT moid FROM mgmt WHERE fkey = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $fkey
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (empty($CID)) {
            return;
        } else {
            $mymoid = $CID ["moid"];
            $this->superuser = 1;
        }
        
        // get data from coach
        
        $strsql = "SELECT * FROM mgmt WHERE moid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $mymoid
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // put in the right boxes
        
        $this->moid = $CID ["moid"];
        $this->fname = $CID ["fname"];
        $this->lname = $CID ["lname"];
        $this->email = $CID ["email"];
        $this->phone = $CID ["phone"];
        $this->calid = $CID["calid"];
        $this->HF = $CID ["HF"];
        $this->crkey = $CID["crkey"];
    }

    public function xlssess($dbh, $datef, $datet)
    {
        dblog("From " . $datef . " to " . $datet);
        $strsql = 'SELECT loc, DATE_FORMAT(cwdate, "%W %e %M %Y") AS cdat, slot, concat(fname," ",lname) as uname, concat(cfname," ",clname) as cname
		FROM allcoachings WHERE cwdate >= ? and cwdate <= ? order by cwdate, cname, slid ASC';
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $datef,
                    $datet
            ));
            $CID = $sth->fetchall(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        if (!empty($CID)) {
            require("php-excel.class.php");
            $xls = new Excel_XML();
            array_unshift($CID, array("Lieu","Date","Heure","Client","Coach"));
            $xls->addWorksheet('Coaching '. CRT, $CID);
            $xls->sendWorkbook('Coaching'.CRT.'_' . $datef . '_' . $datet . '.xml');
        }
    }
}
