<?php
class User
{
    public $usid;
    public $fname;
    public $lname;
    public $email;
    public $phone;
    public $HF;
    public $coachname;
    public $coachemail;
    public $coachphone;
    private $coachusid;
    public $fkey;
    public $crkey;
    public $coid;
    public $locs;
    public $alterlocs;
    public $pcoachings;
    public $ncoachings;
    public $poscoachings;
    public $nsess;
    public $msess;
    public $lastdate;
    public $cnum;
    public $superuser = 0;
    public $avails;
    public $navails;
    public $nextavails;
    public $surec;
    public $otherloc;
    public $othercavid;
    public $tworvs;
    public $coachfkey;
    
    //
    public function populate($dbh, $fkey)
    {
        
        // check how many users
        $strsql = "SELECT COUNT(usid) AS CID FROM selectusers WHERE fkey = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $fkey
            ));
            $CID = $sth->fetch(PDO::FETCH_ASSOC);
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        
        // no user or too many users with this fkey
        if (($CID ["CID"] == 0) or ($CID ["CID"]) > 1) {
            $this->usid = 0;
        } else {
            echolog("D", "CID OK");
            
            // get data from selectusers2
            
            $strsql = "SELECT * FROM selectusers WHERE fkey = ?";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $fkey
                ));
                $CID = $sth->fetch(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            echolog("D", "Second fetch complete");
            
            // put in the rigth boxes
            
            $this->usid = $CID ["usid"];
            $this->fname = $CID ["fname"];
            $this->lname = $CID ["lname"];
            $this->email = $CID ["email"];
            $this->phone = $CID ["phone"];
            $this->HF = $CID ["HF"];
            $this->coachname = $CID ["coach"];
            $this->coachemail = $CID ["coachemail"];
            $this->coachphone = $CID ["coachphone"];
            $this->fkey = $CID ["fkey"];
            $this->crkey = $CID ["crkey"];
            $this->coid = $CID ["coid"];
            $this->cnum = $CID ["cnum"];
            
            echolog("D", "Data relocation in this complete");
            
            // get the fkey from the coach
            $strsql = "SELECT crkey FROM users WHERE usid = ?";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $CID ["coachusid"]
                ));
                $CID = $sth->fetch(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            $this->coachfkey = $CID ["crkey"];
            
            echolog("D", "Third fetch complete");
            
            
            // get the possible locations for this person
            
            $strsql = "SELECT * FROM selectlocs WHERE usid = ? ORDER BY loid ASC";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            foreach ($CID as $lcid) {
                $this->locs [] = $lcid;
            }
            
            // get data from sessbyusers (how many sessions already)
            
            $strsql = "SELECT count(nsess) AS cns FROM sessbyuser WHERE usid = ?";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetch(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            if ($CID ["cns"] == 0) {
                $this->nsess = 0;
                $this->msess = $this->cnum;
            } else {
                
                // get data from sessbyusers (how many sessions already)
                
                $strsql = "SELECT * FROM sessbyuser WHERE usid = ?";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                            $this->usid
                    ));
                    $CID = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                
                $this->nsess = $CID ["nsess"];
                $this->msess = $CID ["cnum"];
            }
            
            // get the alternate locations for this person
            
            $strsql = "SELECT loid, loc FROM locs where loid NOT IN (SELECT DISTINCT loid FROM wwhere WHERE usid = ?)  AND loid <> 0 ORDER BY loid ASC";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            foreach ($CID as $lcid) {
                $this->alterlocs [] = $lcid;
            }
            
            // get the availabilities for this person
            
            if (false) {
                $strsql = "SELECT * FROM availabilities WHERE usid = ? ORDER BY cdat, slid ASC";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                            $this->usid
                    ));
                    $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                
                // store those
                foreach ($CID as $lcid) {
                    $this->avails [] = $lcid;
                }
            }
            
            // get the coaching history for this person
            
            $strsql = 'SELECT cwdate as "Date", loc as "Lieu", slot as "Séance", concat(cfname," ",clname) as "Coach" 
			FROM allcoachings WHERE cwdate < curdate() AND usid = ? order by cwdate ASC';
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            foreach ($CID as $lcid) {
                $this->pcoachings [] = $lcid;
            }
            
            // get the coaching future for this person
            
            $strsql = 'SELECT cwdate as "Date", loc as "Lieu", slot as "Séance", concat(cfname," ",clname) as "Coach" 
				FROM allcoachings WHERE cwdate >= curdate() AND usid = ? order by cwdate, slid ASC';
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            foreach ($CID as $lcid) {
                $this->ncoachings [] = $lcid;
            }
            
            // get the possible coachings left for this person
            
            $strsql = 'SELECT cdat as "Date", loc as "Lieu", slot as "Séance", cname as "Coach"
			FROM poscoachings WHERE usid = ? order by cdat, slid ASC';
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            foreach ($CID as $lcid) {
                $this->poscoachings [] = $lcid;
            }
            
            // get the last coaching date for this person
            
            $strsql = "SELECT ifnull(MAX(cwdate),'2015-01-01') as lastdate FROM cwho WHERE usid = ?";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid
                ));
                $CID = $sth->fetch(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            $this->lastdate = $CID ["lastdate"];
            
            // get the availabilities for this coach x-ref with user avail as well
            
            $strsql = "select ca.cdat, ca.cavid, ca.slid, ca.slot, ifnull(a.cavid,0) AS checked from cavailabilities as ca left JOIN availabilities AS a on a.cavid = ca.cavid
				and usid = ?  where ca.coid = ? and ca.cdat > (? + INTERVAL ? DAY) ORDER BY cdat, slid ASC";
            echolog("D", "Sql is " . $strsql);
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            
            // store those
            echolog("D", "Resultat");
            $this->navails = 0;
            foreach ($CID as $lcid) {
                $this->avails [] = $lcid;
                if($lcid["checked"] !== "0") $this->navails++;
            }
            echolog("D", $this->avails);
            
            if (false) {
                // get next availabilities within avails and locations from rdv - direct appropriate coaching !
                $strsql = "select distinct (case when usid1 = ? THEN cavid1 WHEN usid2 = ? THEN cavid2 WHEN usid3 = ? THEN cavid3 ELSE 0 END) as cavid,
				cdat, loc, loid, (case when usid1 = ? THEN slot1 WHEN usid2 = ? THEN slot2 WHEN usid3 = ? THEN slot3 ELSE 0 END) as slot,
				(case when usid1 = ? THEN slid1 WHEN usid2 = ? THEN slid2 WHEN usid3 = ? THEN slid3 ELSE 0 END) as slid from rdv as r
				where (case when usid1 = ? THEN cavid1 WHEN usid2 = ? THEN cavid2 WHEN usid3 = ? THEN cavid3 ELSE 0 END) <> 0 order by cdat, slid";
                echolog("D", "Sql is " . $strsql);
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid,
                        $this->usid
                ));
                    echolog("D", array(
                        $this->usid
                ));
                    $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
            
                // store those
                echolog("D", "Resultat");
                echolog("D", $CID);
                foreach ($CID as $lcid) {
                    $this->surec [] = $lcid;
                }
                echolog("D", $this->surec);
            
                // get next availabilities within avails and NOT locations
                $strsql = "SELECT distinct tw.cdat, tw.loid, tw.loc, tw.slid3 as slid, tw.slot3 as slot, tw.cavid FROM tworvs as tw
			WHERE tw.loid NOT IN (select distinct loid from wwhere where usid = ?)
				AND tw.cavid IN (select Distinct cavid from availabilities where usid = ?)
				AND tw.coid = ? AND tw.cdat >= (? + INTERVAL ? DAY) AND ? <> usid1 AND ? <> usid2 ORDER BY cdat, slid ASC";
                echolog("D", "Sql is " . $strsql);
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $this->usid,
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV,
                        $this->usid,
                        $this->usid
                ));
                    echolog("D", array(
                        $this->usid,
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV,
                        $this->usid,
                        $this->usid
                ));
                    $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
            
                // store those
                echolog("D", "Resultat");
                echolog("D", $CID);
                foreach ($CID as $lcid) {
                    $this->otherloc [] = $lcid;
                }
                echolog("D", $this->otherloc);
            
                // get the next availabilities within locations and not avail
            
                $strsql = "SELECT distinct tw.cdat, tw.loid, tw.loc, tw.slid3 as slid, tw.slot3 as slot, tw.cavid as cavid FROM tworvs as tw
			WHERE tw.loid IN (select distinct loid from wwhere where usid = ?)
				AND tw.cavid NOT IN (select distinct cavid from availabilities where usid = ?)
				AND tw.coid = ? AND tw.cdat >= (? + INTERVAL ? DAY) AND ? <> usid1 AND ? <> usid2 ORDER BY cdat, slid ASC";
                echolog("D", "Sql is " . $strsql);
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $this->usid,
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV,
                        $this->usid,
                        $this->usid
                ));
                    echolog("D", array(
                        $this->usid,
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV,
                        $this->usid,
                        $this->usid
                ));
                    $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
            
                // store those
                echolog("D", "Resultat");
                echolog("D", $CID);
                foreach ($CID as $lcid) {
                    $this->othercavid [] = $lcid;
                }
                echolog("D", $this->othercavid);
                // get the next availabilities within locations and not avail
            
                $strsql = "SELECT distinct tw.cdat, tw.loid, tw.loc, tw.slid3 as slid, tw.slot3 as slot, tw.cavid FROM tworvs as tw
			WHERE tw.loid NOT IN (select distinct loid from wwhere where usid = ?)
				AND tw.cavid NOT IN (select distinct cavid from availabilities where usid = ?)
				AND tw.coid = ? AND tw.cdat >= (? + INTERVAL ? DAY) AND ? <> usid1 AND ? <> usid2 ORDER BY cdat, slid ASC";
                echolog("D", "Sql is " . $strsql);
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                        $this->usid,
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV,
                        $this->usid,
                        $this->usid
                ));
                    echolog("D", array(
                        $this->usid,
                        $this->usid,
                        $this->coid,
                        $this->lastdate,
                        DAYSINTV,
                        $this->usid,
                        $this->usid
                ));
                    $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
            
                // store those
                echolog("D", "Resultat");
                echolog("D", $CID);
                foreach ($CID as $lcid) {
                    $this->nextavails [] = $lcid;
                }
                echolog("D", $this->nextavails);
            }
            
            $strsql = "SELECT * FROM tworvs WHERE coid = ? AND loid IN (SELECT loid FROM wwhere WHERE usid = ?) ORDER BY cdat ASC";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $this->coid,
                        $this->usid
                ));
                $CID = $sth->fetchall(PDO::FETCH_ASSOC);
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
            // store those
            foreach ($CID as $lcid) {
                $this->tworvs [] = $lcid;
            }
        }
    }
    public function echo_avails($fkey, $dbh)
    {
        if (!empty($this->avails)) {
            echo "<p>Veuillez sélectionner toutes les dates et heures qui vous conviennent ci-dessous.
				Si possible pour vous, choisissez d'abord les dates indiquées en <strong>en gras</strong>, qui sont les plus probables et ensuite les autres dates.
				<strong>Confirmez</strong> vos disponibilités en appuyant sur le bouton <strong>Mettre à jour mes disponibilités</strong> en bas de ce cadre-ci.</p>";
            echo '<form action="index.php" method="post">';
            echo '<input type="hidden" name="step" value="update_avails">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value=' . $this->crkey . '>';
            echolog("D", "printing availabilities with " . count($this->avails));
            echolog("D", $this->avails);
            echo '<div class="ltable">';
            $i = - 1;
            foreach ($this->avails as $ploc) {
                $i ++;
                $boldit = false;
                // new algorithm - better !
                $strsql = "SELECT COUNT(usid) AS cusid FROM poscoachings WHERE cdat = (select c.cdat FROM cavail AS c WHERE c.cavid = ?) AND coid = ? AND loid IN 
				(select ww.loid FROM wwhere AS ww WHERE ww.usid = ?)";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                            $ploc["cavid"],
                            $this->coid,
                            $this->usid
                    ));
                    $CID = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                $boldit = ($CID["cusid"] >= 2) ? true : false ;
                
                
                // check if this availability is on a coaching day already set
                $strsql = "SELECT DISTINCT loc, salle FROM allcoachings WHERE cavid IN (SELECT c.cavid FROM cwho AS c WHERE c.cwdate = ? AND c.coid = ?) LIMIT 1";
                try {
                    $sth = $dbh->prepare($strsql);
                    $sth->execute(array(
                            $ploc["cdat"],
                            $this->coid
                    ));
                    $CID = $sth->fetch(PDO::FETCH_ASSOC);
                    $sth->closeCursor();
                } catch (PDOException $e) {
                    echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                    exit();
                }
                $cavloc = (!empty($CID)) ? $CID["loc"] : "none";
                $cavsal =  (!empty($CID)) ? $CID["salle"] : "none";
                $cavloc = ($cavloc == null) ? "none" : $cavloc;
                $cavsal = ($cavsal == null) ? "none" : $cavsal;
                
                if ($boldit == false) {
                    $boldit = ($cavloc == "none") ? false : true ;
                }

                $strongi = $boldit ? "<strong>" : "";
                $strongf = $boldit ? "</strong>" : "";
                
                if ($i % 4 == 0) {
                    echo '<div class="trow">';
                }
                echo '<div class="tcell"><input type="checkbox" name="avail' . $i . '" value="' . $ploc ["cavid"] . '" ' . ($ploc ["checked"] == 0 ? '' : 'checked="checked"') . '> ' . $strongi . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . '<br/>' . $ploc ["slot"]
                . ($cavloc != "none" ? "<br/>".$cavloc : "") . ($cavsal != "none" ? "<br />".$cavsal : "") . $strongf . '</div>';
                if (($i + 1) % 4 == 0 or ($i + 1) == count($this->avails)) {
                    echo '</div>';
                }
            }
            echo '</div><input type="hidden" name="navail" value="' . $i . '">';
            echo '<input type="submit" value="Mettre à jour mes disponibilités"></form>';
        } else {
            echo "<p><strong>Il n'est plus possible de trouver une date de coaching qui soit postérieure à votre dernière date
				planifiée dans les disponibilité de votre coach.</strong></p>";
        }
    }
    public function echo_nextavails($fkey)
    {
        echolog("D", "printing next availabilities with " . count($this->nextavails));
        echolog("D", $this->surec);
        if (count($this->surec) + count($this->otherloc) + count($this->othercavid) + count($this->nextavails) == 0) {
            echo "<p><strong>Il n'y a pas moyen de trouver une possibilité de coaching rapide pour vous.</strong></p>";
        } else {
            echo "<p><strong>Voici différentes possibilités de coaching qui vous assurent une session.</strong></p>
					<p>Merci de choisir <strong>une seule</strong> possibilité parmi les choix proposés.</p>
					<p>Veuillez noter que sélectionner ce choix vous inscrit <strong>d'office</strong> à cette séance, et envoie les invitations
				Outlook à <strong>tous</strong> les participants de cette journée.</p>";
        }
        
        if (count($this->surec) > 0) {
            echo "<hr><p><strong>Les dates et localisations suivantes correspondent à vos choix enregistrés</strong></p>";
            echo '<form action="index.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value="' . $this->crkey . '">';
            echo '<table>';
            
            foreach ($this->surec as $ploc) {
                echo '<tr><td><input type="radio" name="cavid" value="' . $ploc ["cavid"] . '">' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . ' à ' . $ploc ["loc"] . ' entre ' . $ploc ["slot"] . '</td></tr>';
            }
            echo '</table>';
            echo '<input type="submit" value="Valider la date choisie"></form>';
        }
        
        if (count($this->otherloc) > 0) {
            echo "<hr><p><em>Les dates suivantes correspondent à vos choix enregistrés,
					mais à un endroit différent de vos préférences.</em></p>";
            echo '<form action="index.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value="' . $this->crkey . '">';
            echo '<table>';
            
            foreach ($this->otherloc as $ploc) {
                echo '<tr><td><input type="radio" name="cavid" value="' . $ploc ["cavid"] . '">' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . ' à ' . $ploc ["loc"] . ' entre ' . $ploc ["slot"] . '</td></tr>';
            }
            echo '</table>';
            echo '<input type="submit" value="Valider la date choisie"></form>';
        }
        
        if (count($this->othercavid) > 0) {
            echo "<hr><p><em>Les dates suivantes correspondent à vos préférences de localisation,
					mais à une date différente de vos choix enregistrés.</em></p>";
            echo '<form action="index.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value="' . $this->crkey . '">';
            echo '<table>';
            
            foreach ($this->othercavid as $ploc) {
                echo '<tr><td><input type="radio" name="cavid" value="' . $ploc ["cavid"] . '">' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . ' à ' . $ploc ["loc"] . ' entre ' . $ploc ["slot"] . '</td></tr>';
            }
            echo '</table>';
            echo '<input type="submit" value="Valider la date choisie"></form>';
        }
        
        if (count($this->nextavails) > 0) {
            echo "<hr><p><em>Les possibilités suivantes ne correspondent ni à vos disponibilités enregistrées, ni à vos préférences de localisation.</em></p>";
            echo '<form action="index.php" method="post">';
            echo '<input type="hidden" name="step" value="update_cwho">';
            echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
            echo '<input type="hidden" name="uid" value="' . $this->crkey . '">';
            echo '<table>';
            
            foreach ($this->nextavails as $ploc) {
                echo '<tr><td><input type="radio" name="cavid" value="' . $ploc ["cavid"] . '">' . strftime("%A %d %B %Y", strtotime($ploc ["cdat"])) . ' à ' . $ploc ["loc"] . ' entre ' . $ploc ["ac encoder linu"] . '</td></tr>';
            }
            echo '</table>';
            echo '<input type="submit" value="Valider la date choisie"></form>';
        }
    }
    public function echop()
    {
        echo "Ton prénom   : " . $this->fname . "<br />";
        echo "Ton nom      : " . $this->lname . "<br />";
        echo "Ton email    : " . $this->email . "<br />";
        echo "Ton portable : " . $this->phone . "<br />";
        echo "Ton coach    : " . $this->coachname . "<br />";
    }
    public function echo_id()
    {
        echo '<form action="index.php" method="post" onsubmit="return Idval();" onchange="return Idval();">';
        echo '<input type="hidden" name="step" value="update_id">';
        echo '<input type="hidden" name="debug" value="' . DEBUGLEVEL . '">';
        echo '<input type="hidden" name="uid" value="' . $this->fkey . '">';
        echo '<p><strong>Vos données personnelles :</strong></p>';
        echo '<p><table>';
        echo '<tr><td><strong>Votre nom :</strong></td><td>' . $this->fname . " " . $this->lname . '</td></tr>';
        echo '<tr><td><strong>Votre email :</strong></td><td>' . $this->email . '</td></tr>';
        echo '<tr><td><strong>Votre portable :</strong></td><td><input type="text" size=15 id="phone" name="phone" value="' . $this->phone . '"></td></tr>';
        echo '<tr><td><strong>Votre coach :</strong></td><td>' . $this->coachname . '</td></tr>';
        echo '</table></p>';
        $i = - 1;
        if (LOCSGT1) {
        if (count($this->locs) > 2) {
            echo "<p><strong>Merci tout d'abord de choisir le(s) lieu(x) où vous voulez avoir vos sessions de coaching ci-dessous.</strong>
					Choisir plusieurs lieux augmente considérablement vos chances de bénéficier rapidement d'un coaching.</p>";
        }
        echo '<p>Voici les localisations qui sont prises en compte pour vos séances de coaching :</p>';
        echo '<table>';
        if (count($this->locs) > 0) {
            echo '<tr>';
            foreach ($this->locs as $ploc) {
                $i ++;
                echo '<td><input type="checkbox" name="loc' . $i . '" value="' . $ploc ["loid"] . '" checked="checked">' . $ploc ["loc"] . '</td>';
            }
            echo '</tr>';
        }
        
        if (count($this->alterlocs) > 0) {
            echo '<tr>';
            foreach ($this->alterlocs as $ploc) {
                $i ++;
                echo '<td><input type="checkbox" name="loc' . $i . '" value="' . $ploc ["loid"] . '">' . $ploc ["loc"] . '</td>';
            }
            echo '</tr>';
        }
        } else {
            echo "<p>Les sessions de coaching auront lieu à " . $this->locs[0]["loc"] . " (". $this->locs[0]["def"] . ")</p>";
        }
        if ($this->phone === NULL) echo "<p>Merci de bien vouloir renseigner votre numéro de téléphone mobile ci-dessus 
            et d'ensuite valider en appuyant sur le bouton <strong>Mettre à jour ces données</strong> en bas de ce cadre</p>";
        echo "</table>";
        if ($i >= 0) echo '<input type="hidden" name="nloc" value="' . $i . '">';
        echo '<input type="submit" value="Mettre à jour ces données"></form>';
    }
    public function echo_pcoachings()
    {
        $from = new Numbers_Words();
        $fw = $from->toWords($this->msess, 'fr');
        if ($fw == "un") {
            $fw = "une";
        }
        $to = new Numbers_Words();
        $tw = $to->toWords($this->nsess, 'fr');
        echo '<p>Sur les ' . $fw . ' séances de coaching, ';
        switch ($tw) {
            case "zéro":
                echo "aucune n'a encore été planifiée ou réalisée.</p>";
                break;
            case "un":
                echo "une a été planifiée ou réalisée.</p>";
                break;
            default:
                echo $tw . " ont été planifiées ou réalisées.</p>";
        }
        
        if (!empty($this->pcoachings)) {
            echo '<p><strong>Séances précédentes:</strong></p><ul>';
            foreach ($this->pcoachings as $ploc) {
                echo '<li>' . strftime("%A %d %B %Y", strtotime($ploc ["Date"])) . ' à ' . $ploc ["Lieu"] . ' de ' . $ploc ["Séance"] . ' avec ' . $ploc ["Coach"] . '</li>';
            }
            echo '</ul>';
        } elseif ($this->nsess > 0) {
            echo "<p>Vous n'avez pas encore bénéficié d'une séance de coaching.</p>";
        }
    }
    public function echo_ncoachings()
    {
        if (!empty($this->ncoachings)) {
            echo '<p><strong>Séances planifiées:</strong></p><ul>';
            foreach ($this->ncoachings as $ploc) {
                echo '<li>' . strftime("%A %d %B %Y", strtotime($ploc ["Date"])) . ' à ' . $ploc ["Lieu"] . ' de ' . $ploc ["Séance"] . ' avec ' . $ploc ["Coach"] . '</li>';
            }
            echo '</ul>';
        } elseif ($this->nsess > 0) {
            echo "<p>Il n'y a pas de séance de coaching ultérieure qui ait été planifiée.</p>";
        }
    }
    public function echo_poscoachings()
    {
        if ($this->nsess < $this->msess) {
            if ($this->navails == 0) {
                echo "<p><strong>Merci de tout d'abord remplir le cadre 3 avec vos disponibilités pour le coaching.</strong> Des options supplémentaires vous seront présentées dès que vos disponibilités seront connues.</p>";
            } else {
                if (!empty($this->poscoachings)) {
                    if (false) {
                        echo "<p>Les séances de coaching suivantes sont encore possibles,
					et attendent que d'autres participants soient disponibles pour pouvoir être confirmées.</p>";
                        echo '<div class="ltable">';
                        foreach ($this->poscoachings as $ploc) {
                            // foreach ($ploc as $loid => $loc)
                            // echo '<tr><td>' . $loid . ' :</td><td>' . $loc .'</td></tr>';
                            echo '<div class="trow">' . strftime("%A %d %B %Y", strtotime($ploc ["Date"])) . ' à ' . $ploc ["Lieu"] . ' - ' . $ploc ["Séance"] . '</div>';
                        }
                        echo '</div>';
                    } else {
                        echo "<p>Si vous voulez multiplier les chances de fixer une session de coaching, 
				plusieurs possibilités s'offrent à vous :<ul><li>vous attendez que d'autres participants s'inscrivent <em>(peu efficace)</em></li>
				<li>et/ou vous ajoutez des dates à vos disponibilités dans le cadre <strong>3</strong> <em>(plus efficace)</em></li>";
                        if (LOCSGT1) echo "<li>et/ou vous augmentez les localisations où un coaching est possible dans le cadre <strong>1</strong> <em>(très efficace)</em></li>";
			echo "</ul></p>";
                    }
                } else {
                    echo "<p>Avec vos disponibilités enregistrées actuellement, il n'est pas encore possible de planifier une future séance de coaching.
				</p><p>Plusieurs possibilités s'offrent à vous :<ul><li>vous attendez que d'autres participants s'inscrivent <em>(peu efficace)</em></li>
				<li>et/ou vous ajoutez des dates à vos disponibilités dans le cadre <strong>3</strong> <em>(plus efficace)</em></li>";
                        if (LOCSGT1) echo "<li>et/ou vous augmentez les localisations où un coaching est possible dans le cadre <strong>1</strong> <em>(très efficace)</em></li>";
			echo "</ul></p>";
                }
            }
        } else {
            echo "<p><strong>Vous avez bénéficié de toutes les séances de coaching prévues dans le cadre du contrat ".USRV.".</strong></p>";
        }
    }
    public function postcomment($dbh, $mycomment)
    {
        $strsql = "INSERT INTO comments (usid,comment) VALUES (?,?)";
        
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->usid,
                    $mycomment
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
    }
    public function old_echo_avails()
    {
        if ($this->nsess < $this->msess) {
            if ($this->navails > 0) {
                echo '<p>Vos disponibilités restantes</p>';
                echo '<table>';
                foreach ($this->avails as $ploc) {
                    echo '<tr><td>Le ' . $ploc ["cdat"] . ' </td><td> à ' . $ploc ["slot"] . '</td></tr>';
                }
                echo '</table>';
            } else {
                echo '<p>Il ne reste plus de disponibilités qui puissent être utilisées pour une séance de coaching.</p>';
            }
        }
    }
    public function verify_possible_coachings($dbh, $comment)
    {
    $pcs = 0;
    $n4s = count_coaching_sessions($dbh, "rdvuni", $this->coid);
    $n3s = count_coaching_sessions($dbh, "rdv", $this->coid);
    $n2s = count_coaching_sessions($dbh, "rdv_2", $this->coid);
    $n1s = count_coaching_sessions($dbh, "poscoachings", $this->coid);
    switch (NMINPDAY) {
            case "4" : $pcs = $n4s;
                break;
            case "3" : $pcs = $n4s + $n3s;
                break;
            case "2" : $pcs = $n4s + $n3s + $n2s;
                break;
            case "1" : $pcs = $n4s + $n3s + $n2s + $n1s;
                break;   
        }
        if ($pcs != 0) {
            $mail_body = "<p>Bonjour " . $this->coachname . ",</p>
<p>Un ou des participants ont modifié leurs disponibilités, et cela vous permet dès à présent de confirmer des sessions de coaching.</p>
<p>Dans le système, il y a ".$pcs." possibilités qui attendent votre confirmation.</p>
<p>Vous pouvez dès maintenant accéder à ces données via le lien suivant : ".
'<a href="https://coaching'.SRV.'.lateral.be/mng.php?step=select_rdvs&uid=' . $this->coachfkey. '">http://coaching'.SRV.'.lateral.lateral.be/mng.php?step=select_rdvs&uid=' .$this->coachfkey."</a>.</p>
<p>Bien amicalement,</p>
<p>Patrick.</p>" . MAILSIG ;
            sendLatEmail(FR_EMAIL, FR_NAME, $this->coachemail, "[" . USRV . "] " . $pcs . " possibilités de coaching à confirmer", $mail_body);
        }
        $pcs = count_coaching_completions($dbh, $this->coid);
        if ($pcs > 0) {
            $mail_body = "<p>Bonjour " . $this->coachname . ",</p>
<p>Un ou des participants ont modifié leurs disponibilités, ou bien une session de coaching déjà programmée a été annulée.</p><p>Cela vous permet dès à présent de compléter -si vous le désirez- une journée de coaching déjà existante.</p>
<p>Dans le système, il y a des possibilités qui peuvent être confirmées.</p>
<p>Vous pouvez dès maintenant confirmer ces nouvelles sessions individuelles via le lien suivant :";
            $mail_body .= '<a href="https://coaching'.SRV.'.lateral.be/mng.php?step=check_manual_completions&uid=' .
                    $this->coachfkey. '">http://coaching'.SRV.'.lateral.be/mng.php?step=check_manual_completions&uid=' .$this->coachfkey."</a></p>";
            $mail_body .= "<p>Bien amicalement,</p>
<p>Patrick.</p>". MAILSIG ;
            sendLatEmail(FR_EMAIL, FR_NAME, $this->coachemail, "[" . USRV . "] ". $pcs . " possibilités de compléter une journée de coaching", $mail_body);
        }
    }
    
    public function update_id($dbh)
    {
        $strsql = "UPDATE users SET phone = ? WHERE usid = ?";
        
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->phone,
                    $this->usid
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
    }
    public function update_locs($dbh)
    {
        // locs contains all the locations where usid wants to have a coaching
        
        // delete all locs
        $strsql = "DELETE FROM wwhere WHERE usid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->usid
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // loop now on new locs
        foreach ($this->locs as $ploc) {
            // insert his loc
            $strsql = "INSERT INTO wwhere (loid, usid) VALUES (?, ?)";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $ploc ["loid"],
                        $this->usid
                ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
        }
    }
    public function update_avails($dbh)
    {
        // avails contains only the cavids where usid wants to have a coaching
        // loop on updatelocs
        // delete all locs
        $strsql = "DELETE FROM avail WHERE usid = ?";
        try {
            $sth = $dbh->prepare($strsql);
            $sth->execute(array(
                    $this->usid
            ));
            $sth->closeCursor();
        } catch (PDOException $e) {
            echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
            exit();
        }
        // loop now on new locs
        foreach ($this->avails as $ploc) {
            // insert his loc
            $strsql = "INSERT INTO avail (cavid, usid) VALUES (?, ?)";
            try {
                $sth = $dbh->prepare($strsql);
                $sth->execute(array(
                        $ploc ["cavid"],
                        $this->usid
                ));
                $sth->closeCursor();
            } catch (PDOException $e) {
                echolog('F', 'Exception : ' . $e->getMessage() . '<br /><br />SQL = ' . $strsql);
                exit();
            }
        }
    }
}
