<?php
function echolog($typech, $text) {
	// only output iff DEBUGLEVEL permits it
	$typecho = strtoupper ( $typech );
	$prio = array (
			"D" => 0,
			"I" => 1,
			"W" => 2,
			"E" => 3,
			"F" => 4,
			"L" => 5
	);
	if (! array_key_exists ( $typecho, $prio )) {
		$typecho = "F";
	}
	if ($prio [$typecho] >= $prio [DEBUGLEVEL]) {
		$trace = debug_backtrace ( 2, 2 );
		$afunc = $trace [0] ['function'];
		@$ffunc = $trace [1] ['function'];
		$afile = $trace [0] ['file'];
		$aline = $trace [0] ['line'];
		@$ffile = $trace [1] ['file'];
		@$fline = $trace [1] ['line'];
		$fromw = $ffunc . " in " . $ffile . " at line " . $fline;
		$fromw0 = $afunc . " in " . $afile . " at line " . $aline;
		//
		echo ($typecho == "D" ? "<i>Debug: </i>" : ($typecho == "W" ? "Warning: " : ($typecho == "E" ? "<b>Error: </b>" : ($typecho == "F" ? "<br /> <b>FATAL: </b>" : "Info: "))));
		echo "Trapped : " . $fromw0 . "<br />" . $fromw . "<br />";
		// echo $_SERVER["SCRIPT_FILENAME"] . " ";
		if (is_array ( $text )) {
			print_r ( $text );
		} elseif (is_string ( $text )) {
			echo $text;
		} else {
			echo "Neither array nor text: do not know how to print it";
		}
		echo "<br />";
	}
	// fatal error, die !
	if ($typecho == "F") {
		die ( "<br /> **** This is a FATAL error - Processing stops here! ****<br />" );
	}
	return;
}
function dblog($text = " ") {
	global $dbh;
	$trace = debug_backtrace ( 2, 2 );
	$afunc = $trace [0] ['function'];
	@$ffunc = $trace [1] ['function'];
	@$ffile = $trace [1] ['file'];
	@$fline = $trace [1] ['line'];
	$fromw = $ffunc . " in " . $ffile . " at line " . $fline;

	// get it into the db
	$strsql = "INSERT INTO trace (fromw, txt) VALUES (?,?)";
	try {
		$sth = $dbh->prepare ( $strsql );
		if (is_array ( $text )) {
			$txt = substr ( print_r ( $text, true ), 0, 1000 );
		} elseif (is_string ( $text )) {
			$txt = substr ( $text, 0, 1000 );
		} else {
			$txt = "Neither array nor text: do not know how to print it.";
		}
		$sth->execute ( array (
				$fromw,
				$txt
		) );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	return;
}
function count_coaching_completions($dbh, $mycoid) {
	dblog ( " pour " . $mycoid );
	//
	// let see if we can complete an existing day with data from participants
	/*
	 * $strsql = "select distinct p.usid, p.cdat, p.fname, p.lname, p.cavid, p.slid, p.loid, p.coid,
	 * cw.salle from poscoachings as p JOIN cwho_current AS cw on cw.cwdate = p.cdat AND cw.coid = p.coid
	 * AND cw.cslid != p.slid AND cw.usid != p.usid AND cw.cwlocid = p.loid AND p.coid = ?";
	 */
	$strsql = "select count(distinct p.cdat) AS crv from poscoachings as p JOIN cwho_current AS cw on cw.cwdate = p.cdat 
AND cw.coid = p.coid AND cw.cslid != p.slid AND cw.usid != p.usid AND cw.cwlocid = p.loid AND p.coid = ?";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$mycoid
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	return ($CID ["crv"]);
}
function count_coaching_sessions($dbh, $db, $mycoid) {
	dblog ( $db . " pour " . $mycoid );
	//
	$strsql = "SELECT COUNT(rdv_id) AS crv FROM " . $db . " WHERE coid = ?";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$mycoid
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	return ($CID ["crv"]);
}
function sendreminder($dbh, $datet, $coid, $remlimit = 1) {
	dblog ( "date sélectionnée : " . $datet . " pour le coach id " . $coid );

	$strsql = "SELECT * FROM allcoachings WHERE cwdate = ? AND rem < ? AND coid = ? order by cwdate, slid ASC";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$datet,
				$remlimit,
				$coid
		) );
		$CID = $sth->fetchall ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	if (! empty ( $CID )) {
		foreach ( $CID as $ploc ) {
			// test salle
			$salle = ($ploc ["salle"] == null) ? $ploc ["def"] : $ploc ["salle"];
			sendLatEmail ( $ploc ["cemail"], $ploc ["cfname"] . " " . $ploc ["clname"], $ploc ["cemail"], "[" . SRV . "] Rappel de votre prochain coaching", "<p>Bonjour " . $ploc ["fname"] . " " . $ploc ["lname"] . ",</p>" . "<p>Voici le rappel de votre rendez-vous de coaching avec " . $ploc ["cfname"] . " " . $ploc ["clname"] . ".</p>" . "<p>Il a lieu :<ul><li>à " . $ploc ["loc"] . " (" . $salle . ")</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $ploc ["cwdate"] ) ) . " : " . $ploc ["slot"] . "</li></ul></p>
				<p>Merci de contacter votre coach au " . $ploc ["Tel"] . " ou par email via " . $ploc ["cemail"] . " en cas de problème.</p><br /><p>Bien amicalement,</p><p>" . $ploc ["cfname"] . " " . $ploc ["clname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $ploc ["Tel"] . "<br />" );
			// update the reminder count
			$strsql = "UPDATE cwho set rem = (rem+1) WHERE cwid = ? ";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$ploc ["cwid"]
				) );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}
		}
	}
	return (! empty ( $CID ) ? count ( $CID ) : 0);
}
function ask_for_salle($dbh, $datet, $coid) {
	dblog ( "demande de salle pour le " . $datet . " pour le coach id " . $coid );
	// get the emails
	$strsql = "SELECT group_concat(email separator ',') AS emails, cwdate, loc, cfname, clname, cemail, Tel FROM allcoachings WHERE cwdate = ? AND coid = ?";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$datet,
				$coid
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	$to_emails = $CID ["emails"];
	if (! empty ( $CID )) {
		sendLatEmail ( $CID ["cemail"], $CID ["cfname"] . " " . $CID ["clname"], $to_emails, "[" . USRV . "] Pouvez-vous réserver une salle pour les coaching de suivi à " . $CID ["loc"] . " le " . strftime ( "%A %d %B %Y", strtotime ( $CID ["cwdate"] ) ), "<p>Bonjour,</p>" . "<p>Chacun(e) d'entre vous a une session de coaching de suivi le " . strftime ( "%A %d %B %Y", strtotime ( $CID ["cwdate"] ) ) . " à " . $CID ["loc"] . " avec " . $CID ["cfname"] . " " . $CID ["clname"] . ".</p>" . "<p>Sauf erreur, il n'y a encore à ce moment aucune salle réservée à cet effet. Puis-je donc vous demander de vous organiser pour réserver une salle " . " et de me tenir informé, ainsi que les autres destinataires de ce mail.</p>" . "<p>Merci de contacter votre coach au " . $CID ["Tel"] . " ou par email via " . $CID ["cemail"] . " en cas de problème.</p><br /><p>Bien amicalement,</p><p>" . $CID ["cfname"] . " " . $CID ["clname"] . "</p><br />Mail envoyé à " . $CID ["emails"] . "<br />" . MAILSIG . "<br />GSM : " . $CID ["Tel"] . "<br />" );
	}
	return (1);
}
function inform_srt($dbh, $cdat, $loid, $loc, $cfname, $clname, $cphone, $cemail) {
	// get the srt ssociated with the loid
	$strsql = "SELECT fname, lname, email FROM srt AS s JOIN srtwhere AS sw ON sw.srtid = s.srtid WHERE sw.loid = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$loid
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	$strsql = "<p>Bonjour " . $CID ["fname"] . ",</p>" . "<p>Suite aux disponibilités des participants, je tenais à vous avertir qu'une nouvelle" . "session de coaching a été planifiée à " . $CID ["loc"] . "</p>" . "<p>Elle aura lieu le " . strftime ( "%A %d %B %Y", strtotime ( $cdat ) ) . "</p>" . "<p>Merci de réserver une salle à cet effet et de me la communiquer.</p>" . "<p>Vous pouvez me contacter au " . $cphone . " ou par email via " . $cemail . " en cas de problème.</p>" . "<br /><p>Bien amicalement,</p>" . "<p>" . $cfname . " " . $clname . "</p>" . "<br />" . MAILSIG . "<br />GSM : " . $cphone . "<br />";
	sendLatEmail ( $cemail, $cfname . " " . $clname, $CID ["email"], "[" . USRV . "] Coaching de suivi - nouveau coaching planifié à " . $CID ["loc"], $strsql );
	return;
}
function update_cwho($dbh, $rdv_id, $gservice) {
	// Hello
	dblog ( "rdv_id : " . $rdv_id );
	// select the corresponding rdv
	$strsql = "SELECT cdat, loid, loc, coid, usid1, slid1, cavid1, usid2, cavid2, slid2, usid3, cavid3, slid3 FROM rdv WHERE rdv_id = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$rdv_id
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	if ($CID != null) {
		// get coach phone number and reference
		$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$CID ["coid"]
			) );
			$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// inform SRT that a new coaching session is scheduled
		@inform_srt ( $dbh, $CID ["cdat"], $CID ["loid"], $CID ["loc"], $CID ["fname"], $CID ["lname"], $CID ["phone"], $CID ["email"] );
		echolog ( "D", "RDV ID $rdv_id found" );
		// update now cwho with the three usids and send an email presto !
		for($i = 1; $i < 4; $i ++) {
			// get the correct references
			$myusid = $CID ["usid" . $i];
			$myslid = $CID ["slid" . $i];
			$mycavid = $CID ["cavid" . $i];
			// drop this cavid...
			store_dropmsg ( $dbh, $mycavid, $myusid );
			// create meeting_id
			$meeting_id = uniqid ( $myusid . $mycavid, true );

			// get meeting start and end from the slid
			$strsql = "SELECT hb, hf FROM slots WHERE slid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$myslid
				) );
				$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get users name
			$strsql = "SELECT email, fname, lname FROM users WHERE usid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$myusid
				) );
				$CID4 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get default location at this site
			$strsql = "SELECT def FROM locs WHERE loid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$CID ["loid"]
				) );
				$CID5 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			echolog ( "D", "Sending email" );
			// $calendarId = 'lateral@lateral.be';
			$event = $gservice->events->insert ( CALENDAR_ID, new Google_Service_Calendar_Event ( makeGoogleAgendaEvent ( $CID4 ["fname"], $CID4 ["lname"], $CID4 ["email"], $CID ["cdat"], $CID2 ["hb"], $CID2 ["hf"], $CID4 ["fname"] . " " . $CID4 ["lname"] . " - " . $CID5 ["def"] . ". Merci de contacter " . $CID3 ["fname"] . " " . $CID3 ["lname"] . " au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.", $CID ["loc"], "[" . USRV . "] Coaching de suivi de la formation de management", $meeting_id, $CID3 ["fname"] . " " . $CID3 ["lname"], $CID3 ["phone"], $CID3 ["email"] ) ), array (
					'sendNotifications' => true
			) );
			$google_id = $event->getId ();

			//
			echolog ( "D", "Updating CWHO" );
			$strsql = "INSERT INTO cwho (cwdate, usid, cwlocid, coid, cslid, cavid, uniqid, salle, google_id) VALUES (?,?,?,?,?,?,?,?,?)";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sqlarray = array (
						$CID ["cdat"],
						$myusid,
						$CID ["loid"],
						$CID ["coid"],
						$myslid,
						$mycavid,
						$meeting_id,
						$CID5 ["def"],
						$google_id
				);
				$sth->execute ( $sqlarray );
				echolog ( "D", "sql data : " );
				echolog ( "D", $sqlarray );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// $mail_sent = sendIcalEmail($CID4["fname"],$CID4["lname"],$CID4["email"],$CID["cdat"],$CID2["hb"],$CID2["hf"],
			// $CID4["fname"]. " " . $CID4["lname"]. " - l'endroit exact du coaching vous sera communiqué dès que possible. Merci de contacter " . $CID3["fname"] . " " .
			// $CID3["lname"] . " au " . $CID3["phone"] .
			// " ou par email via " . $CID3["email"] . " en cas de problème."
			// ,$CID["loc"],"[" . USRV . "] Coaching de suivi de la formation de management",$meeting_id,
			// $CID3["fname"] . " " . $CID3["lname"], $CID3["phone"], $CID3["email"]);

			sendLatEmail ( $CID3 ["email"], $CID3 ["fname"] . " " . $CID3 ["lname"], $CID4 ["email"], "[" . USRV . "] Coaching de suivi de la formation de management", "<p>Bonjour " . $CID4 ["fname"] . " " . $CID4 ["lname"] . ",</p>" . "<p>Voici la confirmation de votre rendez-vous de coaching avec " . $CID3 ["fname"] . " " . $CID3 ["lname"] . ".</p>" . "<p>Il aura lieu :<ul><li>à " . $CID ["loc"] . "  " . $CID5 ["def"] . "</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $CID ["cdat"] ) ) . " de " . $CID2 ["hb"] . " à " . $CID2 ["hf"] . "</li></ul></p>
				<p>Vous allez recevoir en complément de ce courriel une invitation Outlook à accepter dans votre calendrier.</p>
				<p>Merci de contacter votre coach au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>" . $CID3 ["fname"] . " " . $CID3 ["lname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $CID3 ["phone"] . "<br />" );

			echolog ( "D", "Mail sent" );
			$rmesg = "Rendez-vous envoyés et base de données mise à jour.";
		}
	} else {
		echolog ( "D", "RDV ID $rdv_id not found" );
		$rmesg = "Aucun rendez-vous envoyé.";
	}
	return ($rmesg);
}
function update_cwho_4($dbh, $rdv_id, $gservice) {
	dblog ( "rdv_id : " . $rdv_id );

	// select the corresponding rdv
	$strsql = "SELECT cdat, loid, loc, coid, usid1, slid1, cavid1, usid2, cavid2, slid2, usid3, cavid3, slid3, usid4, cavid4, slid4 FROM rdvuni WHERE rdv_id = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$rdv_id
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	if ($CID != null) {
		// get coach phone number and reference
		$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$CID ["coid"]
			) );
			$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// inform SRT that a new coaching session is scheduled
		@inform_srt ( $dbh, $CID ["cdat"], $CID ["loid"], $CID ["loc"], $CID ["fname"], $CID ["lname"], $CID ["phone"], $CID ["email"] );
		echolog ( "D", "RDV ID $rdv_id found" );
		// update now cwho with the three usids and send an email presto !
		for($i = 1; $i < 5; $i ++) {
			// get the correct references
			$myusid = $CID ["usid" . $i];
			$myslid = $CID ["slid" . $i];
			$mycavid = $CID ["cavid" . $i];
			// drop this cavid...
			store_dropmsg ( $dbh, $mycavid, $myusid );

			// create meeting_id
			$meeting_id = uniqid ( $myusid . $mycavid, true );

			// get meeting start and end from the slid
			$strsql = "SELECT hb, hf FROM slots WHERE slid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$myslid
				) );
				$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get users name
			$strsql = "SELECT email, fname, lname FROM users WHERE usid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$myusid
				) );
				$CID4 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get default location at this site
			$strsql = "SELECT def FROM locs WHERE loid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$CID ["loid"]
				) );
				$CID5 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			echolog ( "D", "Sending email" );
			// $calendarId = 'lateral@lateral.be';
			$event = $gservice->events->insert ( CALENDAR_ID, new Google_Service_Calendar_Event ( makeGoogleAgendaEvent ( $CID4 ["fname"], $CID4 ["lname"], $CID4 ["email"], $CID ["cdat"], $CID2 ["hb"], $CID2 ["hf"], $CID4 ["fname"] . " " . $CID4 ["lname"] . " - " . $CID5 ["def"] . ". Merci de contacter " . $CID3 ["fname"] . " " . $CID3 ["lname"] . " au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.", $CID ["loc"], "[" . USRV . "] Coaching de suivi de la formation de management", $meeting_id, $CID3 ["fname"] . " " . $CID3 ["lname"], $CID3 ["phone"], $CID3 ["email"] ) ), array (
					'sendNotifications' => true
			) );
			$google_id = $event->getId ();

			//
			echolog ( "D", "Updating CWHO" );
			$strsql = "INSERT INTO cwho (cwdate, usid, cwlocid, coid, cslid, cavid, uniqid, salle, google_id) VALUES (?,?,?,?,?,?,?,?,?)";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sqlarray = array (
						$CID ["cdat"],
						$myusid,
						$CID ["loid"],
						$CID ["coid"],
						$myslid,
						$mycavid,
						$meeting_id,
						$CID5 ["def"],
						$google_id
				);
				$sth->execute ( $sqlarray );
				echolog ( "D", "sql data : " );
				echolog ( "D", $sqlarray );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// $mail_sent = sendIcalEmail($CID4["fname"],$CID4["lname"],$CID4["email"],$CID["cdat"],$CID2["hb"],$CID2["hf"],
			// $CID4["fname"]. " " . $CID4["lname"]. " - l'endroit exact du coaching vous sera communiqué dès que possible. Merci de contacter " . $CID3["fname"] . " " .
			// $CID3["lname"] . " au " . $CID3["phone"] .
			// " ou par email via " . $CID3["email"] . " en cas de problème."
			// ,$CID["loc"],"[" . USRV . "] Coaching de suivi de la formation de management",$meeting_id,
			// $CID3["fname"] . " " . $CID3["lname"], $CID3["phone"], $CID3["email"]);

			sendLatEmail ( $CID3 ["email"], $CID3 ["fname"] . " " . $CID3 ["lname"], $CID4 ["email"], "[" . USRV . "] Coaching de suivi de la formation de management", "<p>Bonjour " . $CID4 ["fname"] . " " . $CID4 ["lname"] . ",</p>" . "<p>Voici la confirmation de votre rendez-vous de coaching avec " . $CID3 ["fname"] . " " . $CID3 ["lname"] . ".</p>" . "<p>Il aura lieu :<ul><li>à " . $CID ["loc"] . "  " . $CID5 ["def"] . "</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $CID ["cdat"] ) ) . " de " . $CID2 ["hb"] . " à " . $CID2 ["hf"] . "</li></ul></p>
				<p>Vous allez recevoir en complément de ce courriel une invitation Outlook à accepter dans votre calendrier.</p>
				<p>Merci de contacter votre coach au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>" . $CID3 ["fname"] . " " . $CID3 ["lname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $CID3 ["phone"] . "<br />" );

			echolog ( "D", "Mail sent" );
			$rmesg = "Rendez-vous envoyés et base de données mise à jour.";
		}
	} else {
		echolog ( "D", "RDV ID $rdv_id not found" );
		$rmesg = "Aucun rendez-vous envoyé.";
	}
	return ($rmesg);
}
function update_cwho_2($dbh, $rdv_id, $gservice) {
	dblog ( "rdv_id : " . $rdv_id );

	// select the corresponding rdv
	$strsql = "SELECT cdat, loid, loc, coid, usid1, slid1, cavid1, usid2, cavid2, slid2 FROM rdv_2 WHERE rdv_id = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$rdv_id
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	if ($CID != null) {
		// get coach phone number and reference
		$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$CID ["coid"]
			) );
			$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// inform SRT that a new coaching session is scheduled
		@inform_srt ( $dbh, $CID ["cdat"], $CID ["loid"], $CID ["loc"], $CID ["fname"], $CID ["lname"], $CID ["phone"], $CID ["email"] );
		/* echolog('D', "RDV ID " . $rdv_id . " found"); */
		// update now cwho with the two usids and send an email presto !
		for($i = 1; $i < 3; $i ++) {
			// get the correct references
			$myusid = $CID ["usid" . $i];
			$myslid = $CID ["slid" . $i];
			$mycavid = $CID ["cavid" . $i];
			// drop this cavid...
			store_dropmsg ( $dbh, $mycavid, $myusid );

			// create meeting_id
			$meeting_id = uniqid ( $myusid . $mycavid, true );

			// get meeting start and end from the slid
			$strsql = "SELECT hb, hf FROM slots WHERE slid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$myslid
				) );
				$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get coach phone number and reference
			$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$CID ["coid"]
				) );
				$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get users name
			$strsql = "SELECT email, fname, lname FROM users WHERE usid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$myusid
				) );
				$CID4 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// get default location at this site
			$strsql = "SELECT def FROM locs WHERE loid = ? LIMIT 1";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$CID ["loid"]
				) );
				$CID5 = $sth->fetch ( PDO::FETCH_ASSOC );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			echolog ( "D", "Sending email" );
			// $calendarId = 'lateral@lateral.be';
			$event = $gservice->events->insert ( CALENDAR_ID, new Google_Service_Calendar_Event ( makeGoogleAgendaEvent ( $CID4 ["fname"], $CID4 ["lname"], $CID4 ["email"], $CID ["cdat"], $CID2 ["hb"], $CID2 ["hf"], $CID4 ["fname"] . " " . $CID4 ["lname"] . " - " . $CID5 ["def"] . ". Merci de contacter " . $CID3 ["fname"] . " " . $CID3 ["lname"] . " au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.", $CID ["loc"], "[" . USRV . "] Coaching de suivi de la formation de management", $meeting_id, $CID3 ["fname"] . " " . $CID3 ["lname"], $CID3 ["phone"], $CID3 ["email"] ) ), array (
					'sendNotifications' => true
			) );
			$google_id = $event->getId ();

			//
			echolog ( "D", "Updating CWHO" );
			$strsql = "INSERT INTO cwho (cwdate, usid, cwlocid, coid, cslid, cavid, uniqid, salle, google_id) VALUES (?,?,?,?,?,?,?,?,?)";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sqlarray = array (
						$CID ["cdat"],
						$myusid,
						$CID ["loid"],
						$CID ["coid"],
						$myslid,
						$mycavid,
						$meeting_id,
						$CID5 ["def"],
						$google_id
				);
				$sth->execute ( $sqlarray );
				echolog ( "D", "sql data : " );
				echolog ( "D", $sqlarray );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}

			// $mail_sent = sendIcalEmail($CID4["fname"],$CID4["lname"],$CID4["email"],$CID["cdat"],$CID2["hb"],$CID2["hf"],
			// $CID4["fname"]. " " . $CID4["lname"]. " - l'endroit exact du coaching vous sera communiqué dès que possible. Merci de contacter " . $CID3["fname"] . " " .
			// $CID3["lname"] . " au " . $CID3["phone"] .
			// " ou par email via " . $CID3["email"] . " en cas de problème."
			// ,$CID["loc"],"[" . USRV . "] Coaching de suivi de la formation de management",$meeting_id,
			// $CID3["fname"] . " " . $CID3["lname"], $CID3["phone"], $CID3["email"]);

			sendLatEmail ( $CID3 ["email"], $CID3 ["fname"] . " " . $CID3 ["lname"], $CID4 ["email"], "[" . USRV . "] Coaching de suivi de la formation de management", "<p>Bonjour " . $CID4 ["fname"] . " " . $CID4 ["lname"] . ",</p>" . "<p>Voici la confirmation de votre rendez-vous de coaching avec " . $CID3 ["fname"] . " " . $CID3 ["lname"] . ".</p>" . "<p>Il aura lieu :<ul><li>à " . $CID ["loc"] . "  " . $CID5 ["def"] . "</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $CID ["cdat"] ) ) . " de " . $CID2 ["hb"] . " à " . $CID2 ["hf"] . "</li></ul></p>
				<p>Vous allez recevoir en complément de ce courriel une invitation Outlook à accepter dans votre calendrier.</p>
				<p>Merci de contacter votre coach au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>" . $CID3 ["fname"] . " " . $CID3 ["lname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $CID3 ["phone"] . "<br />" );

			echolog ( "D", "Mail sent" );
			$rmesg = "Rendez-vous envoyés et base de données mise à jour.";
		}
	} else {
		echolog ( "D", "RDV ID $rdv_id not found" );
		$rmesg = "Aucun rendez-vous envoyé.";
	}
	return ($rmesg);
}
function update_cwho_1($dbh, $rdv_id, $gservice) {
	dblog ( "rdv_id : " . $rdv_id );

	// select the corresponding rdv
	$strsql = "SELECT cdat, loid, loc, coid, usid, slid, cavid FROM poscoachings WHERE rdv_id = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$rdv_id
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	if ($CID != null) {
		// get coach phone number and reference
		$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$CID ["coid"]
			) );
			$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// inform SRT that a new coaching session is scheduled
		@inform_srt ( $dbh, $CID ["cdat"], $CID ["loid"], $CID ["loc"], $CID ["fname"], $CID ["lname"], $CID ["phone"], $CID ["email"] );
		/* echolog('D', "RDV ID " . $rdv_id . " found"); */
		// update now cwho with the two usids and send an email presto !
		// get the correct references
		$myusid = $CID ["usid"];
		$myslid = $CID ["slid"];
		$mycavid = $CID ["cavid"];
		// drop this cavid...
		store_dropmsg ( $dbh, $mycavid, $myusid );

		// create meeting_id
		$meeting_id = uniqid ( $myusid . $mycavid, true );

		// get meeting start and end from the slid
		$strsql = "SELECT hb, hf FROM slots WHERE slid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$myslid
			) );
			$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// get coach phone number and reference
		$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$CID ["coid"]
			) );
			$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// get users name
		$strsql = "SELECT email, fname, lname FROM users WHERE usid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$myusid
			) );
			$CID4 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// get default location at this site
		$strsql = "SELECT def FROM locs WHERE loid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$CID ["loid"]
			) );
			$CID5 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		echolog ( "D", "Sending email" );
		// $calendarId = 'lateral@lateral.be';
		$event = $gservice->events->insert ( CALENDAR_ID, new Google_Service_Calendar_Event ( makeGoogleAgendaEvent ( $CID4 ["fname"], $CID4 ["lname"], $CID4 ["email"], $CID ["cdat"], $CID2 ["hb"], $CID2 ["hf"], $CID4 ["fname"] . " " . $CID4 ["lname"] . " - " . $CID5 ["def"] . ". Merci de contacter " . $CID3 ["fname"] . " " . $CID3 ["lname"] . " au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.", $CID ["loc"], "[" . USRV . "] Coaching de suivi de la formation de management", $meeting_id, $CID3 ["fname"] . " " . $CID3 ["lname"], $CID3 ["phone"], $CID3 ["email"] ) ), array (
				'sendNotifications' => true
		) );
		$google_id = $event->getId ();

		//
		echolog ( "D", "Updating CWHO" );
		$strsql = "INSERT INTO cwho (cwdate, usid, cwlocid, coid, cslid, cavid, uniqid, salle, google_id) VALUES (?,?,?,?,?,?,?,?,?)";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sqlarray = array (
					$CID ["cdat"],
					$myusid,
					$CID ["loid"],
					$CID ["coid"],
					$myslid,
					$mycavid,
					$meeting_id,
					$CID5 ["def"],
					$google_id
			);
			$sth->execute ( $sqlarray );
			echolog ( "D", "sql data : " );
			echolog ( "D", $sqlarray );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// $mail_sent = sendIcalEmail($CID4["fname"],$CID4["lname"],$CID4["email"],$CID["cdat"],$CID2["hb"],$CID2["hf"],
		// $CID4["fname"]. " " . $CID4["lname"]. " - l'endroit exact du coaching vous sera communiqué dès que possible. Merci de contacter " . $CID3["fname"] . " " .
		// $CID3["lname"] . " au " . $CID3["phone"] .
		// " ou par email via " . $CID3["email"] . " en cas de problème."
		// ,$CID["loc"],"[" . USRV . "] Coaching de suivi de la formation de management",$meeting_id,
		// $CID3["fname"] . " " . $CID3["lname"], $CID3["phone"], $CID3["email"]);

		sendLatEmail ( $CID3 ["email"], $CID3 ["fname"] . " " . $CID3 ["lname"], $CID4 ["email"], "[" . USRV . "] Coaching de suivi de la formation de management", "<p>Bonjour " . $CID4 ["fname"] . " " . $CID4 ["lname"] . ",</p>" . "<p>Voici la confirmation de votre rendez-vous de coaching avec " . $CID3 ["fname"] . " " . $CID3 ["lname"] . ".</p>" . "<p>Il aura lieu :<ul><li>à " . $CID ["loc"] . "  " . $CID5 ["def"] . "</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $CID ["cdat"] ) ) . " de " . $CID2 ["hb"] . " à " . $CID2 ["hf"] . "</li></ul></p>
				<p>Vous allez recevoir en complément de ce courriel une invitation Outlook à accepter dans votre calendrier.</p>
				<p>Merci de contacter votre coach au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>" . $CID3 ["fname"] . " " . $CID3 ["lname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $CID3 ["phone"] . "<br />" );

		echolog ( "D", "Mail sent" );
		$rmesg = "Rendez-vous envoyé et base de données mise à jour.";
	} else {
		echolog ( "D", "RDV ID $rdv_id not found" );
		$rmesg = "Aucun rendez-vous envoyé.";
	}
	return ($rmesg);
}
function update_manual_cwho($dbh, $coid, $datet, $myloid, $nslots, $gservice, $upcwho, $upgoogle, $upmail, $upsalle = null) {
	dblog ( $nslots );

	// select the corresponding data
	// update now cwho with all the usids and send an email presto !
	$realexec = true;
	$i = 0;
	// get coach phone number and reference
	$strsql = "SELECT email, phone, fname, lname FROM coach WHERE coid = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$coid
		) );
		$CID3 = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}

	// get loc name
	$strsql = "SELECT loc, def FROM locs WHERE loid = ? LIMIT 1";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$myloid
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	$myloc = $CID ["loc"];
	$mydef = $CID ["def"];
	// inform SRT that a new coaching session is scheduled
	@inform_srt ( $dbh, $datet, $myloid, $myloc, $CID3 ["fname"], $CID3 ["lname"], $CID3 ["phone"], $CID3 ["email"] );

	foreach ( $nslots as $slot ) {
		$i ++;
		// get the correct references
		$myusid = $slot ["usid"];
		$myslid = $slot ["slid"];
		// create meeting_id
		$meeting_id = uniqid ( $myusid . $myslid . $datet . $coid, true );
		//
		echolog ( "D", "Updating CWHO manually with data : upcwho is " . $upcwho . " - upgoogle is " . $upgoogle . " - upmail is " . $upmail );
		// look for a possible cavid at this moment
		$strsql = "SELECT COUNT(cavid) AS cc FROM cavail  WHERE cdat = ? AND coid = ? and slid = ?";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$datet,
					$coid,
					$myslid
			) );
			$CID = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}
		if ($CID ["cc"] == 0) {
			// create the CAVID
			$strsql = "INSERT INTO cavail (cdat,coid,slid) VALUES (?,?,?)";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sth->execute ( array (
						$datet,
						$coid,
						$myslid
				) );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}
			// get it back
		}
		// Get the cavid now
		$strsql = "SELECT cavid FROM cavail WHERE cdat = ? AND coid = ? and slid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$datet,
					$coid,
					$myslid
			) );
			$CID = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}
		$mycavid = $CID ["cavid"];

		// get meeting start and end from the slid
		$strsql = "SELECT hb, hf FROM slots WHERE slid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$myslid
			) );
			$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		// get users name
		$strsql = "SELECT email, fname, lname FROM users WHERE usid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$myusid
			) );
			$CID4 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}

		$rmesg = "";
		if ($upgoogle) {
			echolog ( "D", "Updating Calendar" );
			// $calendarId = 'lateral@lateral.be';
			if ($realexec) {
				$event = $gservice->events->insert ( CALENDAR_ID, new Google_Service_Calendar_Event ( makeGoogleAgendaEvent ( $CID4 ["fname"], $CID4 ["lname"], $CID4 ["email"], $datet, $CID2 ["hb"], $CID2 ["hf"], $CID4 ["fname"] . " " . $CID4 ["lname"] . " - " . $mydef . ". Merci de contacter " . $CID3 ["fname"] . " " . $CID3 ["lname"] . " au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.", $myloc, "[" . USRV . "] Coaching de suivi avec " . $CID3 ["fname"] . " " . $CID3 ["lname"], $meeting_id, $CID3 ["fname"] . " " . $CID3 ["lname"], $CID3 ["phone"], $CID3 ["email"] ) ), array (
						'sendNotifications' => true
				) );
				$google_id = $event->getId ();
			} else {
				$google_id = null;
			}
			$rmesg .= "Invitation par agenda envoyée.<br />";
		} else {
			$google_id = null;
		}

		//
		if ($upcwho) {
			echolog ( "D", "Updating cwho" );
			$strsql = "INSERT INTO cwho (cwdate, usid, cwlocid, coid, cslid, cavid, uniqid, google_id, salle) VALUES (?,?,?,?,?,?,?,?,?)";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sqlarray = array (
						$datet,
						$myusid,
						$myloid,
						$coid,
						$myslid,
						$mycavid,
						$meeting_id,
						$google_id,
						$upsalle
				);
				if ($realexec) {
					$sth->execute ( $sqlarray );
				}
				echolog ( "D", "sql data : " );
				echolog ( "D", $sqlarray );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}
			$rmesg .= "Base de données mise à jour.<br />";
		}

		if ($upmail) {
			echolog ( "D", "Sending email" );

			if ($realexec) {
				sendLatEmail ( $CID3 ["email"], $CID3 ["fname"] . " " . $CID3 ["lname"], $CID4 ["email"], "[" . USRV . "] Coaching de suivi de la formation de management", "<p>Bonjour " . $CID4 ["fname"] . " " . $CID4 ["lname"] . ",</p>" . "<p>Voici la confirmation de votre rendez-vous de coaching avec " . $CID3 ["fname"] . " " . $CID3 ["lname"] . ".</p>" . "<p>Il aura lieu :<ul><li>à " . $CID ["loc"] . " - " . $CID ["def"] . "</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $datet ) ) . " de " . $CID2 ["hb"] . " à " . $CID2 ["hf"] . "</li></ul></p>
				<p>Vous allez recevoir en complément de ce courriel une invitation Outlook à accepter dans votre calendrier.</p>
				<p>Merci de contacter votre coach au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>" . $CID3 ["fname"] . " " . $CID3 ["lname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $CID3 ["phone"] . "<br />" );
			}

			echolog ( "D", "Mail sent" );
			$rmesg .= "Courriel de confirmation envoyé.<br />";
		}
	}

	return ($rmesg . "Opération répétée " . $i . " fois");
}
function get_users_ww($dbh, $loid, $coid) {
	dblog ( "Loid = " . $loid . " and Coid = " . $coid );

	$locusers = array ();
	$strsql = "SELECT * FROM whowhere WHERE loid = ? AND (coid = ? OR coid = 0) ORDER by lname ASC";
	echolog ( "D", "Selecting users in get_users_ww" );
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$loid,
				$coid
		) );
		$CID = $sth->fetchall ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	// store those
	foreach ( $CID as $lcid ) {
		$locusers [] = $lcid;
	}

	return $locusers;
}
function delete_event($dbh, $cwid, $gservice) {
	dblog ( "cwid = " . $cwid );

	// this functions deletes an event in the calendar
	// get event id from cwho
	echolog ( "D", "Deleting event from delete_event" );
	$strsql = "SELECT google_id, uniqid FROM cwho WHERE cwid = ? LIMIT 1";
	echolog ( "D", "SQL is " . $strsql . " with cwid " . $cwid );
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$cwid
		) );
		$CID = $sth->fetch ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	echolog ( "D", "Query results" );
	echolog ( "D", $CID );
	$event_id = $CID ["google_id"];
	$gid = GetEventId ( $CID ["uniqid"], $gservice );
	echolog ( "D", "Google eventid retrieved is " . $event_id );
	if ($event_id != null && $gid !== 0) {
		// $calendarId = 'lateral@lateral.be';
		$event = $gservice->events->delete ( CALENDAR_ID, $event_id, array (
				'sendNotifications' => true
		) );
		echolog ( "D", "Google answer" );
		echolog ( "D", $event );
	}
	return;
}
function store_dropmsg($dbh, $cavid, $myusid = null) {
	dblog ( "cavid = " . $cavid );

	echolog ( "D", "Entering store_dropmsg for cavid = " . $cavid . " and from user : " . $myusid );
	$strsql = "SELECT usid FROM avail WHERE cavid = ? AND usid != ?";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ( array (
				$cavid,
				$myusid
		) );
		$CID = $sth->fetchall ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	echolog ( "D", "Users Returned" );
	echolog ( "D", $CID );
	// if no other user, stop
	if (! empty ( $CID )) {
		$strsql = "SELECT * FROM cavail WHERE cavid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$cavid
			) );
			$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}
		echolog ( "D", "Cavid data returned" );
		echolog ( "D", $CID2 );
		$myslid = $CID2 ["slid"];
		$mycoid = $CID2 ["coid"];
		$datet = $CID2 ["cdat"];
		echolog ( "D", "Slid : " . $myslid . " - Coid : " . $mycoid . " - cdat : " . $datet );

		// get meeting start and end from the slid
		$strsql = "SELECT hb, hf FROM slots WHERE slid = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$myslid
			) );
			$CID2 = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}
		echolog ( "D", "Slid data returned" );
		echolog ( "D", $CID2 );
		$myhb = $CID2 ["hb"];
		$myhf = $CID2 ["hf"];
		echolog ( "D", "Hb : " . $myhb . " - Hf: " . $myhf );

		// loop on users
		foreach ( $CID as $ploc ) {
			$myusid = $ploc ["usid"];
			echolog ( "D", "Storing deleted information in DB" );
			$strsql = "INSERT INTO dropmsg (cdat,usid,coid,hb,hf,dcavid) VALUES (?,?,?,?,?,?)";
			try {
				$sth = $dbh->prepare ( $strsql );
				$sqlarray = array (
						$datet,
						$myusid,
						$mycoid,
						$myhb,
						$myhf,
						$cavid
				);
				$sth->execute ( $sqlarray );
				echolog ( "D", "sql data : " );
				echolog ( "D", $sqlarray );
				$sth->closeCursor ();
			} catch ( PDOException $e ) {
				echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
				exit ();
			}
		}
	}
	return;
}
function bizz() {
	dblog ();

	sendLatEmail ( $CID3 ["email"], $CID3 ["fname"] . " " . $CID3 ["lname"], $CID4 ["email"], "[" . USRV . "] Coaching de suivi de la formation de management - mise à jour des disponibilités", "<p>Bonjour " . $CID4 ["fname"] . " " . $CID4 ["lname"] . ",</p>" . "<p>Vous recevez ce courriel pour vous informer que la plage horaire du  " . strftime ( "%A %d %B %Y", strtotime ( $datet ) ) . " de " . $CID2 ["hb"] . " à " . $CID2 ["hf"] . ", que vous aviez annoncée comme une de vos disponibilités, n'est plus disponible pour un coaching avec " . $CID3 ["fname"] . " " . $CID3 ["lname"] . ".</p>" . "<p>En conséquence, il est inutile de garder cette plage horaire réservée pour un coaching dans votre agenda.</p>" . "<p>Merci de contacter votre coach au " . $CID3 ["phone"] . " ou par email via " . $CID3 ["email"] . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>" . $CID3 ["fname"] . " " . $CID3 ["lname"] . "</p><br />" . MAILSIG . "<br />GSM : " . $CID3 ["phone"] . "<br />" );
	echolog ( "D", "Mail sent" );
}
function UpdateEventsIds($dbh, $gservice) {
	dblog ();

	// get event id from cwho
	$strsql = "SELECT uniqid FROM cwho WHERE uniqid IS NOT NULL";
	try {
		$sth = $dbh->prepare ( $strsql );
		$sth->execute ();
		$CID = $sth->fetchall ( PDO::FETCH_ASSOC );
		$sth->closeCursor ();
	} catch ( PDOException $e ) {
		echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
		exit ();
	}
	// $myevents = array();
	$i = 0;
	foreach ( $CID as $myevent ) {
		// $myevents[] = array("icaluid" => $myevent["uniqid"],"id" => GetEventId($myevent["uniqid"],$gservice)) ;
		$strsql = "UPDATE cwho SET google_id = ? WHERE uniqid = ?";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					GetEventId ( $myevent ["uniqid"], $gservice ),
					$myevent ["uniqid"]
			) );
			$sth->closeCursor ();
			$i ++;
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}
	}

	return $i;
}
function ModifyEventTiming($iCaluid, $meeting_date, $meeting_start, $meeting_end, $gservice) {
	dblog ( "iCaluid = " . $iCaluid . " in Calendar " . CALENDAR_ID );
	if ($iCaluid !== 0) {
		// First retrieve the event from the API.
		$event = $gservice->events->get ( CALENDAR_ID, $iCaluid );
		// Convert MYSQL datetime and construct iCal start, end and issue dates
		$meetingstamp = STRTOTIME ( $meeting_date . " " . $meeting_start );
		$dtstart = DATE ( "Y-m-d\TH:i:s", $meetingstamp );
		$meetingstamp = STRTOTIME ( $meeting_date . " " . $meeting_end );
		$dtend = DATE ( "Y-m-d\TH:i:s", $meetingstamp );
		$ev_start = new Google_Service_Calendar_EventDateTime ();
		$ev_start->setDateTime ( $dtstart );
		$ev_start->setTimeZone ( "Europe/Brussels" );
		$ev_end = new Google_Service_Calendar_EventDateTime ();
		$ev_end->setDateTime ( $dtend );
		$ev_end->setTimeZone ( "Europe/Brussels" );

		// update event
		$event->setEnd ( $ev_end );
		$event->setStart ( $ev_start );
		$updatedEvent = $gservice->events->update ( CALENDAR_ID, $iCaluid, $event, array (
				'sendNotifications' => true
		) );
	}
	return;
}
function ModifyEventLocation($iCaluid, $meeting_location, $gservice) {
	dblog ( "iCaluid = " . $iCaluid . " in Calendar " . CALENDAR_ID );
	// First retrieve the event from the API.
	if ($iCaluid !== 0) {
		$event = $gservice->events->get ( CALENDAR_ID, $iCaluid );
		// update event
		$event->setLocation ( $meeting_location );
		$updatedEvent = $gservice->events->update ( CALENDAR_ID, $iCaluid, $event, array (
				'sendNotifications' => true
		) );
	}
	return;
}
function GetEventId($iCaluid, $gservice) {
	dblog ( "iCaluid = " . $iCaluid . " in Calendar " . CALENDAR_ID );

	// This function retrieves the id of an event from the iCaluid
	// $calendarId = 'lateral@lateral.be';
	$params = array ();
	$params ['iCalUID'] = $iCaluid;
	$events = $gservice->events->listEvents ( CALENDAR_ID, $params );
	if (count ( $events->getItems () ) > 0) {
		foreach ( $events->getItems () as $event ) {
			$event_id = $event->getId ();
		}
	} else {
		$event_id = 0;
	}
	// only one event returned !
	return $event_id;
}
function GetEventsIds($dbh, $searchstring, $gservice) {
	dblog ( "searchstring = " . $searchstring );

	// This function retrieves the id of an event from the iCaluid
	// $calendarId = 'lateral@lateral.be';
	$params = array ();
	$params ['q'] = $searchstring;
	$params ['orderBy'] = "startTime";
	$params ['timeMax'] = "2017-12-31T23:00:00+01:00";
	$params ['timeMin'] = "2015-01-01T23:00:00+01:00";
	$params ['singleEvents'] = true;
	$myevents = array ();
	$events = $gservice->events->listEvents ( CALENDAR_ID, $params );
	foreach ( $events->getItems () as $event ) {
		// extract data from the calendar
		$thisdate = $event->getStart ()->dateTime;
		$cdat = substr ( $thisdate, 0, 10 );
		$hb = substr ( $thisdate, 11, 5 );
		$thisdate = $event->getEnd ()->dateTime;
		$hf = substr ( $thisdate, 11, 5 );
		// Correct hb and hf for peculiarities of the past
		if ($hb == "14:10" && $hf == "16:10") {
			$hb = "14:00";
			$hf = "16:00";
		}
		if ($hb == "11:00" && $hf == "13:00") {
			$hb = "11:10";
			$hf = "13:10";
		}
		if ($hb == "11:15" && $hf == "13:15") {
			$hb = "11:10";
			$hf = "13:10";
		}
		if ($hb == "14:10" && $hf == "16:00") {
			$hb = "14:00";
			$hf = "16:00";
		}
		// look for slid if it exists
		$strsql = "SELECT slid FROM slots WHERE hb = ? AND hf = ? LIMIT 1";
		try {
			$sth = $dbh->prepare ( $strsql );
			$sth->execute ( array (
					$hb,
					$hf
			) );
			$CID = $sth->fetch ( PDO::FETCH_ASSOC );
			$sth->closeCursor ();
		} catch ( PDOException $e ) {
			echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
			exit ();
		}
		$myslid = ! empty ( $CID ) ? $CID ["slid"] : - 1;
		echolog ( "D", "Event captured : " . $cdat . "-" . $myslid );
		// get emails
		foreach ( $event->getAttendees () as $attendee ) {
			$email = $attendee->getEmail ();
			$email = strtolower ( $email );
			echolog ( "D", "Email retrieved : " . $email );
			if ($email != "lateralsprl@gmail.com" and $email != "mguisset.mg@gmail.com") {
				// correct emails
				if ($email === "thierry.herman@cepegra.be") {
					$email = "thierry.herman@forem.be";
				}
				if ($email === "anne-francoise.gillain@forem.be") {
					$email = "annefrancoise.gillain@forem.be";
				}
				if ($email === "ingrid.bouillart@forem.be") {
					$email = "ingrid.bouilliart@forem.be";
				}
				// look for usid if it exists
				$mysql = "";
				$strsql = "SELECT COUNT(usid) AS usc FROM users WHERE LOWER(email) = ?";
				try {
					$sth = $dbh->prepare ( $strsql );
					$sth->execute ( array (
							strtolower ( $email )
					) );
					$CID = $sth->fetch ( PDO::FETCH_ASSOC );
					$sth->closeCursor ();
				} catch ( PDOException $e ) {
					echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
					exit ();
				}
				if ($CID ["usc"] > 0) {
					// look for usid if it exists
					$strsql = "SELECT usid, coid FROM users WHERE LOWER(email) = ? LIMIT 1";
					try {
						$sth = $dbh->prepare ( $strsql );
						$sth->execute ( array (
								strtolower ( $email )
						) );
						$CID = $sth->fetch ( PDO::FETCH_ASSOC );
						$sth->closeCursor ();
					} catch ( PDOException $e ) {
						echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
						exit ();
					}
					$myusid = $CID ["usid"];
					$mycoid = $CID ["coid"];
					echolog ( "D", "Usid retrieved : " . $myusid );
					// verifier qu'il est dans cwho !
					$strsql = "SELECT COUNT(cwid) AS cw FROM cwho WHERE cwdate = ? AND usid = ? AND cslid = ? LIMIT 1";
					try {
						$sth = $dbh->prepare ( $strsql );
						$sth->execute ( array (
								$cdat,
								$myusid,
								$myslid
						) );
						$CID = $sth->fetch ( PDO::FETCH_ASSOC );
						$sth->closeCursor ();
					} catch ( PDOException $e ) {
						echolog ( 'F', 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
						exit ();
					}
					if ($CID ["cw"] > 0) {
						echolog ( "D", "Meeting retrieved : " . $CID ["cw"] );
					} else {
						echolog ( "D", "Meeting NOT retrieved" );
						$myusid = $myusid;
						$mysql = 'INSERT INTO cwho (cwdate,usid,cwlocid,coid,cslid) VALUES("' . $cdat . '",' . $myusid . ',1,' . $mycoid . ',' . $myslid . ');';
					}
				} else {
					echolog ( "D", "User NOT retrieved" );
					$myusid = "A insérer dans users !";
				}
				$name = $attendee->getDisplayName ();
				// insert event for each attendee
				$myevents [] = array (
						$cdat,
						$hb,
						$hf,
						$myslid,
						$email,
						$myusid,
						$mysql
				);
			}
		}
	}
	return $myevents;
}
function preparePHPMailer() {
	global $mail;
	// Tell PHPMailer to use SMTP
	$mail->isSMTP ();
	// Enable SMTP debugging
	// 0 = off (for production use)
	// 1 = client messages
	// 2 = client and server messages
	$mail->SMTPDebug = 0;
	// SSL or TLS
	$mail->SMTPSecure = 'ssl';
	$mail->SMTPAutoTLS = true;
	// Set the hostname of the mail server
	$mail->Host = 'lateral.be';
	// Set the SMTP port number - likely to be 25, 465 or 587
	$mail->Port = 465;
	// Whether to use SMTP authentication
	$mail->SMTPAuth = true;
	// Username to use for SMTP authentication
	$mail->Username = 'lateral@lateral.be';
	// Password to use for SMTP authentication
	$mail->Password = 'LesActivateurs123';
	// Set the charset
	$mail->CharSet = 'UTF-8';
	// Set the encoding
	$mail->Encoding = '8bit';
	return;
}
function sendLatEmail($fr_email, $fr_name, $to_email, $subject, $mail_body) {
	dblog ( "subject : " . $subject );
	// Import PHPMailer classes into the global namespace
	global $mail;
	// $mail = new PHPMailer;
	// Set who the message is to be sent from
	$mail->setFrom ( $fr_email, $fr_name );
	// Set an alternative reply-to address
	// $mail->addReplyTo('bouncesforem@lateral.be');
	$addresses = explode ( ',', $to_email );
	// Set who the message is to be sent to
	foreach ( $addresses as $address ) {
		$mail->AddAddress ( $address );
	}
	// $mail->addAddress($to_email);
	// cc the message to the sender
	$mail->addCC ( $fr_email, $fr_name );
	// Set who the message is to be sent to
	$mail->addBCC ( 'dropbox@26622413.lateral.highrisehq.com', 'CRM Lateral' );
	$mail->addBCC ( 'copycat@lateral.be', 'Copy Cat' );
	// Set the subject line
	$mail->Subject = $subject;
	// Set the content, including alt text
	$mail->msgHTML ( $mail_body );
	// SEND MAIL
	if (LOC != "local") {
		$issent = $mail->send ();
		if (! $issent) {
			dblog ( 'Mailer Error: ' . $mail->ErrorInfo );
		} else {
			dblog ( 'Message sent!' );
		}
	} else {
		$issent = true;
	}
	// Clear $mail
	// Clear all addresses and attachments for next loop
	$mail->clearAddresses ();
	$mail->clearAttachments ();
	$mail->clearBCCs ();
	$mail->clearCCs ();
	//
	return ($issent);
}
function makeGoogleAgendaEvent($firstname, $lastname, $email, $meeting_date, $meeting_start, $meeting_end, $meeting_description, $meeting_location, $meeting_subject, $meeting_id, $coachname, $coachphone, $coachemail) {
	dblog ( "Meeting id = " . $meeting_id );

	$from_name = $coachname;
	$from_address = "lateral@lateral.be";
	$to_email = $email;
	// Convert MYSQL datetime and construct iCal start, end and issue dates
	$meetingstamp = STRTOTIME ( $meeting_date . " " . $meeting_start );
	$dtstart = DATE ( "Y-m-d\TH:i:s", $meetingstamp );
	$meetingstamp = STRTOTIME ( $meeting_date . " " . $meeting_end );
	$dtend = DATE ( "Y-m-d\TH:i:s", $meetingstamp );
	$todaystamp = DATE ( "Y-m-d\TH:i:s" );

	// Create unique identifier
	$cal_uid = $meeting_id;

	// Create the attendees array
	if ($coachemail == $email) {
		$cal_attendees = array (
				array (
						'email' => $from_address,
						'displayname' => $coachname,
						'organizer' => true
				)
		);
	} else {
		$cal_attendees = array (
				array (
						'email' => $email,
						'displayname' => $firstname . ' ' . $lastname
				),
				array (
						'email' => $from_address,
						'displayname' => $coachname,
						'organizer' => true
				)
		);
	}

	$google_event = [ 
			'summary' => $meeting_subject,
			'location' => $meeting_location,
			'description' => $meeting_description,
			'start' => array (
					'dateTime' => $dtstart,
					'timeZone' => 'Europe/Brussels'
			),
			'end' => array (
					'dateTime' => $dtend,
					'timeZone' => 'Europe/Brussels'
			),
			'attendees' => $cal_attendees,
			'iCalUID' => $meeting_id,
			'reminders' => array (
					'useDefault' => false,
					'overrides' => array (
							array (
									'method' => 'email',
									'minutes' => 24 * 60
							)
					)
			)
	];

	return $google_event;
}
function sendIcalEmail($firstname, $lastname, $email, $meeting_date, $meeting_start, $meeting_end, $meeting_description, $meeting_location, $meeting_subject, $meeting_id, $coachname, $coachphone, $coachemail) {
	dblog ( "meeting id = " . $meeting_id );

	$from_name = $coachname;
	$from_address = "lateral@lateral.be";
	$to_email = $email;
	// Convert MYSQL datetime and construct iCal start, end and issue dates
	$meetingstamp = STRTOTIME ( $meeting_date . " " . $meeting_start );
	$dtstart = DATE ( "Ymd\THis", $meetingstamp );
	$meetingstamp = STRTOTIME ( $meeting_date . " " . $meeting_end );
	$dtend = DATE ( "Ymd\THis", $meetingstamp );
	$todaystamp = DATE ( "Ymd\THis" );

	// Create unique identifier
	$cal_uid = $meeting_id;

	// Create Mime Boundary
	$mime_boundary = "----Meeting Booking----" . MD5 ( TIME () );

	// Create Email Headers
	$headers = "From: " . $from_name . " <" . $from_address . ">\n";
	$headers .= "Reply-To: " . $from_name . " <" . $from_address . ">\n";

	$headers .= "MIME-Version: 1.0\n";
	$headers .= "Content-Type: multipart/alternative; boundary=\"$mime_boundary\"\n";
	$headers .= "Content-class: urn:content-classes:calendarmessage\n";

	// Create Email Body (HTML)
	$message = "--$mime_boundary\n";
	$message .= "Content-Type: text/html; charset=UTF-8\n";
	$message .= "Content-Transfer-Encoding: 8bit\n\n";

	$message .= "<html>\n";
	$message .= "<body>\n";
	$message .= '<p>Bonjour ' . $firstname . ' ' . $lastname . ',</p>';
	$message .= "<p>Voici la confirmation de votre rendez-vous de coaching avec " . $coachname . ".</p>
			<p>Il aura lieu :<ul><li>à " . $meeting_location . " (l'endroit exact vous sera communiqué dès qu'il sera connu)</li>
					<li> le " . strftime ( "%A %d %B %Y", strtotime ( $meeting_date ) ) . " de " . $meeting_start . " à " . $meeting_end . "</li></ul></p>
				<p>Merci de le contacter au " . $coachphone . " ou par email via " . $coachemail . " en cas de problème.</p><br /><p>Bien amicalement,</p>
				<p>$coachname</p><br />" . MAILSIG . "<br />GSM : " . $coachphone . "<br />";
	$message .= "</body>\n";
	$message .= "</html>\n";
	$message .= "--$mime_boundary\n";

	// Create ICAL Content (Google rfc 2445 for details and examples of usage)
	$ical = 'BEGIN:VCALENDAR
PRODID:-//Microsoft Corporation//Outlook 11.0 MIMEDIR//EN
VERSION:2.0
METHOD:PUBLISH
	BEGIN:VTIMEZONE
	TZID:Europe/Brussels
	BEGIN:DAYLIGHT
	TZOFFSETFROM:+0100
	RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU
	DTSTART:19810329T020000
	TZNAME:GMT+2
	TZOFFSETTO:+0200
	END:DAYLIGHT
	BEGIN:STANDARD
	TZOFFSETFROM:+0200
	RRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU
	DTSTART:19961027T030000
	TZNAME:GMT+1
	TZOFFSETTO:+0100
	END:STANDARD
	END:VTIMEZONE
BEGIN:VEVENT
ORGANIZER;CN="' . $from_name . '":MAILTO:' . $from_address . '
DTSTART;TZID=Europe/Brussels:' . $dtstart . '
DTEND;TZID=Europe/Brussels:' . $dtend . '
LOCATION:' . $meeting_location . '
TRANSP:OPAQUE
SEQUENCE:0
UID:' . $cal_uid . '
DTSTAMP:' . $todaystamp . '
DESCRIPTION:' . $meeting_description . '
SUMMARY:' . $meeting_subject . '
PRIORITY:5
CLASS:PUBLIC
ATTENDEE;CN="' . $from_name . '";CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-ACTION;ROLE=REQ-
PARTICIPANT;X-NUM-GUESTS=0;RSVP=TRUE:mailto:' . $from_address . '
ATTENDEE;CN="' . $firstname . ' ' . $lastname . '";CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-
ACTION;ROLE=REQ-PARTICIPANT;X-NUM-GUESTS=0;RSVP=TRUE:mailto:' . $email . '		
END:VEVENT
END:VCALENDAR';

	$message .= 'Content-Type: text/calendar;name="coaching-meeting.ics";method=REQUEST\n';
	$message .= "Content-Transfer-Encoding: 8bit\n\n";
	$message .= $ical;

	// SEND MAIL
	if (LOC != "local") {
		$mail_sent = @MAIL ( $to_email, $meeting_subject, $message, $headers );
		if ($email != $coachemail) {
			$mail_sent2 = @MAIL ( $from_address, $meeting_subject, $message, $headers );
		} else {
			$mail_sent2 = true;
		}
	}

	if ($mail_sent and $mail_sent2) {
		echolog ( "D", "Sending mail succeeded" );
	} else {
		echolog ( "D", "Sending mail failed" );
	}
	return ($mail_sent and $mail_sent2);
}

// echo "all finished, now entering db";
// This file connects to the DB, fetches the acl of the current user and stores it in session variables
// Open Connection to the database
// time to connect to the db
try {
	$dbh = new PDO ( 'mysql:host=localhost;charset=utf8;dbname=' . DB, DBUSER, PASS, array (
			PDO::ATTR_PERSISTENT => true
	) );
	// $dbh->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
	// $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);;
} catch ( PDOException $e ) {
	echolog ( "F", 'Échec lors de la connexion : ' . $e->getMessage () );
	exit ();
}

// list all possible incomers
$strsql = "SELECT * FROM coach ORDER BY coid";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ();
	$coacharray = $sth->fetchall ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}

// list all possible locations
$strsql = "SELECT * FROM locs ORDER BY loid";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ();
	$locsarray = $sth->fetchall ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}
if (count ( $locsarray ) > 2) {
	define ( "LOCSGT1", true );
	define ( "MSGLOC", "l'endroit exact sera déterminé en fonction des participants" );
} else {
	define ( "LOCSGT1", false );
	define ( "MSGLOC", $locsarray [1] ["loc"] . " - " . $locsarray [1] ["def"] );
}

// get the first and the last dates possible, from availabilities
$strsql = "SELECT MAX(cdat) as datemax FROM cavail";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ();
	$CID = $sth->fetch ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}
$datemax = $CID ["datemax"];

// get the default values
$strsql = "SELECT * FROM def";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ();
	$defarray = $sth->fetchall ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}
// FROM definitions for email
echolog ( "D", $defarray );
define ( "FR_EMAIL", find_in_array ( $defarray, "key", "fr_email", "val" ) );
define ( "FR_NAME", find_in_array ( $defarray, "key", "fr_name", "val" ) );
// define ( "CALENDAR_ID", find_in_array ( $defarray, "key", "calendar_id", "val" ) );
define ( "SLOTINI", find_in_array ( $defarray, "key", "slotini", "val" ) );
define ( "SLOTEND", find_in_array ( $defarray, "key", "slotend", "val" ) );
define ( "NMAXSESS", find_in_array ( $defarray, "key", "nmaxsess", "val" ) );
define ( "DAYSINTV", find_in_array ( $defarray, "key", "daysintv", "val" ) );
define ( "NMINPDAY", find_in_array ( $defarray, "key", "nminpday", "val" ) );
define ( "USRV", find_in_array ( $defarray, "key", "usrv", "val" ) );
define ( "DUDELA", find_in_array ( $defarray, "key", "dudela", "val" ) );
define ( "IMGREF", find_in_array ( $defarray, "key", "imgref", "val" ) );
define ( "CTR", find_in_array ( $defarray, "key", "ctr", "val" ) );
define ( "EMAIL", find_in_array ( $defarray, "key", "email", "val" ) );
define ( "MAILSIG", find_in_array ( $defarray, "key", "mailsig", "val" ) );

echolog ( "D", "Definitions setup<br/><ul><li>email : " . FR_EMAIL . "<li>name : " . FR_NAME . "<li>slotini : " . SLOTINI . "<li>slotend : " . SLOTEND . "<li>nmaxsess : " . NMAXSESS . "<li>daysintv : " . DAYSINTV . "<li>nminpday : " . NMINPDAY . "</ul>" );

// list all available slots here slots
$strsql = "SELECT * FROM slots WHERE slid >= ? AND slid <= ? ORDER BY slid";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ( array (
			SLOTINI,
			SLOTEND
	) );
	$slotsarray = $sth->fetchall ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}
// constructs slots as to be used

$strsql = "SELECT MIN(cdat) as datemin FROM cavail";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ();
	$CID = $sth->fetch ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}
$datemin = $CID ["datemin"];
date_default_timezone_set ( "Europe/Brussels" );
if (LOC == "local") {
	$myincludepath = '/usr/local/lib/php:';
	$myautoloadpath = '/Users/lateral/vendor/autoload.php';
	$myjsonsecretpath = '/Users/lateral/google/client_secret.json';
	$myfrlocale = 'fr_FR';
	$redirect_uri = 'http://' . $_SERVER ['HTTP_HOST'] . '/CForem/oauth2callback.php';
} else {
	$myincludepath = '/home2/forumlat/php:';
	$myautoloadpath = '/home2/forumlat/vendor/autoload.php';
	$myjsonsecretpath = '/home2/forumlat/google/client_secrets.json';
	$myfrlocale = 'fr_FR.UTF8';
	$redirect_uri = 'http://' . $_SERVER ['HTTP_HOST'] . '/oauth2callback.php';
}
setlocale ( LC_TIME, $myfrlocale );
// set locale for mysql as well - for time
$strsql = "SET lc_time_names = 'fr_BE'";
try {
	$sth = $dbh->prepare ( $strsql );
	$sth->execute ();
	$sth->closeCursor ();
} catch ( PDOException $e ) {
	echolog ( "F", 'Exception : ' . $e->getMessage () . '<br /><br />SQL = ' . $strsql );
	exit ();
}

$year = date ( "Y" );
$month = date ( "m" );
$day = date ( "d" );
$today = date ( "Y-m-d" );
$tomorrow = date ( "Y-m-d", mktime ( 0, 0, 0, date ( "m" ), date ( "d" ) + 1, date ( "Y" ) ) );
ini_set ( 'display_errors', 1 );
ini_set ( 'display_startup_errors', 1 );
error_reporting ( E_ALL );

#echo "all finished, now exiting db";
