<?php
/**
 * Quip
 *
 * Copyright 2010-11 by Shaun McCormick <shaun@modx.com>
 *
 * This file is part of Quip, a simple commenting component for MODx Revolution.
 *
 * Quip is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * Quip is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Quip; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA
 *
 * @package quip
 */
/**
 * Quip English language file
 * Translated by Jiri Pavlicek <jiri@pavlicek.cz>, www.pavlicek.cz
 * UTF-8 encoded
 *
 * @package quip
 * @subpackage lexicon
 */
$_lang['quip'] = 'Quip';
$_lang['quip_desc'] = 'Jednoduchá komentářová (diskusní) komponenta.';
$_lang['quip.ago'] = ' před';
$_lang['quip.ago_days'] = '[[+days]] dny';
$_lang['quip.ago_hours'] = '[[+hours]] hodiny';
$_lang['quip.ago_minutes'] = '[[+minutes]] minuty';
$_lang['quip.ago_seconds'] = '[[+seconds]] sekundy';
$_lang['quip.approve_selected'] = 'Schválit označené';
$_lang['quip.approved'] = 'Schváleno';
$_lang['quip.allowed_tags'] = 'Povolené HTML značky: [[+tags]]'; // ?? Allowed tags
$_lang['quip.anonymous'] = 'Anonymní';
$_lang['quip.author'] = 'Autor';
$_lang['quip.back_to_threads'] = 'Zpět na výpis vláken';
$_lang['quip.body'] = 'Tělo';
$_lang['quip.bulk_actions'] = 'Akce';
$_lang['quip.close'] = 'Zavřít';
$_lang['quip.comment'] = 'Příspěvek';
$_lang['quip.comment_add_new'] = 'Přidat nový komentář:';
$_lang['quip.comment_approve'] = 'Schválit příspěvek';
$_lang['quip.comment_approve_selected'] = 'Schválit označené komentáře';
$_lang['quip.comment_approved'] = 'Komentář schválen';
$_lang['quip.comment_approved_msg'] = 'Komentář od [[+name]] z [[+createdon]] byl úspěšně schválen.';
$_lang['quip.comment_delete'] = 'Odstranit komentář';
$_lang['quip.comment_delete_selected'] = 'Odstranit označené komentáře';
$_lang['quip.comment_deleted'] = 'Komentář odstraněn';
$_lang['quip.comment_deleted_msg'] = 'Komentář od [[+name]] z [[+createdon]] byl úspěšně odstraněn.';
$_lang['quip.comment_delete_confirm'] = 'Opravdu chcete tento komentář odstranit?';
$_lang['quip.comment_err_nf'] = 'Komentář nebyl nalezen.';
$_lang['quip.comment_err_ns'] = 'Komentář nespecifikován.';
$_lang['quip.comment_err_remove'] = 'Došlo k chybě při odstraňování komentáře.';
$_lang['quip.comment_err_save'] = 'Došlo k chybě při ukládání komentáře.';
$_lang['quip.comment_remove'] = 'Nenávratně odstranit komentář';
$_lang['quip.comment_remove_confirm'] = 'Opravdu chcete odstranit tento komentář? Smazaná data nebude možné obnovit.';
$_lang['quip.comment_remove_selected'] = 'Odstranit označené komentáře';
$_lang['quip.comment_unapprove'] = 'Neschválit komentář';
$_lang['quip.comment_unapprove_selected'] = 'neschválit označené komentáře';
$_lang['quip.comment_undelete'] = 'Obnovit komentář';
$_lang['quip.comment_undelete_selected'] = 'Obnovit označené komentáře';
$_lang['quip.comment_update'] = 'Aktualizovat komentář';
$_lang['quip.comment_view'] = 'Zobrazit komentář';
$_lang['quip.comment_will_be_moderated'] = 'Váš komentář byl odeslán a čeká na schválení moderátorem diskuse. O schválení komentáře budete informováni e-mailem.';
$_lang['quip.comments'] = 'Komentáře';
$_lang['quip.delete'] = 'Odstranit';
$_lang['quip.delete_selected'] = 'Odstranit označené';
$_lang['quip.email'] = 'E-mail';
$_lang['quip.email_err_ns'] = 'Prosím, zadejte e-mailovou adresu.';
$_lang['quip.err_fraud_attempt'] = 'CHYBA: ID uživatele se neshoduje. Detekován pokus o podvod.';
$_lang['quip.err_not_logged_in'] = 'Nejste přihlášen a tudíž nejste autorizován pro vkládání příspěvků.';
$_lang['quip.hide_deleted'] = 'Skrýt odstraněné';
$_lang['quip.intro_msg'] = 'Spravujte komentáře Quip zde.';
$_lang['quip.ip'] = 'IP';
$_lang['quip.latest_comments'] = 'Nejnovější komentáře';
$_lang['quip.latest_comments_for'] = 'Nejnovější komentáře pro';
$_lang['quip.latest_comments_msg'] = 'Zde zobrazíte nejnovější komentáře.';
$_lang['quip.login_to_comment'] = 'Prosím, přihlaste se abyste mohli komentovat.';
$_lang['quip.message_err_ns'] = 'Prosím zadejte zprávu k odeslání.';
$_lang['quip.moderated'] = 'Moderováno';
$_lang['quip.moderated_desc'] = 'Nový příspěvky do tohoto vlákna budou moderovány.';
$_lang['quip.moderators'] = 'Moderátoři';
$_lang['quip.moderators_desc'] = 'Čárkami oddělený výpis jmeno uživatelů, kteří mohou moderovat toto vlákno.';
$_lang['quip.moderator_group'] = 'Skupina moderátorů';
$_lang['quip.moderator_group_desc'] = 'Skupina uživatelů jejíž členové mohou moderovat toho vlákno.';
$_lang['quip.name'] = 'Jméno';
$_lang['quip.name_err_ns'] = 'Prosím, zadejte jméno.';
$_lang['quip.no_email_to_specified'] = 'Quip nemůže odeslat e-mail se spam reportem, protože nebyl nastaven e-mail administrátora.';
$_lang['quip.notify_me'] = 'Upozornit na nové odpovědi';
$_lang['quip.notification'] = 'Upozornění';
$_lang['quip.notification_create'] = 'Přidat upozornění';
$_lang['quip.notification_err_nf'] = 'Upozornění nebylo nalezeno!';
$_lang['quip.notification_err_ns'] = 'Upozornění není specifikováno!';
$_lang['quip.notification_remove'] = 'Odstranit upozornění';
$_lang['quip.notification_remove_confirm'] = 'Opravdu chcete odhlásit tohoto uživatele z tohoto vlákna?'; // ??? Are you sure you want to unsubscribe this user from this Thread?
$_lang['quip.notifications'] = 'Upozornění';
$_lang['quip.notifications.intro_msg'] = 'Zde je výpis všech uživatelů přihlášených k tomuto vláknu.';
$_lang['quip.post'] = 'Příspěvek';
$_lang['quip.posted'] = 'Poslán';
$_lang['quip.postedon'] = 'Poslán v';
$_lang['quip.preview'] = 'Náhled';
$_lang['quip.recaptcha_err_load'] = 'Nemohu načíst obslužnou třídu reCaptcha.';
$_lang['quip.reply'] = 'Odpověď';
$_lang['quip.remove'] = 'Odstranit';
$_lang['quip.remove_selected'] = 'Odstranit označené';
$_lang['quip.report_as_spam'] = 'Nahlásit jako spam';
$_lang['quip.reported_as_spam'] = 'Nahlášeno jako spam';
$_lang['quip.sfs_err_load'] = 'Nepodařilo se načíst třídu StopForumSpam.';
$_lang['quip.show_deleted'] = 'Ukázat odstraněné';
$_lang['quip.spam_blocked'] = 'Váš příspěvek byl zablokován spam filtrem: [[+fields]]';
$_lang['quip.spam_email'] = '<p>Dobrý den,</p>

<p>Příspěvek uživatele [[+username]] byl nahlášen jako spam na:</p>

<p><a href="[[+url]]">[[+url]]</a></p>

<p>Toto je automaticky generovaný e-mail. Prosím, neodpovídejte. ID komentáře
je: <strong>[[+id]]</strong></p>

<p>
Děkuji,<br />
<em>Quip</em>
</p>';
$_lang['quip.spam_email_subject'] = '[Quip] komentářový spam oznámen';
$_lang['quip.spam_marked'] = ' - označen jako spam.';
$_lang['quip.subscribed_on'] = 'Přihlášen';
$_lang['quip.thread'] = 'Vlákno';
$_lang['quip.thread_autoclosed'] = 'Do tohoto vlákna již není možné vkládat komentáře.';
$_lang['quip.thread_err_ns'] = 'Není specifikováno vlákno.';
$_lang['quip.thread_err_remove'] = 'Došlo k chybě při odstraňování vlákna.';
$_lang['quip.thread_err_save'] = 'Došlo k chybě při ukládání vlákna.';
$_lang['quip.thread_manage'] = 'Spravovat vlákno';
$_lang['quip.thread_msg'] = 'Zde můžete spravovat všechny komentáře tohoto vlákna.';
$_lang['quip.thread_remove'] = 'Odstranit vlákno';
$_lang['quip.thread_remove_confirm'] = 'Opravdu chcete odstranit toto vlákno a všechny komentáře v něm? Odstraněná data není možné obnovit.';
$_lang['quip.thread_remove_selected'] = 'Odstranit označená vlákna';
$_lang['quip.thread_remove_selected_confirm'] = 'Opravdu chcete odstranit tato vlákna? Operace odstranění je nevratná.';
$_lang['quip.thread_truncate'] = 'Vyprázdnit vlákno';
$_lang['quip.thread_truncate_confirm'] = 'Opravdu chcete odstranit všechny komentáře v tomto vláknu?';
$_lang['quip.thread_truncate_selected'] = 'Vyprázdnit označená vlákna';
$_lang['quip.thread_truncate_selected_confirm'] = 'Opravdu chcete odstranit všechny komentáře v těchto vláknech?';
$_lang['quip.threads'] = 'Vlákna';
$_lang['quip.unapproved'] = 'Neschválené';
$_lang['quip.unapproved_comments'] = 'Neschválené komentáře';
$_lang['quip.unapproved_comments_msg'] = 'Moderujte libovolné neschválené komentáře zde.';
$_lang['quip.unsubscribe_me'] = 'Odhlásit se z tohoto vlákna';
$_lang['quip.unsubscribed'] = 'Byli jste odhlášeni z tohoto vlákna.';
$_lang['quip.username_said'] = '<strong>[[+username]]</strong> napsal:';
$_lang['quip.view'] = 'Zobrazit';
$_lang['quip.website'] = 'Web';

$_lang['area_tags'] = 'HTML značky'; // ??? tags
$_lang['setting_quip.allowed_tags'] = 'Povolené HTML značky'; // ??? Allowed Tags
$_lang['setting_quip.allowed_tags_desc'] = 'HTML značky povolené v komentářích uživatelů. Na adrese <a target="_blank" href="http://php.net/strip_tags">php.net/strip_tags</a> najdete seznam parametrů funkce.';
$_lang['setting_quip.emailsFrom'] = 'Z e-mailu';
$_lang['setting_quip.emailsFrom_desc'] = 'Adresa ze které systém bude odesílat e-maily.';
$_lang['setting_quip.emailsTo'] = 'Na e-mail';
$_lang['setting_quip.emailsTo_desc'] = 'E-mailová adresa na kterou bude systém posílat e-maily.';
$_lang['setting_quip.emailsReplyTo'] = 'Odpovědět na e-mail';
$_lang['setting_quip.emailsReplyTo_desc'] = 'E-mailová adresa pro odpovědi (reply-to hlavička). Výchozí hodnotou je emailFrom.';
$_lang['setting_quip.emails_from_name'] = 'Jméno odesílatele e-mailů';
$_lang['setting_quip.emails_from_name_desc'] = 'Jméno, které bude uvedeno ve From: hlavičce v odeslaných e-mailech.';