<?php
/**
 * Quip
 *
 * Copyright 2010-11 by Shaun McCormick <shaun@modx.com>
 *
 * This file is part of Quip, a simple commenting component for MODx Revolution.
 *
 * Quip is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * Quip is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Quip; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA
 *
 * @package quip
 */
/**
 * Quip German language file
 * Translated by Dennis "DenSchub" Schubert <software@dsx.cc>
 *
 * @package quip
 * @subpackage lexicon
 */
$_lang['quip'] = 'Quip';
$_lang['quip_desc'] = 'Eine einfache Kommentarkomponente.';
$_lang['quip.ago'] = ' vor';
$_lang['quip.ago_days'] = '[[+days]] Tagen';
$_lang['quip.ago_hours'] = '[[+hours]] Stunden';
$_lang['quip.ago_minutes'] = '[[+minutes]] Minuten';
$_lang['quip.ago_seconds'] = '[[+seconds]] Sekunden';
$_lang['quip.approve_selected'] = 'Ausgewählte genehmigen';
$_lang['quip.approved'] = 'Genehmigt';
$_lang['quip.allowed_tags'] = 'Erlaubte Tags: [[+tags]]';
$_lang['quip.anonymous'] = 'Anonymous';
$_lang['quip.author'] = 'Autor';
$_lang['quip.back_to_threads'] = 'Zurück zur Thread-Liste';
$_lang['quip.body'] = 'Inhalt';
$_lang['quip.bulk_actions'] = 'Stapelverarbeitung';
$_lang['quip.close'] = 'Schließen';
$_lang['quip.comment'] = 'Kommentar';
$_lang['quip.comment_add_new'] = 'Kommentar hinzufügen:';
$_lang['quip.comment_approve'] = 'Kommentar genehmigen';
$_lang['quip.comment_approve_selected'] = 'Ausgewählte Kommentare genehmigen';
$_lang['quip.comment_approved'] = 'Kommentar genehmigt';
$_lang['quip.comment_approved_msg'] = 'Der Kommentar von [[+name]] vom [[+createdon]] wurde genehmigt.';
$_lang['quip.comment_delete'] = 'Kommentar löschen';
$_lang['quip.comment_delete_selected'] = 'Ausgewählte Kommentare löschen';
$_lang['quip.comment_deleted'] = 'Kommentar gelöscht';
$_lang['quip.comment_deleted_msg'] = 'Der Kommentar von [[+name]] vom [[+createdon]] wurde gelöscht.';
$_lang['quip.comment_delete_confirm'] = 'Sind Sie sicher, dass Sie den Kommentar löschen möchten?';
$_lang['quip.comment_err_nf'] = 'Kommentar nicht gefunden.';
$_lang['quip.comment_err_ns'] = 'Kommentar nicht angegeben.';
$_lang['quip.comment_err_remove'] = 'Ein Fehler trat auf beim Versuch, den Kommentar zu löschen.';
$_lang['quip.comment_err_save'] = 'Ein Fehler trat auf beim Versuch, den Kommentar zu speichern.';
$_lang['quip.comment_remove'] = 'Kommentar endgültig löschen';
$_lang['quip.comment_remove_confirm'] = 'Sind Sie sicher, dass Sie diesen Kommentar endgültig löschen möchten? Dies kann nicht rückgängig gemacht werden.';
$_lang['quip.comment_remove_selected'] = 'Ausgewählte Kommentare entfernen';
$_lang['quip.comment_unapprove'] = 'Genehmigung für Kommentar widerrufen';
$_lang['quip.comment_unapprove_selected'] = 'Genehmigung für ausgewählte Kommentare widerrufen';
$_lang['quip.comment_undelete'] = 'Kommentar wiederherstellen';
$_lang['quip.comment_undelete_selected'] = 'Ausgewählte Kommentare wiederherstellen';
$_lang['quip.comment_update'] = 'Kommentar bearbeiten';
$_lang['quip.comment_view'] = 'Kommentar anzeigen';
$_lang['quip.comment_will_be_moderated'] = 'Ihr Kommentar wurde abgeschickt und wartet nun auf Moderation. Sie werden eine E-Mail erhalten, wenn der Kommentar genehmigt wurde.';
$_lang['quip.comments'] = 'Kommentare';
$_lang['quip.delete'] = 'Löschen';
$_lang['quip.delete_selected'] = 'Ausgewählte löschen';
$_lang['quip.email'] = 'E-Mail';
$_lang['quip.email_err_ns'] = 'Bitte geben Sie eine E-Mail-Adresse ein.';
$_lang['quip.err_fraud_attempt'] = 'Fehler: Benutzer-IDs stimmen nicht überein. Betrugsversuch entdeckt.';
$_lang['quip.err_not_logged_in'] = 'Sie sind nicht eingeloggt und deshalb nicht befugt, Kommentare zu schreiben.';
$_lang['quip.hide_deleted'] = 'Gelöschte ausblenden';
$_lang['quip.intro_msg'] = 'Verwalten Sie hier Ihre Quip-Kommentare und -Threads.';
$_lang['quip.ip'] = 'IP';
$_lang['quip.latest_comments'] = 'Neueste Kommentare';
$_lang['quip.latest_comments_for'] = 'Neueste Kommentare für';
$_lang['quip.latest_comments_msg'] = 'Hier sehen Sie die neuesten Kommentare.';
$_lang['quip.login_to_comment'] = 'Bitte loggen Sie sich ein, um einen Kommentar zu verfassen.';
$_lang['quip.message_err_ns'] = 'Bitte geben Sie eine Nachricht ein.';
$_lang['quip.moderated'] = 'Moderiert';
$_lang['quip.moderated_desc'] = 'Neue Beiträge zu diesem Thread werden moderiert.';
$_lang['quip.moderators'] = 'Moderatoren';
$_lang['quip.moderators_desc'] = 'Eine kommaseparierte Liste von Benutzern, die diesen Thread moderieren dürfen.';
$_lang['quip.moderator_group'] = 'Moderatorengruppe';
$_lang['quip.moderator_group_desc'] = 'Eine Benutzergruppe, deren Mitglieder diesen Thread moderieren dürfen.';
$_lang['quip.name'] = 'Name';
$_lang['quip.name_err_ns'] = 'Bitte geben Sie einen Namen ein.';
$_lang['quip.no_email_to_specified'] = 'Quip kann keine Spam-Report-E-Mail senden, weil keine Admin-E-Mail-Adresse gespeichert ist.';
$_lang['quip.notify_me'] = 'Bei neuen Antworten benachrichtigen';
$_lang['quip.notification'] = 'Benachrichtigung';
$_lang['quip.notification_create'] = 'Benachrichtigung hinzufügen';
$_lang['quip.notify_me'] = 'Bei neuen Antworten benachrichtigen';
$_lang['quip.notification_err_ns'] = 'Benachrichtigung nicht angegeben!';
$_lang['quip.notification_remove'] = 'Benachrichtigung löschen';
$_lang['quip.notification_remove_confirm'] = 'Sind Sie sicher, dass Sie diesen Benutzer von diesem Thread abmelden möchten?';
$_lang['quip.notifications'] = 'Benachrichtigungen';
$_lang['quip.notifications.intro_msg'] = 'Hier ist eine Liste aller Benutzer, die diesen Thread abonniert haben.';
$_lang['quip.post'] = 'Absenden';
$_lang['quip.posted'] = 'Abgesendet';
$_lang['quip.postedon'] = 'Geschrieben am';
$_lang['quip.preview'] = 'Vorschau';
$_lang['quip.recaptcha_err_load'] = 'Konnte die reCaptcha-Service-Klasse nicht laden.';
$_lang['quip.reply'] = 'Antworten';
$_lang['quip.remove'] = 'Löschen';
$_lang['quip.remove_selected'] = 'Ausgewählte endgültig löschen';
$_lang['quip.report_as_spam'] = 'Als Spam melden';
$_lang['quip.reported_as_spam'] = 'Als Spam gemeldet';
$_lang['quip.sfs_err_load'] = 'Konnte die StopForumSpam-Klasse nicht laden.';
$_lang['quip.show_deleted'] = 'Gelöschte anzeigen';
$_lang['quip.spam_blocked'] = 'Deine Anfrage wurde von einem Spamfilter blockiert: [[+fields]]';
$_lang['quip.spam_email'] = '<p>Hallo,</p>

<p>Ein Kommentar von [[+username]] wurde als Spam gemeldet:</p>

<p><a href="[[+url]]">[[+url]]</a></p>

<p>Dies ist eine automatisch generierte E-Mail. Bitte antworten Sie nicht direkt darauf. Die
Kommentar-ID ist: <strong>[[+id]]</strong></p>

<p>
Danke,<br />
<em>Quip</em>
</p>';
$_lang['quip.spam_email_subject'] = '[Quip] Kommentar-Spam gemeldet';
$_lang['quip.spam_marked'] = ' - als Spam gekennzeichnet.';
$_lang['quip.subscribed_on'] = 'Abonniert am';  // Datum?
$_lang['quip.thread'] = 'Thread';
$_lang['quip.thread_autoclosed'] = 'Dieser Thread wurde geschlossen.';
$_lang['quip.thread_err_ns'] = 'Kein Thread gewählt.';
$_lang['quip.thread_err_remove'] = 'Ein Fehler trat auf beim Versuch, den Thread zu löschen.';
$_lang['quip.thread_err_save'] = 'Ein Fehler trat auf beim Versuch, den Thread zu speichern.';
$_lang['quip.thread_manage'] = 'Thread verwalten';
$_lang['quip.thread_msg'] = 'Hier können Sie alle Kommentare für diesen Thread verwalten.';
$_lang['quip.thread_remove'] = 'Thread löschen';
$_lang['quip.thread_remove_confirm'] = 'Sind Sie sicher, dass Sie diesen Thread inklusive aller enthaltenen Kommentare komplett löschen möchten? Dies lässt sich nicht rückgängig machen.';
$_lang['quip.thread_remove_selected'] = 'Ausgewählte Threads löschen';
$_lang['quip.thread_remove_selected_confirm'] = 'Sind Sie sicher, dass Sie diese Threads komplett löschen möchten? Dies lässt sich nicht rückgängig machen.';
$_lang['quip.thread_truncate'] = 'Thread leeren';
$_lang['quip.thread_truncate_confirm'] = 'Sind Sie sicher, dass Sie alle Kommentare in diesem Thread löschen möchten?';
$_lang['quip.thread_truncate_selected'] = 'Ausgewählte Threads leeren';
$_lang['quip.thread_truncate_selected_confirm'] = 'Sind Sie sicher, dass Sie alle Kommentare in diesen Threads löschen möchten?';
$_lang['quip.threads'] = 'Threads';
$_lang['quip.unapproved'] = 'Ungenehmigt';
$_lang['quip.unapproved_comments'] = 'Ungenehmigte Kommentare';
$_lang['quip.unapproved_comments_msg'] = 'Moderieren Sie hier die ungenehmigten Kommentare.';
$_lang['quip.unsubscribe_me'] = 'Mein Abonnement für diesen Thread beenden';
$_lang['quip.unsubscribed'] = 'Ihr Abonnement für diesen Thread wurde beendet. Danke!';
$_lang['quip.username_said'] = '<strong>[[+username]]</strong> sagte:';
$_lang['quip.view'] = 'Anzeigen';
$_lang['quip.website'] = 'Website';

$_lang['area_tags'] = 'Tags';
$_lang['setting_quip.allowed_tags'] = 'Erlaubte Tags';
$_lang['setting_quip.allowed_tags_desc'] = 'Diese Tags werden Benutzern beim Schreiben von Kommentaren erlaubt. Eine Liste aller verfügbaren Werte finden Sie unter <a target="_blank" href="http://php.net/strip_tags">php.net/strip_tags</a>.';
$_lang['setting_quip.emailsFrom'] = 'Absender-E-Mail-Adresse';
$_lang['setting_quip.emailsFrom_desc'] = 'Die E-Mail-Adresse, die als Absender für System-E-Mails verwendet wird.';
$_lang['setting_quip.emailsTo'] = 'Empfänger-E-Mail-Adresse';
$_lang['setting_quip.emailsTo_desc'] = 'Die E-Mail-Adresse, an die System-E-Mails gesendet werden.';
$_lang['setting_quip.emailsReplyTo'] = 'Rückantwort-E-Mail-Adresse (Reply-To)';
$_lang['setting_quip.emailsReplyTo_desc'] = 'Die E-Mail-Adresse, die für das Reply-To-Header-Feld verwendet wird. Standardmäßig wird die Absender-Adresse verwendet.';
$_lang['setting_quip.emails_from_name'] = 'Absender-Name für E-Mails';
$_lang['setting_quip.emails_from_name_desc'] = 'Der Name, der in E-Mails für die Absender-Adresse verwendet wird.';