<?php
/**
 * Articles
 *
 * Copyright 2011-12 by Shaun McCormick <shaun+articles@modx.com>
 *
 * Articles is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * Articles is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Articles; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @package articles
 * @subpackage lexicon
 *
 * @language de
 * Articles translated to German by Jan-Christoph Ihrens (enigmatic_user, enigma@lunamail.de)
 */
$_lang['articles.advanced_settings'] = 'Erweiterte Einstellungen';
$_lang['articles.all'] = 'Alle';  // Alles?
$_lang['articles.article'] = 'Artikel';
$_lang['articles.article_alias'] = 'Alias (Permalink)';
$_lang['articles.article_content'] = 'Inhalt';
$_lang['articles.article_create'] = 'Neuer Artikel';
$_lang['articles.article_delete'] = 'Artikel löschen';
$_lang['articles.article_delete_confirm'] = 'Sind Sie sicher, dass Sie den ausgewählten Artikel löschen möchten?';
$_lang['articles.article_delete_multiple'] = 'Mehrere Artikel löschen';
$_lang['articles.article_delete_multiple_confirm'] = 'Sind Sie sicher, dass Sie die ausgewählten Artikel löschen möchten?';
$_lang['articles.article_duplicate'] = 'Artikel duplizieren';
$_lang['articles.article_edit'] = 'Artikel bearbeiten';
$_lang['articles.article_options'] = 'Artikel-Optionen';
$_lang['articles.article_edit_options'] = 'Bearbeitungs-Optionen';
$_lang['articles.article_publish'] = 'Veröffentlichen';
$_lang['articles.article_selected_delete'] = 'Ausgewählte löschen';
$_lang['articles.article_selected_undelete'] = 'Ausgewählte wiederherstellen';
$_lang['articles.article_selected_publish'] = 'Ausgewählte veröffentlichen';
$_lang['articles.article_selected_unpublish'] = 'Ausgewählte zurückziehen';
$_lang['articles.article_summary'] = 'Zusammenfassung';
$_lang['articles.article_tags'] = 'Tags';
$_lang['articles.article_title'] = 'Artikel-Titel';
$_lang['articles.article_unpublish'] = 'Zurückziehen';
$_lang['articles.articles'] = 'Artikel';
$_lang['articles.articles_err_ns_multiple'] = 'Bitte wählen Sie mindestens einen Artikel aus.';
$_lang['articles.articles_import'] = 'Artikel importieren';
$_lang['articles.articles_manage'] = 'Artikel verwalten';
$_lang['articles.articles_none'] = 'Noch keine Artikel vorhanden!';
$_lang['articles.articles_search'] = 'Artikel suchen...';  // ?
$_lang['articles.articles_view'] = 'Artikel anzeigen';
$_lang['articles.articles_write_new'] = 'Neuen Artikel schreiben';
$_lang['articles.author'] = 'Autor';
$_lang['articles.categories'] = 'Kategorien';
$_lang['articles.comments'] = 'Kommentare';
$_lang['articles.comments.intro_msg'] = 'Hier können Sie Kommentare zu Ihren Artikeln überprüfen, genehmigen und zurückweisen.';
$_lang['articles.container'] = 'Artikel';
$_lang['articles.container_alias'] = 'Container-Alias';
$_lang['articles.container_alias_desc'] = 'Der suchmaschinenfreundliche URL-Bestandteil, der genutzt wird, um die URL dieses Artikel-Containers zu generieren.';
$_lang['articles.container_create_here'] = 'Artikel hier erstellen';
$_lang['articles.container_delete'] = 'Artikel-Container löschen';
$_lang['articles.container_description'] = 'Beschreibung';
$_lang['articles.container_description_desc'] = 'Eine kurze Beschreibung Ihres Artikel-Containers.';
$_lang['articles.container_duplicate'] = 'Artikel-Container duplizieren';
$_lang['articles.container_menutitle_desc'] = 'Der Titel, der für die Darstellung in einem Navigationsmenü genutzt wird.';
$_lang['articles.container_new'] = 'Neuer Artikel-Container';
$_lang['articles.container_publish'] = 'Artikel-Container veröffentlichen';
$_lang['articles.container_settings'] = 'Container-Einstellungen';
$_lang['articles.container_title'] = 'Container-Titel';
$_lang['articles.container_title_desc'] = 'Der Titel Ihres Artikel-Containers.<br />&nbsp;';  // linebreak for aligning the fields
$_lang['articles.container_undelete'] = 'Artikel-Container wiederherstellen';
$_lang['articles.container_unpublish'] = 'Artikel-Container zurückziehen';
$_lang['articles.content'] = 'Inhalt';
$_lang['articles.filter_ellipsis'] = 'Filtern...';  // ?
$_lang['articles.import_blogger_container_err_nf'] = 'Konnte keinen Artikel-Container finden, in den inportiert werden kann!';
$_lang['articles.import_blogger_file'] = 'Blogger-Export-XML-Datei';
$_lang['articles.import_blogger_file_desc'] = 'Wählen Sie die Blogger-XML-Datei, die Sie erhalten, wenn Sie aus Blogger exportieren.';
$_lang['articles.import_blogger_file_err_nf'] = 'Bitte geben Sie die Blogger-Export-XML-Datei an.';
$_lang['articles.import_blogger_file_server'] = 'Blogger-Export-XML-Datei auf dem Server';
$_lang['articles.import_blogger_file_server_desc'] = 'Alternativ können Sie den absoluten Pfad zur Blogger-XML-Datei angeben, die Sie erhalten, wenn Sie aus Blogger exportieren, und die auf Ihrem Server liegt. Sie können {core_path}, {base_path} und {assets_path} als Platzhalter nutzen.';
$_lang['articles.import_modx_change_template'] = 'Template des Containers übernehmen';
$_lang['articles.import_modx_change_template_desc'] = 'Wenn diese Option aktiviert ist, wird als Template des neuen Artikels das Template dieses Artikel-Containers übernommen. Es wird empfohlen, diese Einstellung aktiviert zu lassen.';
$_lang['articles.import_modx_commentsThreadNameFormat'] = 'Quip-Thread-Namensformat';
$_lang['articles.import_modx_commentsThreadNameFormat_desc'] = 'Das Namensformat (wie z.B. "blog-post-[[*id]]"), das Sie in Quip bei der Eigenschaft "thread" angegeben haben. Verwenden Sie [[*id]], so wird dieser Platzhalter durch die ID der jeweiligen importierten Ressource ersetzt. Lassen Sie dieses Feld leer, wenn Sie keine Kommentare importieren möchten.';
$_lang['articles.import_modx_err_no_criteria'] = 'Bitte wählen Sie mindestens einen limitierenden Faktor in den Import-Kriterien aus.';
$_lang['articles.import_modx_intro'] = 'Es werden Inhalt, Tags und Kommentare von existierenden MODX-Ressourcen importiert. Bitte beachten Sie, dass keinerlei Inhalt außer dem eigentlichen Inhalts-Feld (content), den Kommentaren und dem Tags-Feld importiert wird.';
$_lang['articles.import_modx_hidemenu'] = 'Versteckte Ressourcen importieren';
$_lang['articles.import_modx_hidemenu_desc'] = 'Wenn diese Option aktiviert ist, werden auch Ressourcen importiert, bei denen die Einstellung "Nicht in Menüs anzeigen" aktiv ist.';
$_lang['articles.import_modx_parents'] = 'Eltern-Ressource(n)';
$_lang['articles.import_modx_parents_desc'] = 'Eine kommaseparierte Liste von Eltern-Ressourcen, deren Kind-Ressourcen alle importiert werden.';
$_lang['articles.import_modx_resources'] = 'Bestimmte Ressourcen';
$_lang['articles.import_modx_resources_desc'] = 'Eine kommaseparierte Liste von einzelnen Ressourcen, die importiert werden sollen. Stellen Sie einer ID ein Minuszeichen voran (z.B. -123), um die zugehörige Ressource vom Import auszuschließen.';
$_lang['articles.import_modx_template'] = 'Zugeordnetes Template';
$_lang['articles.import_modx_template_desc'] = 'Wird hier ein Template ausgewählt, so werden alle Ressourcen importiert, denen dieses bestimmte Template zugeordnet ist, bis auf diejenigen, die über das Feld "Bestimmte Ressourcen" ausgeschlossen werden. HINWEIS: Es werden weder Template-Inhalte noch TV-Werte importiert.';
$_lang['articles.import_modx_tagsField'] = 'Tags-Feld';
$_lang['articles.import_modx_tagsField_desc'] = 'Das Feld (oder die TV), im dem Ihr alter Blog Tags gespeichert hat. Stellen Sie "tv." voran, um eine TV zu kennzeichnen (z.B. "tv.tags").';  // ???
$_lang['articles.import_modx_unpublished'] = 'Unveröffentlichte importieren';
$_lang['articles.import_modx_unpublished_desc'] = 'Wenn diese Option aktiviert ist, werden zusätzlich alle unveröffentlichten Ressourcen importiert, die den o.a. Kriterien genügen.';
$_lang['articles.import_options'] = 'Import-Optionen';
$_lang['articles.import_service'] = 'Importieren von';
$_lang['articles.import_service_desc'] = 'Wählen Sie den Dienst oder die Applikation, von der Sie importieren möchten.';
$_lang['articles.import_wp_container_err_nf'] = 'Konnte keinen Artikel-Container finden, in den inportiert werden kann!';
$_lang['articles.import_wp_file'] = 'WordPress-Export-WXR-Datei';
$_lang['articles.import_wp_file_desc'] = 'Wählen Sie die WordPress-WXR-(XML-)Datei, die Sie erhalten, wenn Sie aus WordPress exportieren.';
$_lang['articles.import_wp_file_err_nf'] = 'Bitte geben Sie die WordPress-WXR-Datei an.';
$_lang['articles.import_wp_file_server'] = 'WordPress-Export-WXR-Datei auf dem Server';
$_lang['articles.import_wp_file_server_desc'] = 'Alternativ können Sie den absoluten Pfad zur WordPress-WXR-(XML-)Datei angeben, die Sie erhalten, wenn Sie aus WordPress exportieren, und die auf Ihrem Server liegt. Sie können {core_path}, {base_path} und {assets_path} als Platzhalter nutzen.';
$_lang['articles.publishedon'] = 'Veröffentlicht am';
$_lang['articles.published'] = 'Veröffentlicht';
$_lang['articles.publishing_information'] = 'Veröffentlichungs-Informationen';
$_lang['articles.settings'] = 'Einstellungen';
$_lang['articles.settings_archiving'] = 'Archive';
$_lang['articles.settings_comments'] = 'Kommentare';
$_lang['articles.settings_comments_display'] = 'Anzeige';
$_lang['articles.settings_comments_latest'] = 'Neueste';
$_lang['articles.settings_comments_moderation'] = 'Sicherheit';
$_lang['articles.settings_comments_other'] = 'Sonstiges';
$_lang['articles.settings_general'] = 'Allgemeines';
$_lang['articles.settings_latest_posts'] = 'Neueste Postings';
$_lang['articles.settings_notifications'] = 'Benachrichtigungen';
$_lang['articles.settings_pagination'] = 'Paginierung';
$_lang['articles.settings_rss'] = 'RSS';
$_lang['articles.settings_tagging'] = 'Tagging';
$_lang['articles.statistics'] = 'Statistiken';
$_lang['articles.status'] = 'Status';
$_lang['articles.template'] = 'Template';
$_lang['articles.template_desc'] = 'Das Template für die Übersichtsseite.';  // main listing
$_lang['articles.tags'] = 'Tags';
$_lang['articles.unpublished'] = 'Nicht veröffentlicht';
$_lang['none'] = 'Keiner';  // used for URL shortener

/* General */
$_lang['articles.setting.updateServicesEnabled'] = 'Update-Dienste aktivieren';
$_lang['articles.setting.updateServicesEnabled_desc'] = 'Wenn diese Option aktiviert ist, versucht Articles, Ping-o-Matic anzupingen, wann immer Sie einen Artikel veröffentlichen, um den Titel und die URL Ihres Artikels an die großen Suchmaschinen zu übermitteln.';
$_lang['articles.setting.richtext_desc'] = 'Sobald erstellt, hat die entsprechende Einstellung individueller Artikel Vorrang vor diesem Wert.';
$_lang['articles.setting.sortBy'] = 'Sortierfeld';
$_lang['articles.setting.sortBy_desc'] = 'Das Feld, nach dem auf den Haupt- und Archiv-Übersichtsseiten sortiert wird.';
$_lang['articles.setting.sortDir'] = 'Sortierrichtung';
$_lang['articles.setting.sortDir_desc'] = 'Die Richtung, in die auf den Haupt- und Archiv-Übersichtsseiten sortiert wird (DESC oder ASC).';
$_lang['articles.setting.archivesIncludeTVs'] = 'Template-Variablen in Übersicht anzeigen';
$_lang['articles.setting.archivesIncludeTVs_desc'] = 'Wenn diese Option aktiviert ist, können Template-Variablen in den Chunks für die Übersichten verwendet werden.';  // as options??? "als Optionen" oder "optional"?  // include = einbeziehen (?)
$_lang['articles.setting.includeTVsList'] = 'Liste einzubeziehender Template-Variablen';
$_lang['articles.setting.includeTVsList_desc'] = 'Eine optionale, kommaseparierte Liste von Namen von Template-Variablen, die explizit einbezogen werden, wenn "Template-Variablen in Übersicht anzeigen" aktiviert ist. Werden hier Template-Variablen eingetragen, so werden ausschließlich diese einbezogen, sonst alle.';
$_lang['articles.setting.archivesProcessTVs'] = 'Template-Variablen in Übersicht verarbeiten';
$_lang['articles.setting.archivesProcessTVs_desc'] = 'Wenn diese Option aktiviert ist, werden Template-Variablen in den Übersichts-Chunks verarbeitet.';
$_lang['articles.setting.processTVsList'] = 'Liste zu verarbeitender Template-Variablen';
$_lang['articles.setting.processTVsList_desc'] = 'Eine optionale, kommaseparierte Liste von Namen von Template-Variablen, die explizit verarbeitet werden. Template-Variablen, die hier angegeben werden, müssen mittels der Einstellungen "Template-Variablen in Übersicht anzeigen" und "Liste einzubeziehender Template-Variablen" einbezogen werden. Werden hier Template-Variablen eingetragen, so werden ausschließlich diese verarbeitet, sonst alle.';
$_lang['articles.setting.otherGetArchives'] = 'Andere Übersichts-Parameter';
$_lang['articles.setting.otherGetArchives_desc'] = 'Alle anderen Eigenschaften, die Sie dem getResources-/getPage-Aufruf für die Articles-Übersichtsseite hinzufügen möchten. Verwenden Sie die MODX-Tag-Syntax, als ob Sie die Parameter zum Tag-Aufruf hinzufügen würden (z.B. &eigenschaft=`wert`).';
$_lang['articles.setting.articleUriTemplate'] = 'Articles-URL-Format';
$_lang['articles.setting.articleUriTemplate_desc'] = '%Y = Jahr (4-stellig), %m = Monat (mit führenden Nullen), %d = Tag (mit führenden Nullen), %alias = Artikel-Alias, %id = Artikel-ID, %ext = Dateiendung (z.B. html). <b>Hinweis</b>: Änderungen an dieser Einstellung wirken sich nur auf *neue* Artikel aus, es sei denn, Sie ändern den Alias oder ziehen alte Artikel zurück und veröffentlichen sie erneut, wodurch ihre URLs im neuen Format neu generiert werden.';

/* Template / archives settings */
$_lang['articles.setting.articleTemplate'] = 'Artikel-Template';
$_lang['articles.setting.articleTemplate_desc'] = 'Das Template, das standardmäßig für Artikel verwendet wird.';
$_lang['articles.setting.tplArticleRow'] = 'Artikel-Zeilen-Chunk';
$_lang['articles.setting.tplArticleRow_desc'] = 'Der Chunk, der verwendet wird, wenn Artikel auf der Übersichtsseite oder auf Archivseiten angezeigt werden.';  // front page = main listing = Übersichtsseite?
$_lang['articles.setting.archiveByMonth'] = 'Nach Monaten archivieren';
$_lang['articles.setting.archiveByMonth_desc'] = 'Gibt an, ob nach Monaten oder nach Jahren archiviert werden soll. Wenn Sie "Ja" auswählen, wird nach Monaten archiviert.';  // Whether or not to archive by month or by year
$_lang['articles.setting.tplArchiveMonth'] = 'Archiv-Übersichts-Chunk';
$_lang['articles.setting.tplArchiveMonth_desc'] = 'Der Chunk, der für jede Monats-/Jahres-Zeile verwendet wird, die aufgelistet wird.';
$_lang['articles.setting.archiveListingsLimit'] = 'Anzuzeigende Archiv-Übersichten';
$_lang['articles.setting.archiveListingsLimit_desc'] = 'Die Anzahl von Monaten/Jahren, die im Archiv angezeigt werden sollen.';
$_lang['articles.setting.archiveCls'] = 'Archiv-CSS-Klasse';
$_lang['articles.setting.archiveCls_desc'] = 'Eine CSS-Klasse, die jeder Archiv-Übersicht zugeordnet wird.';
$_lang['articles.setting.archiveAltCls'] = 'Alternative Archiv-CSS-Klasse';
$_lang['articles.setting.archiveAltCls_desc'] = 'Eine CSS-Klasse, die jeder zweiten Zeile einer Archiv-Übersicht zugeordnet wird.';
$_lang['articles.setting.archiveGroupByYear'] = 'Nach Jahren gruppieren';
$_lang['articles.setting.archiveGroupByYear_desc'] = 'Wenn diese Option aktiviert ist, werden Archivergebnisse nach Jahren in eine verschachtelte Liste gruppiert; außerdem wird dann die Einstellung "Nach Monaten archivieren" ignoriert.';
$_lang['articles.setting.archiveGroupByYearTpl'] = 'Chunk für die Gruppierung nach Jahren';
$_lang['articles.setting.archiveGroupByYearTpl_desc'] = 'Wenn die Option "Nach Jahren gruppieren" aktiviert ist, wird dieser Chunk als "Hülle" (umgebender Code) für die Archivlisten-Gruppierung verwendet.';  // wrapper: I've used "Hülle" because "Container" would be liable to be misunderstood in this context

/* Pagination */
$_lang['articles.setting.articlesPerPage'] = 'Artikel pro Seite';
$_lang['articles.setting.articlesPerPage_desc'] = 'Die Anzahl an Artikeln, die pro Seite angezeigt werden, wenn Postings aufgelistet werden.';
$_lang['articles.setting.pageLimit'] = 'Seiten-Limit';
$_lang['articles.setting.pageLimit_desc'] = 'Die maximale Anzahl an Seiten, die aufgelistet werden, wenn Seitennummern-Links angezeigt werden.';
$_lang['articles.setting.pageNavTpl'] = 'Template für Paginierungs-Link zu einer einzelnen Seite';
$_lang['articles.setting.pageNavTpl_desc'] = 'Der Inhalt dieses Eingabefeldes repräsentiert das Navigationselement für eine einzelne Seite.';
$_lang['articles.setting.pageActiveTpl'] = 'Template für Paginierungs-Link zur aktuellen Seite';
$_lang['articles.setting.pageActiveTpl_desc'] = 'Der Inhalt dieses Eingabefeldes repräsentiert das Navigationselement für die aktuelle Seite.';
$_lang['articles.setting.pageFirstTpl'] = 'Template für Paginierungs-Link zur ersten Seite';
$_lang['articles.setting.pageFirstTpl_desc'] = 'Der Inhalt dieses Eingabefeldes repräsentiert das Navigationselement für die erste Seite.';
$_lang['articles.setting.pageLastTpl'] = 'Template für Paginierungs-Link zur letzten Seite';
$_lang['articles.setting.pageLastTpl_desc'] = 'Der Inhalt dieses Eingabefeldes repräsentiert das Navigationselement für die letzte Seite.';
$_lang['articles.setting.pagePrevTpl'] = 'Template für Paginierungs-Link zur vorhergehenden Seite';
$_lang['articles.setting.pagePrevTpl_desc'] = 'Der Inhalt dieses Eingabefeldes repräsentiert das Navigationselement für die vorhergehende Seite.';
$_lang['articles.setting.pageNextTpl'] = 'Template für Paginierungs-Link zur nachfolgenden Seite';
$_lang['articles.setting.pageNextTpl_desc'] = 'Der Inhalt dieses Eingabefeldes repräsentiert das Navigationselement für die nachfolgende Seite.';
$_lang['articles.setting.pageOffset'] = 'Seiten-Offset';
$_lang['articles.setting.pageOffset_desc'] = 'Der Offset (bzw. die Datensatz-Position), bei dem innerhalb der Sammlung begonnen wird, Ergebnisse für die aktuelle Seite auszugeben; sollte berechnet werden basierend auf der Variablen, die in der Einstellung "Variablen-Schlüssel der aktuellen Seite" festgelegt wird.';
$_lang['articles.setting.pageVarKey'] = 'Variablen-Schlüssel der aktuellen Seite';
$_lang['articles.setting.pageVarKey_desc'] = 'Der Schlüssel (Name) einer Eigenschaft, die die aktuelle Seite kennzeichnet.';
$_lang['articles.setting.pageTotalVar'] = 'Variable für die Gesamtanzahl';
$_lang['articles.setting.pageTotalVar_desc'] = 'Der Schlüssel (Name) eines Platzhalters, der die Gesamtanzahl der Datensätze in der beschränkbaren Sammlung enthalten muss, für die Seitenzahlen-Links angezeigt werden.';  // ???
$_lang['articles.setting.pageNavVar'] = 'Variable für die Seitennummern-Navigationselemente';
$_lang['articles.setting.pageNavVar_desc'] = 'Der Schlüssel (Name) eines Platzhalters, der die Paginierungs-Navigationselemente enthalten soll.';


/* RSS settings */
$_lang['articles.setting.rssAlias'] = 'RSS-Alias (Permalink)';
$_lang['articles.setting.rssAlias_desc'] = 'Der Alias (Permalink) für den RSS-Feed, der an die Articles-Container-URL angehängt wird.';
$_lang['articles.setting.rssItems'] = 'Anzahl der RSS-Elemente';
$_lang['articles.setting.rssItems_desc'] = 'Die Anzahl der RSS-Elemente, die im RSS-Feed angezeigt werden sollen. Geben Sie 0 ein für unbegrenzt viele Elemente.';
$_lang['articles.setting.tplRssFeed'] = 'RSS-Feed-Chunk';
$_lang['articles.setting.tplRssFeed_desc'] = 'Der Chunk, der für das RSS-Feed-Template verwendet wird.';
$_lang['articles.setting.tplRssItem'] = 'RSS-Element-Chunk';
$_lang['articles.setting.tplRssItem_desc'] = 'Der Chunk, der für die einzelnen Elemente des RSS-Feeds verwendet wird.';

/* Tagging */
$_lang['articles.setting.tagsLimit'] = 'In der Liste anzuzeigende Tags';
$_lang['articles.setting.tagsLimit_desc'] = 'Die Anzahl der in der Liste der beliebtesten Tags anzuzeigenden Tags.';
$_lang['articles.setting.tplTagRow'] = 'Tag-Listen-Chunk';
$_lang['articles.setting.tplTagRow_desc'] = 'Der Chunk, der genutzt wird, wenn Tags auf den Übersichtsseiten angezeigt werden.';
$_lang['articles.setting.tagCls'] = 'Tag-CSS-Klasse';
$_lang['articles.setting.tagCls_desc'] = 'Eine CSS-Klasse, die jeder Tag-Auflistung zugeordnet wird.';
$_lang['articles.setting.tagAltCls'] = 'Alternative Tag-CSS-Klasse';
$_lang['articles.setting.tagAltCls_desc'] = 'Eine CSS-Klasse, die jeder zweiten Zeile jeder Tag-Auflistung zugeordnet wird.';

/* Latest Posts */
$_lang['articles.setting.latestPostsTpl'] = 'Neueste-Artikel-Chunk';
$_lang['articles.setting.latestPostsTpl_desc'] = 'Der Chunk, der für die jeweils neuesten Artikel genutzt wird.';
$_lang['articles.setting.latestPostsLimit'] = 'Anzuzeigende neueste Artikel';
$_lang['articles.setting.latestPostsLimit_desc'] = 'Die Anzahl der anzuzeigenden neuesten Artikel.';
$_lang['articles.setting.latestPostsOffset'] = 'Start-Index für neueste Artikel';
$_lang['articles.setting.latestPostsOffset_desc'] = 'Der Start-Index der Liste der neuesten Artikel.';
$_lang['articles.setting.otherLatestPosts'] = 'Andere Listen-Parameter';
$_lang['articles.setting.otherLatestPosts_desc'] = 'Alle anderen Eigenschaften, die Sie dem getResources-/getPage-Aufruf für das "Neueste Artikel"-Widget hinzufügen möchten. Verwenden Sie dafür MODX-Tag-Syntax, als ob Sie sie zu dem Snippet-Aufruf hinzufügen würden (z.B. &eigenschaft=`wert`).';

/* Notifications */
$_lang['articles.setting.notifyTwitter'] = 'An Twitter senden';
$_lang['articles.setting.notifyTwitter_desc'] = 'Automatisch Link in Twitter posten, wenn der Artikel veröffentlicht wird.';
$_lang['articles.setting.notifyTwitter_notyet_desc'] = 'Automatisch Link in Twitter posten, wenn der Artikel veröffentlicht wird. <strong>Hinweis: Sie müssen zuerst <a href="[[+authUrl]]" target="_blank">die Authentifizierungsseite</a> besuchen, um Articles für Ihren Twitter-Account zu authentifizieren!</strong>';
$_lang['articles.setting.notifyTwitterConsumerKey'] = 'Twitter Consumer Key';
$_lang['articles.setting.notifyTwitterConsumerKey_desc'] = 'Optional. Der Consumer Key für Ihren Twitter-Account, mit dem sich MODX-Articles beim Zugriff auf Ihren Twitter-Account authentifiziert. Wenn dieses Feld leer gelassen wird, wird der Standardwert von MODX-Articles verwendet. Geben Sie einen eigenen Consumer Key ein, um die Sicherheit zu erhöhen';
$_lang['articles.setting.notifyTwitterConsumerKeySecret'] = ' Twitter Consumer Secret';
$_lang['articles.setting.notifyTwitterConsumerKeySecret_desc'] = 'Optional. Falls Sie einen eigenen Consumer Key verwenden, müssen Sie hier das entsprechende Consumer Secret eingeben. Wenn dieses Feld leer gelassen wird, wird der Standardwert von MODX-Articles verwendet. Die Eingabe Ihres eigenen Twitter App Consumer Secret erhöht die Sicherheit.';
$_lang['articles.setting.notifyTwitterTpl'] = 'Twitter-Template';
$_lang['articles.setting.notifyTwitterTpl_desc'] = 'Das Template, das verwendet wird, um die Ausgabe von Postings für Twitter zu formatieren.';
$_lang['articles.setting.notifyTwitterTagLimit'] = 'Twitter-Tag-Limit';
$_lang['articles.setting.notifyTwitterTagLimit_desc'] = 'Die Anzahl an Tags, die verwendet werden, wenn [[+hashtags]] im Template verwendet wird; dieser Platzhalter fügt dem Tweet Tags als Hashtags hinzu.';
$_lang['articles.setting.shorteningService'] = 'Kurz-URL-Dienst';  // See http://de.wikipedia.org/wiki/Kurz-URL-Dienst
$_lang['articles.setting.shorteningService_desc'] = 'Der Dienst, der zum Kürzen von URLs eingesetzt wird. Setzen Sie diese Einstellung auf "Keiner", um URLs nicht zu kürzen.';

/* Latest Comments */
$_lang['articles.setting.latestCommentsTpl'] = 'Neueste-Kommentare-Chunk';
$_lang['articles.setting.latestCommentsTpl_desc'] = 'Der Chunk, der für die jeweils neuesten Kommentare genutzt wird.';
$_lang['articles.setting.latestCommentsLimit'] = 'Anzuzeigende neueste Kommentare';
$_lang['articles.setting.latestCommentsLimit_desc'] = 'Die Anzahl der anzuzeigenden neuesten Kommentare. Standard ist 10.';
$_lang['articles.setting.latestCommentsBodyLimit'] = 'Zeichen-Limit der neuesten Kommentare';
$_lang['articles.setting.latestCommentsBodyLimit_desc'] = 'Die Anzahl an Zeichen, die vom neuesten Kommentar angezeigt werden, bevor der Rest abgeschnitten und durch Auslassungspunkte (...) ersetzt wird.';
$_lang['articles.setting.latestCommentsRowCss'] = 'CSS-Klasse für neueste Kommentare';
$_lang['articles.setting.latestCommentsRowCss_desc'] = 'Die CSS-Klasse, die jedem der neuesten Kommentare zugeordnet wird.';
$_lang['articles.setting.latestCommentsAltRowCss'] = 'Alternative CSS-Klasse für neueste Kommentare';
$_lang['articles.setting.latestCommentsAltRowCss_desc'] = 'Die CSS-Klasse, die jedem zweiten der neuesten Kommentare zugeordnet wird.';

/* Comments */
$_lang['articles.setting.commentsEnabled'] = 'Kommentare zulassen';
$_lang['articles.setting.commentsEnabled_desc'] = 'Gibt an, ob die Kommentarfunktion aktiviert ist oder nicht.';
$_lang['articles.setting.commentsThreaded'] = 'Unter-Threads in Kommentaren möglich';
$_lang['articles.setting.commentsThreaded_desc'] = 'Gibt an, ob dieser Thread in den Kommentaren Unter-Threads haben kann oder nicht. Unter-Threads in den Kommentaren erlauben den Benutzern, Kommentare zu kommentieren, wobei der Einrückungs-Level erhöht wird (entsprechende Formatierung vorausgesetzt). Kommentare ohne Unter-Threads erlauben den Butzern, nur den eigentlichen Artikel zu kommentieren, nicht andere Kommentare.';
$_lang['articles.setting.commentsReplyResourceId'] = 'Ressourcen-ID für Antworten auf Kommentare';
$_lang['articles.setting.commentsReplyResourceId_desc'] = 'Die ID der Ressource, die das QuipReply-Snippet enthält, mittels dessen auf Kommentare in einem Unter-Thread geantwortet werden kann. <strong>Die Angabe dieser ID ist erforderlich für Kommentare mit Unter-Threads.</strong>';
$_lang['articles.setting.commentsMaxDepth'] = 'Maximale Thread-Tiefe';
$_lang['articles.setting.commentsMaxDepth_desc'] = 'Die maximale Tiefe, bis zu der Antworten in einem Thread mit Unter-Threads verschachtelt sein dürfen.';
$_lang['articles.setting.commentsTplComment'] = 'Kommentar-Chunk';
$_lang['articles.setting.commentsTplComment_desc'] = 'Der Chunk, der für alle Kommentare genutzt wird.';
$_lang['articles.setting.commentsTplCommentOptions'] = 'Kommentar-Optionen-Chunk';
$_lang['articles.setting.commentsTplCommentOptions_desc'] = 'Ein Chunk für die Optionen, wie z.B. löschen, die dem Autor eines Kommentars angezeigt werden.';
$_lang['articles.setting.commentsTplComments'] = 'Chunk für die Kommentar-"Hülle"';
$_lang['articles.setting.commentsTplComments_desc'] = 'Die äußere "Hülle" (der umgebende Code) für Kommentare. Kann entweder der Name eines Chunks sein oder direkt der zu verwendende Code. Wenn Code eingegeben wird, wird kein Chunk verwendet.';  // wrapper: I've used "Hülle" because "Container" would be liable to be misunderstood in this context
$_lang['articles.setting.commentsTplAddComment'] = 'Antwortformular-Chunk';
$_lang['articles.setting.commentsTplAddComment_desc'] = 'Der Chunk für das Antwortformular.';
$_lang['articles.setting.commentsTplLoginToComment'] = 'Chunk für Hinweis "Zum Kommentieren einloggen"';
$_lang['articles.setting.commentsTplLoginToComment_desc'] = 'Der Chunk, der angezeigt wird, wenn der Benutzer nicht eingeloggt ist und eine Authentifizierung erforderlich ist.';  // verlangt wird?
$_lang['articles.setting.commentsTplPreview'] = 'Vorschau-Chunk';
$_lang['articles.setting.commentsTplPreview_desc'] = 'Der Chunk für die Kommentar-Vorschau.';  // view
$_lang['articles.setting.commentsUseCss'] = 'Quip-CSS verwenden';
$_lang['articles.setting.commentsUseCss_desc'] = 'Wenn diese Option aktiviert ist, stellt Quip ein einfaches CSS-Template für die Darstellung zur Verfügung.';
$_lang['articles.setting.commentsAltRowCss'] = 'CSS-Klasse für jede zweite Zeile';
$_lang['articles.setting.commentsAltRowCss_desc'] = 'Die CSS-Klasse, die jedem zweiten Kommentar zugeordnet wird (z.B. für alternierende Hintergrundfarben).';  // alternating comments
$_lang['articles.setting.commentsSortDir'] = 'Sortierrichtung für Kommentare';
$_lang['articles.setting.commentsSortDir_desc'] = 'Die Richtung, in der Kommentare sortiert werden (DESC für absteigende oder ASC für aufsteigende Sortierrichtung).';
$_lang['articles.setting.commentsNameField'] = 'Namensfeld';
$_lang['articles.setting.commentsNameField_desc'] = 'Das Feld, das für die Anzeige der Autoren-Namen der Kommentare verwendet wird. Empfohlene Werte sind "name" oder "username".';
$_lang['articles.setting.commentsShowAnonymousName'] = 'Anonymus-Namen anzeigen';
$_lang['articles.setting.commentsShowAnonymousName_desc'] = 'Wenn diese Option aktiviert ist, wird der Wert der Eigenschaft anonymousName (Anonymus-Name, standardmäßig "Anonymous") angezeigt, wenn der Benutzer beim Erstellen seines Kommentars nicht eingeloggt war.';
$_lang['articles.setting.commentsAnonymousName'] = 'Anonymus-Name';
$_lang['articles.setting.commentsAnonymousName_desc'] = 'Der Name, der bei anonymen Postings angezeigt wird. Standard ist "Anonymous".';
$_lang['articles.setting.commentsLimit'] = 'Anzahl der Kommentare pro Seite';
$_lang['articles.setting.commentsLimit_desc'] = 'Die maximale Anzahl an Kommentaren pro Seite. Wenn Sie diese Einstellung auf einen Integer-Zahlenwert setzen, der größer als null ist, wird die Paginierung aktiviert.';
$_lang['articles.setting.commentsCloseAfter'] = 'Kommentare schließen nach';
$_lang['articles.setting.commentsCloseAfter_desc'] = 'Die Anzahl der Tage ab Erstellung des Threads, nach denen dieser automatisch geschlossen wird. Setzen Sie diese Einstellung auf 0, um die Kommentarfunktion dauerhaft aktiviert zu lassen.';
$_lang['articles.setting.commentsRequirePreview'] = 'Posting-Vorschau erforderlich';
$_lang['articles.setting.commentsRequirePreview_desc'] = 'Wenn diese Einstellung aktiviert ist, müssen Benutzer die Vorschau ihres Kommentars anzeigen lassen, bevor sie ihn absenden können.';
$_lang['articles.setting.commentsRequireAuth'] = 'Authentifizierung zum Kommentieren erforderlich';
$_lang['articles.setting.commentsRequireAuth_desc'] = 'Wenn diese Einstellung aktiviert ist, können nur eingeloggte Benutzer den Thread kommentieren.';
$_lang['articles.setting.commentsReCaptcha'] = 'ReCAPTCHA';
$_lang['articles.setting.commentsReCaptcha_desc'] = 'reCAPTCHA im Formular zum Hinzufügen von Kommentaren aktivieren.';
$_lang['articles.setting.commentsDisableReCaptchaWhenLoggedIn'] = 'reCAPTCHA deaktivieren, wenn eingeloggt';
$_lang['articles.setting.commentsDisableReCaptchaWhenLoggedIn_desc'] = 'reCAPTCHA-Validierung für eingeloggte Benutzer deaktivieren.';
$_lang['articles.setting.commentsModerate'] = 'Kommentare moderieren';
$_lang['articles.setting.commentsModerate_desc'] = 'Alle neuen Postings des Threads werden moderiert.';
$_lang['articles.setting.commentsModerateAnonymousOnly'] = 'Nur anonyme Postings moderieren';
$_lang['articles.setting.commentsModerateAnonymousOnly_desc'] = 'Nur Postings von Benutzern moderieren, die nicht eingeloggt sind.';
$_lang['articles.setting.commentsModerateFirstPostOnly'] = 'Nur erstes Posting moderieren';
$_lang['articles.setting.commentsModerateFirstPostOnly_desc'] = 'Nur das jeweils erste Posting von eingeloggten Benutzern moderieren. Alle weiteren Postings werden automatisch genehmigt. Anonyme Postings werden immer moderiert.';
$_lang['articles.setting.commentsModerators'] = 'Moderatoren';
$_lang['articles.setting.commentsModerators_desc'] = 'Eine kommaseparierte Liste von Moderator-Benutzernamen.';
$_lang['articles.setting.commentsModeratorGroup'] = 'Moderatorengruppe';
$_lang['articles.setting.commentsModeratorGroup_desc'] = 'Alle Benutzer in dieser Benutzergruppe haben Moderatoren-Zugriffsrechte.';
$_lang['articles.setting.commentsAllowRemove'] = 'Löschen erlauben';
$_lang['articles.setting.commentsAllowRemove_desc'] = 'Eingeloggten Benutzern erlauben, Ihre eigenen Postings zu löschen.';
$_lang['articles.setting.commentsRemoveThreshold'] = 'Lösch-Zeitfenster (in Minuten)';
$_lang['articles.setting.commentsRemoveThreshold_desc'] = 'Wenn "Löschen erlauben" aktiviert ist, kann hier angegeben werden, wie viele Minuten lang ein Benutzer sein Posting löschen kann, nachdem er es abgesendet hat.';
$_lang['articles.setting.commentsAllowReportAsSpam'] = 'Spam-Meldungen erlauben';
$_lang['articles.setting.commentsAllowReportAsSpam_desc'] = 'Eingeloggten Benutzern erlauben, Kommentare als Spam zu melden.';
$_lang['articles.setting.commentsDateFormat'] = 'Posting-Datumsformat';
$_lang['articles.setting.commentsDateFormat_desc'] = 'Das Datumsformat, das für die Anzeige des Erstellungsdatums eines Kommentars verwendet wird. Die Syntax entspricht der, die in der PHP-Funktion strftime() verwendet wird.';
$_lang['articles.setting.commentsAutoConvertLinks'] = 'Hyperlinks automatisch umwandeln';
$_lang['articles.setting.commentsAutoConvertLinks_desc'] = 'URLs automatisch in Links umwandeln.';
$_lang['articles.setting.commentsGravatar'] = 'Gravatar verwenden';
$_lang['articles.setting.commentsGravatar_desc'] = 'Gibt an, ob Gravatar-Icons in Kommentaren angezeigt werden.';
$_lang['articles.setting.commentsGravatarIcon'] = 'Gravatar-Icon-Stil';
$_lang['articles.setting.commentsGravatarIcon_desc'] = 'Der Gravatar-Icon-Typ, der für Benutzer ohne Gravatar genutzt wird.';
$_lang['articles.setting.commentsGravatarSize'] = 'Gravatar-Icon-Größe';
$_lang['articles.setting.commentsGravatarSize_desc'] = 'Die Größe des Gravatars in Pixeln. Der Standardwert ist 50.';
$_lang['articles.setting.'] = '';
$_lang['articles.setting._desc'] = '';
$_lang['articles.loading'] = 'Lade';

/* Settings */
$_lang['setting_articles.article_show_longtitle'] = 'Feld für langen Titel anzeigen';
$_lang['setting_articles.article_show_longtitle_desc'] = 'Setzen Sie diese Einstellung auf "Ja", wenn das Feld "Langer Titel" beim Bearbeiten eines Artikels eingeblendet werden soll.';

$_lang['setting_articles.default_container_template'] = 'Standard-Artikel-Container-Template';
$_lang['setting_articles.default_container_template_desc'] = 'Das Template (ID), das standardmäßig verwendet wird, wenn ein neuer Artikel-Container erstellt wird.';

$_lang['setting_articles.default_article_template'] = 'Standard-Artikel-Template';
$_lang['setting_articles.default_article_template_desc'] = 'Das Template (ID), das standardmäßig verwendet wird, wenn ein neuer Artikel erstellt wird und im Container selbst kein Template angegeben ist.';

$_lang['setting_articles.container_ids'] = 'Container-IDs für das Routing von suchmaschinenfreundlichen URLs';
$_lang['setting_articles.container_ids_desc'] = 'Eine kommaseparierte Liste von Container-IDs, die für das Routing von suchmaschinenfreundlichen URLs verwendet werden. Es wird empfohlen, hier keine Änderungen vorzunehmen.';  // FURL routing

$_lang['setting_articles.default_article_sort_field'] = 'Standard-Sortierfeld für Artikel im Manager';
$_lang['setting_articles.default_article_sort_field_desc'] = 'Das Standard-Sortierfeld für die Artikel-Liste beim Bearbeiten eines Containers.';

$_lang['setting_articles.mgr_date_format'] = 'Manager-Datumsformat';
$_lang['setting_articles.mgr_date_format_desc'] = 'Datumsformat, das innerhalb eines Artikel-Containers angezeigt wird, wenn Artikel im Manager aufgelistet werden.';

$_lang['setting_articles.mgr_time_format'] = 'Manager-Zeitformat';
$_lang['setting_articles.mgr_time_format_desc'] = 'Zeitformat, das innerhalb eines Artikel-Containers angezeigt wird, wenn Artikel im Manager aufgelistet werden.';
