<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'license' => 'This work is licenced under the Creative Commons Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)
http://creativecommons.org/licenses/by-sa/3.0/',
    'readme' => '# JSONDerulo - A JSON feed fetcher for MODX Revolution CMS

Snippets and chunks to pull in various social JSON feeds. [Available on the MODX Extras repo](http://modx.com/extras/package/jsonderulo23).

Results are cached for 12 hours by default, but you can specify your own time limit in seconds using &cacheTime. Make sure you call the snippet uncached from your templates!
Most snippets allow you to specify multiple usernames, however any feeds which require an API key will not yet work with multiple accounts.
The following feeds are already set up:

* App.net - most recent posts
* Delicious - most recent bookmarks
* Flickr - most recent photographs in your photostream
* Google+ - most recent public posts
* Google calendar - upcoming public events
* LastFM - recent "loved" tracks or recent "listens"
* Picasa - Photos from a named album
* Tumblr - most recent posts (several post type options)
* Twitter - most recent tweets
* Vimeo - most recent "likes"
* YouTube - Most recent additions to "favourites" playlist or specific user\'s uploads
* YouTube - (For API v.3 - fetch a public playlist)
* ZooTool - Most recent items (pages or images)

## Thanks!

Plenty of thouroughly helpful help from [Mister John Noel](https://github.com/johnnoel) and his code on which these snippets are based.

Also, hat tip to [basvaneijk](https://github.com/basvaneijk) for the preg_replace stuff to auto link @, # and URLs within the [[+message]]

## Requirements/Prerequisites

* Tested on MODx 2.2.x
* PHPThumbOf / pThumb
* API Keys/app secrets, etc for certain feeds
* That\'s it!

#Specific details

[JSONDerulo v1](https://github.com/pdincubus/JSONDerulo/blob/master/README-v1.md) | [JSONDerulo v2](https://github.com/pdincubus/JSONDerulo/blob/master/README-v2.md)

#General details (applicable to v1 and v2)

## Chunks

I\'ve provided basic chunks to get you started. Any feed which returns thumbnails/imagery I\'ve used PHPThumbOf, if you use these chunks make sure you have it installed too!

You can also use the MODx\'s output filters to provide fallback should the feed you request be empty. E.g. - such as a new twitter account with no tweets yet:

```
[[!TwitterFeed:default=`<li>No tweets</li>`? &tpl=`TwitterFeedItem` &limit=`10` &users=`USERNAME`]]
```

The basic Twitter chunk also shows you how to use the isRetweet option to switch out your details for the author of the tweet you retweeted. The example isn\'t the best, but it\'ll give you the right idea, and will also allow you to integrate a retweet icon if you wish.

### Chunk placeholders

Currently only the basics have placeholders provided. The YouTube feed, for example, has more options that you may ever need. If I find I ever use them, I will add them in.


#### App.net:

The App.net feed is very pleasant and gives you the option of either "text" or "html" versions of a post. I\'ve included placeholders for both. The basic chunk I\'ve provided only uses [[+text]].

```
[[+id]]
[[+text]]
[[+html]]
[[+created]]
[[+picture]]
[[+title]]
[[+username]]
[[+profile]]
[[+postUrl]]
```

#### Delicious:

```
[[+title]]
[[+description]]
[[+link]]
[[+date]]
[[+username]]
```

#### Flickr:

```
[[+id]]
[[+created]]
[[+picture]]
[[+picturelarge]]
[[+title]]
[[+username]]
```

### Google+:

```
[[+text]]
[[+html]]
[[+postId]]
[[+attachmentUrl]]
[[+repliesCount]]
[[+plusCount]]
[[+resharesCount]]
[[+postUrl]]
[[+postDate]]
[[+profileUrl]]
[[+avatar]]
[[+displayName]]

```

### Google Calendar:

```
[[+timezone]]
[[+published]]
[[+title]]
[[+content]]
[[+link]]
[[+calendarName]]
[[+eventStart]]
[[+eventEnd]]
[[+location]]
```

#### LastFM:

```
[[+track]]
[[+artist]]
[[+link]]
[[+picture]]
[[+date]]
[[+username]]
```

### Picasa:

```
[[+link]]
[[+albumid]]
[[+created]]
[[+picture]]
[[+title]]
[[+userid]]
[[+albumname]]
```

### Tumblr:

Default placeholders:

```
[[+blogUrl]]
[[+blogName]]
[[+blogDescription]]
[[+post]]
[[+postType]]
[[+postUrl]]
[[+created]]
[[+createdDate]]
[[+id]]
[[+shortUrl]]
```

For video posts:

```
[[+caption]]
[[+videoPermalink]]
[[+thumbnail]]
[[+player250]]
[[+player400]]
[[+player500]]
```

For link posts:

```
[[+title]]
[[+linkUrl]]
[[+linkDescription]]
```

For text posts:

```
[[+title]]
[[+content]]
```

For audio posts:

```
[[+audioSourceUrl]]
[[+audioSourceTitle]]
[[+artist]]
[[+album]]
[[+trackName]]
[[+player]]
[[+audioUrl]]
```

For image posts:

```
[[+caption]]
[[+imagePermalink]]
[[+image]]
```

#### Twitter:

```
[[+id]]
[[+message]]
[[+created]]
[[+picture]]
[[+title]]
[[+username]]
[[+retweetCount]]
[[+isRetweet]]
[[+originalAuthorPicture]]
[[+originalAuthor]]
[[+originalUsername]]
[[+originalId]]
```
#### Vimeo:

```
[[+id]]
[[+url]]
[[+created]]
[[+picture]]
[[+title]]
[[+username]]
```

#### YouTube:

```
[[+published]]
[[+picture]]
[[+title]]
[[+ytlink]]
[[+embedlink]]
[[+author]]
```

#### ZooTool:

```
[[+date]]
[[+picture]]
[[+title]]
[[+username]]
[[+referrer]]
[[+permalink]]
```

### CSS

I\'ve used the clearfix from the [HTML5 Boilerplate normalize.css](http://www.html5boilerplate.com) on ```<li>``` items to clear floats inside them:

```css
.cf:before, .cf:after { content: ""; display: table; }
.cf:after { clear: both; }
.cf { *zoom: 1; }
```


### PHPThumbOf settings

Ensure you have the following in the "phpthumb_nohotlink_valid_domains" section:

* Flickr: ```*.flickr.com, *.staticflickr.com```
* ZooTool: ```s3.amazonaws.com```
* YouTube Thumbnails: ```.ytimg.com```
* LastFM Album art: ```userserve-ak.last.fm```
* Vimeo Thumbnails: ```*.vimeocdn.com```
* Twitter profile avatars: ```*.twimg.com```
* Picasa/Google+ Thumbnails: ```*.googleusercontent.com```
* App.net avatars: ```*.cloudfront.net```


## Twitter feed and the new API

Much publicised changes to the Twitter API means that you have to authenticate to get public feed data now. I will keep the original, easy way to get a Twitter feed until the date they switch this off, but you\'re probably best going through the pain of getting onto the new API stuff now.

This uses the excellent (and thoroughly easy to use) [TwitterOAuth](https://github.com/abraham/twitteroauth/) by [Abraham Williams](https://github.com/abraham) (check out his incredible beard!). If you\'re adding the JSONDerulo snippets and chunks manually, you\'re going to need to upload a copy of the TwitterOAuth stuff to {core_path}/components/jsonderulo/

The transport package will do this automatically for you. (Hopefully).

To set up a Twitter "App", go to the [Twitter dev site](https://dev.twitter.com/apps/) and choose "Create a new application". Fill in the form and you\'ll end up with a new "app" which will let you know the consumer secret, consumer key, access token, and access token secret.

Hat tip also to [Stewart Orr](http://www.qodo.co.uk/blog/twitterx-a-new-modx-extra-for-pulling-in-twitter-feeds-using-api-1.1/), whose TwitterX addon reminded me to get my backside in gear and fix this package up!

## Twitter display "requirements"

I\'ve included a new chunk for displaying tweets. This includes several changes which *should* make the output acceptable based on the [Developer display requirements documentation](https://dev.twitter.com/terms/display-requirements). You will need to include the Twitter widgets.js somewhere on the page you\'re displaying tweets on. You only need this included ONCE on the page, not for each tweet.

```
<script type="text/javascript" src="//platform.twitter.com/widgets.js"></script>
```

## PLEASE NOTE - Twitter feeds and count limit

The [Twitter API documentation](https://dev.twitter.com/docs/api/1.1/get/statuses/user_timeline) states under retweets that: "When set to false, the timeline will strip any native retweets (though they will still count toward both the maximal length of the timeline and the slice selected by the count parameter)". This means that if you set retweets OFF and the limit to return 5 tweets, and 4 of your most recent tweets are retweets the feed will only return ONE item. This is NOT a bug!


## Google calendar and public feed URLs

Click the arrow beside the name of the calendar, then go to settings.

![Calendar Settings](http://pdincubus.github.com/JSONDerulo/img/cal-settings.png)

Look down near the bottom of the first settings screen, you\'ll see the following:

![Calendar XML feed button](http://pdincubus.github.com/JSONDerulo/img/cal-xml-button.png)

Right click the XML button, and click "Copy link location". Use this link as the &feedLocation in the snippet call. Easy!

![Calendar XML feed location](http://pdincubus.github.com/JSONDerulo/img/cal-copy-link.png)

The link should look something like this: ```str1ng0fr4nd0mch4r5%40group.calendar.google.com```
',
    'changelog' => 'Oooo whatcha say?

For all info: https://github.com/pdincubus/JSONDerulo/

Most recent additions
---------------------

2.0.1:
    * Tweak to ensure &feed is pulled into snippet correctly.

2.0:
    * Combined all snippets into one for ease of maintenance
    * Fixed a couple of minor stupid things
    * Chunks renamed in the transport package to be prepended with package name

1.7.4:
    * Added YouTube v.3 API public playlist fetcher.
    * twitteroauth should now avoid throwing an error about class OAuthException.

1.7.3:
    * Switch the Twitter new API to ACTUALLY use 1.1. WTF. I mean really.

1.7.2:
    * Includes merged changes from "silentworks" to allow offset and videoParams on YouTube feeds.
    * Includes cacheName option on most snippets to allow multiple snippet calls on same page to same user account

1.7.1:
    * REMOVED old style Twitter feed as API 1.0 is now officially retired.
    * Fix to make sure twitter doesn\'t caused annoying crash problem if they decide to just randomly blackout API access.
    * New Twitter chunk with ID check switch to allow for the graceful fallback for no JSON.
    * Updated MODX extra repo package link to new one.

1.7.0:
    * NEW Google calendar public events feed

1.6.0:
    * NEW Tumblr post feed

1.5.0:
    * NEW Google+ public posts feed
    * NEW TwitterFeedNewMultipleFeeds lets you choose what time of timeline to return

1.4.0:
    * New Twitter multiple timeline combining feed fetcher. See the documentation for more info.

1.3.4:
    * By request: Added configurable cacheTime option on ALL feed fetchers.

1.3.3:
    * option to view a different user\'s tweets using &screenName in the Twitter feed fetcher

1.3.2:
    * auto linking of [[+message]] in the Twitter feed for @, # and URLs
    * updated Twitter chunk to reflect this change

1.3.1:
    * minor tweaks to new Twitter feed

1.3:
    * NEW App.net feed

1.2:
    * New Twitter feed for use with updated API 1.1

1.1:
    * YouTube user upload snippet added

1.0:
    * Twitter changes for retweets.

0.9.1:
    * Slight fix for Twitter feed.

0.8:
    * Usually helps when you make sure that ALL the snippets and chunks have actually been packaged!

0.7:
    * Added Picasa album feed fetching snippet
',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modNamespace',
      'guid' => 'a5dfb659baa341cc1aeca3ed6ab98ade',
      'native_key' => 'jsonderulo',
      'filename' => 'modNamespace/9a99404058dada7c4eabaf104ab5336d.vehicle',
      'namespace' => 'jsonderulo',
    ),
    1 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modCategory',
      'guid' => '60e375247203102e1ffa70b3b1f9cb67',
      'native_key' => 1,
      'filename' => 'modCategory/45dedd20f4f58ece75cd625d862aa71f.vehicle',
      'namespace' => 'jsonderulo',
    ),
  ),
);