<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'readme' => '# MODX SimpleSearch
![SimpleSearch version](https://img.shields.io/badge/version-3.0.0-blue.svg) ![MODX version requirements](https://img.shields.io/badge/modx%20version%20requirement-3.0%2B-brightgreen.svg)

## Installation
Simply install it through the top menu ```Extras > Installer``` and search for ```SimpleSearch```. Install it from there. After installing it, it is recommended to clear your MODX cache, through the top menu ```Manage > Clear Cache```.

## Upgrade risks
This is currently alpha software and is only compatible with MODX 3.x and higher. This has been tested on basic search queries, but you may encounter problems with more advanced setups. 

## Autosuggest
A processor has been provided for retrieving a list of search suggestions based on a Template Variable containing a comma delimited list of search terms. 
You can configure the TV to use by setting `simplesearch.autosuggest_tv`, which can either be the TV name or id.

You can use the example (requires jQuery) code below for retrieving a list of search suggestions.

```javascript
$(\'.simplesearch-search-form input[type="text"]\').on(\'keyup\', function () {
    var value = $(this).val();

    $.ajax({
        url         : \'/assets/components/simplesearch/connector.php?action=web/autosuggestions&search=\' + value,
        dataType    : \'JSON\',
        complete    : function (result) {
            console.log(result.results);
        }
    });
});
```

## Bugs and feature requests
We value your feedback, feature requests and bug reports. Please issue them on [Github](https://github.com/modxcms/SimpleSearch/issues/new)..

Need help? [Contact MODX Help Desk](mailto:help@modx.com)
',
    'requires' => 
    array (
      'modx' => '>=3.0.0-alpha',
    ),
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modNamespace',
      'guid' => '7ba6a121f50d5a237b646ee7776dbc78',
      'native_key' => 'simplesearch',
      'filename' => 'MODX/Revolution/modNamespace/8e3e13a209d4294894e292d5b19f1e4f.vehicle',
    ),
    1 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'f75bc27ede3da10bc1c855d604e70163',
      'native_key' => 'simplesearch.driver_class',
      'filename' => 'MODX/Revolution/modSystemSetting/513bb00c3bf83e0d43f6b66480495280.vehicle',
    ),
    2 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'd9e7159a5f3afaba481dcb275fa955f2',
      'native_key' => 'simplesearch.autosuggest_tv',
      'filename' => 'MODX/Revolution/modSystemSetting/a7c2364d5c8e91ba83ad8c443c7ebb16.vehicle',
    ),
    3 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modCategory',
      'guid' => 'a9cc673ed39b1e388d9b0f4b7e68685b',
      'native_key' => NULL,
      'filename' => 'MODX/Revolution/modCategory/2cc7da9eeae1cb0b83ad60720e3b2d61.vehicle',
    ),
    4 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '05636a370565706fd133955aea3dfe12',
      'native_key' => '05636a370565706fd133955aea3dfe12',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/fd7fe241a208e57790e832b2a6ae1520.vehicle',
    ),
  ),
);