<?php
/**
 * Quip
 *
 * Copyright 2010-11 by Shaun McCormick <shaun@modx.com>
 *
 * This file is part of Quip, a simple commenting component for MODx Revolution.
 *
 * Quip is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * Quip is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Quip; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA
 *
 * @package quip
 */
/**
 * Quip English language file
 *
 * @package quip
 * @subpackage lexicon
 */
$_lang['quip'] = 'Quip';
$_lang['quip_desc'] = 'A simple commenting component.';
$_lang['quip.ago'] = ' ago';
$_lang['quip.ago_days'] = '[[+days]] days';
$_lang['quip.ago_hours'] = '[[+hours]] hrs';
$_lang['quip.ago_minutes'] = '[[+minutes]] min';
$_lang['quip.ago_seconds'] = '[[+seconds]] sec';
$_lang['quip.approve_selected'] = 'Approve Selected';
$_lang['quip.approved'] = 'Approved';
$_lang['quip.allowed_tags'] = 'Allowed tags: [[+tags]]';
$_lang['quip.anonymous'] = 'Anonymous';
$_lang['quip.author'] = 'Author';
$_lang['quip.back_to_threads'] = 'Back to Thread Listing';
$_lang['quip.body'] = 'Body';
$_lang['quip.bulk_actions'] = 'Bulk Actions';
$_lang['quip.close'] = 'Close';
$_lang['quip.comment'] = 'Comment';
$_lang['quip.comment_add_new'] = 'Add a new comment:';
$_lang['quip.comment_approve'] = 'Approve Comment';
$_lang['quip.comment_approve_selected'] = 'Approve Selected Comments';
$_lang['quip.comment_approved'] = 'Comment Approved';
$_lang['quip.comment_approved_msg'] = 'The comment by [[+name]] on [[+createdon]] has been successfully approved.';
$_lang['quip.comment_delete'] = 'Delete Comment';
$_lang['quip.comment_delete_selected'] = 'Delete Selected Comments';
$_lang['quip.comment_deleted'] = 'Comment Deleted';
$_lang['quip.comment_deleted_msg'] = 'The comment by [[+name]] on [[+createdon]] has been successfully deleted.';
$_lang['quip.comment_delete_confirm'] = 'Are you sure you want to delete this comment?';
$_lang['quip.comment_err_nf'] = 'Comment not found.';
$_lang['quip.comment_err_ns'] = 'Comment not specified.';
$_lang['quip.comment_err_remove'] = 'An error occurred while trying to remove the comment.';
$_lang['quip.comment_err_save'] = 'An error occurred while trying to save the comment.';
$_lang['quip.comment_remove'] = 'Permanently Remove Comment';
$_lang['quip.comment_remove_confirm'] = 'Are you sure you want to permanently remove this comment? This cannot be undone.';
$_lang['quip.comment_remove_selected'] = 'Remove Selected Comments';
$_lang['quip.comment_unapprove'] = 'Unapprove Comment';
$_lang['quip.comment_unapprove_selected'] = 'Unapprove Selected Comments';
$_lang['quip.comment_undelete'] = 'Undelete Comment';
$_lang['quip.comment_undelete_selected'] = 'Undelete Selected Comments';
$_lang['quip.comment_update'] = 'Update Comment';
$_lang['quip.comment_view'] = 'View Comment';
$_lang['quip.comment_will_be_moderated'] = 'Your comment has been submitted, and is now awaiting moderation. You will receive an email when your comment has been approved.';
$_lang['quip.comments'] = 'Comments';
$_lang['quip.delete'] = 'Delete';
$_lang['quip.delete_selected'] = 'Delete Selected';
$_lang['quip.email'] = 'Email';
$_lang['quip.email_err_ns'] = 'Please specify an email address.';
$_lang['quip.err_fraud_attempt'] = 'Error: IDs of users do not match. Fraud attempt detected.';
$_lang['quip.err_not_logged_in'] = 'You are not logged in and therefore are not authorized to post comments.';
$_lang['quip.hide_deleted'] = 'Hide Deleted';
$_lang['quip.intro_msg'] = 'Manage your Quip comments and threads here.';
$_lang['quip.ip'] = 'IP';
$_lang['quip.latest_comments'] = 'Latest Comments';
$_lang['quip.latest_comments_for'] = 'Latest Comments for';
$_lang['quip.latest_comments_msg'] = 'View the latest posted comments here.';
$_lang['quip.login_to_comment'] = 'Please login to comment.';
$_lang['quip.message_err_ns'] = 'Please specify a message to post.';
$_lang['quip.moderated'] = 'Moderated';
$_lang['quip.moderated_desc'] = 'New posts to this thread will be moderated.';
$_lang['quip.moderators'] = 'Moderators';
$_lang['quip.moderators_desc'] = 'A comma-separated list of usernames who can moderate this thread.';
$_lang['quip.moderator_group'] = 'Moderator Group';
$_lang['quip.moderator_group_desc'] = 'A User Group whose members can moderate this thread.';
$_lang['quip.name'] = 'Name';
$_lang['quip.name_err_ns'] = 'Please specify a name.';
$_lang['quip.no_email_to_specified'] = 'Quip cannot send a spam report email because no admin email was specified.';
$_lang['quip.notify_me'] = 'Notify of New Replies';
$_lang['quip.notification'] = 'Notification';
$_lang['quip.notification_create'] = 'Add Notification';
$_lang['quip.notification_err_nf'] = 'Notification not found!';
$_lang['quip.notification_err_ns'] = 'Notification not specified!';
$_lang['quip.notification_remove'] = 'Remove Notification';
$_lang['quip.notification_remove_confirm'] = 'Are you sure you want to unsubscribe this user from this Thread?';
$_lang['quip.notifications'] = 'Notifications';
$_lang['quip.notifications.intro_msg'] = 'Here is a list of all the subscribed users to this Thread.';
$_lang['quip.post'] = 'Post';
$_lang['quip.posted'] = 'Posted';
$_lang['quip.postedon'] = 'Posted On';
$_lang['quip.preview'] = 'Preview';
$_lang['quip.recaptcha_err_load'] = 'Could not load reCaptcha service class.';
$_lang['quip.reply'] = 'Reply';
$_lang['quip.remove'] = 'Remove';
$_lang['quip.remove_selected'] = 'Remove Selected';
$_lang['quip.report_as_spam'] = 'Report as Spam';
$_lang['quip.reported_as_spam'] = 'Reported as Spam';
$_lang['quip.sfs_err_load'] = 'Could not load StopForumSpam class.';
$_lang['quip.show_deleted'] = 'Show Deleted';
$_lang['quip.spam_blocked'] = 'Your submission was blocked by a spam filter: [[+fields]]';
$_lang['quip.spam_email'] = '<p>Hello,</p>

<p>A comment by [[+username]] has been reported as spam at:</p>

<p><a href="[[+url]]">[[+url]]</a></p>

<p>This is an automated email. Please do not reply directly. The
comment\'s ID is: <strong>[[+id]]</strong></p>

<p>
Thanks,<br />
<em>Quip</em>
</p>';
$_lang['quip.spam_email_subject'] = '[Quip] Comment Spam Reported';
$_lang['quip.spam_marked'] = ' - marked as spam.';
$_lang['quip.subscribed_on'] = 'Subscribed On';
$_lang['quip.thread'] = 'Thread';
$_lang['quip.thread_autoclosed'] = 'This thread has been closed from taking new comments.';
$_lang['quip.thread_err_ns'] = 'No thread specified.';
$_lang['quip.thread_err_remove'] = 'An error occurred while trying to remove the thread.';
$_lang['quip.thread_err_save'] = 'An error occurred while trying to save the thread.';
$_lang['quip.thread_manage'] = 'Manage Thread';
$_lang['quip.thread_msg'] = 'Here you can manage all the comments for this particular thread.';
$_lang['quip.thread_remove'] = 'Remove Thread';
$_lang['quip.thread_remove_confirm'] = 'Are you sure you want to completely remove this thread, and all of its comments? This is irreversible.';
$_lang['quip.thread_remove_selected'] = 'Remove Selected Threads';
$_lang['quip.thread_remove_selected_confirm'] = 'Are you sure you want to remove these threads entirely? This is irreversible.';
$_lang['quip.thread_truncate'] = 'Truncate Thread';
$_lang['quip.thread_truncate_confirm'] = 'Are you sure you want to remove all comments in this thread?';
$_lang['quip.thread_truncate_selected'] = 'Truncate Selected Threads';
$_lang['quip.thread_truncate_selected_confirm'] = 'Are you sure you want to remove all comments in these threads?';
$_lang['quip.threads'] = 'Threads';
$_lang['quip.unapproved'] = 'Unapproved';
$_lang['quip.unapproved_comments'] = 'Unapproved Comments';
$_lang['quip.unapproved_comments_msg'] = 'Moderate any unapproved comments here.';
$_lang['quip.unsubscribe_me'] = 'Unsubscribe Me from this Thread';
$_lang['quip.unsubscribed'] = 'You have been unsubscribed from this Thread. Thanks!';
$_lang['quip.username_said'] = '<strong>[[+username]]</strong> said:';
$_lang['quip.view'] = 'View';
$_lang['quip.website'] = 'Website';

$_lang['area_tags'] = 'Tags';
$_lang['setting_quip.allowed_tags'] = 'Allowed Tags';
$_lang['setting_quip.allowed_tags_desc'] = 'The tags allowed for users in comment posting. See <a target="_blank" href="http://php.net/strip_tags">php.net/strip_tags</a> for a list of acceptable values.';
$_lang['setting_quip.emailsFrom'] = 'From Email';
$_lang['setting_quip.emailsFrom_desc'] = 'The email address to send system emails from.';
$_lang['setting_quip.emailsTo'] = 'To Email';
$_lang['setting_quip.emailsTo_desc'] = 'The email address to send system emails to.';
$_lang['setting_quip.emailsReplyTo'] = 'Reply-To Email';
$_lang['setting_quip.emailsReplyTo_desc'] = 'The email address to set the reply-to to. Defaults to emailFrom.';
$_lang['setting_quip.emails_from_name'] = 'From Name for Emails';
$_lang['setting_quip.emails_from_name_desc'] = 'The name that will be used for the From: address in emails.';