<?php
/**
 * Quip
 *
 * Copyright 2010-11 by Shaun McCormick <shaun@modx.com>
 *
 * This file is part of Quip, a simple commenting component for MODx Revolution.
 *
 * Quip is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * Quip is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Quip; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA
 *
 * @package quip
 */
/**
 * Quip Russian language file
 *
 * @package quip
 * @subpackage lexicon
 */
$_lang['quip'] = 'Quip';
$_lang['quip_desc'] = 'Компонент для управления комментариями.';
$_lang['quip.ago'] = ' тому назад';
$_lang['quip.ago_days'] = '[[+days]] дней';
$_lang['quip.ago_hours'] = '[[+hours]] часов';
$_lang['quip.ago_minutes'] = '[[+minutes]] минут';
$_lang['quip.ago_seconds'] = '[[+seconds]] секунд';
$_lang['quip.approve_selected'] = 'Утвердить выбранные';
$_lang['quip.approved'] = 'Утверждённые';
$_lang['quip.allowed_tags'] = 'Разрешённые теги: [[+tags]]';
$_lang['quip.anonymous'] = 'Аноним';
$_lang['quip.author'] = 'Автор';
$_lang['quip.back_to_threads'] = 'Вернуться к списку тем';
$_lang['quip.body'] = 'Body';
$_lang['quip.bulk_actions'] = 'Массовые действия';
$_lang['quip.close'] = 'Закрыть';
$_lang['quip.comment'] = 'Комментарий';
$_lang['quip.comment_add_new'] = 'Добавить новый комментарий:';
$_lang['quip.comment_approve'] = 'Утвердить комментарий';
$_lang['quip.comment_approved'] = 'Comment Approved';
$_lang['quip.comment_approved_msg'] = 'The comment by [[+name]] on [[+createdon]] has been successfully approved.';
$_lang['quip.comment_delete'] = 'Удалить комментарий';
$_lang['quip.comment_deleted'] = 'Comment Deleted';
$_lang['quip.comment_deleted_msg'] = 'The comment by [[+name]] on [[+createdon]] has been successfully deleted.';
$_lang['quip.comment_delete_confirm'] = 'Вы уверены, что хотите удалить этот комментарий?';
$_lang['quip.comment_err_nf'] = 'Комментарий не найден.';
$_lang['quip.comment_err_ns'] = 'Комментарий не указан.';
$_lang['quip.comment_err_remove'] = 'Произошла ошибка при попытке удалить этот комментарий.';
$_lang['quip.comment_err_save'] = 'Произошла ошибка при попытке сохранить этот комментарий.';
$_lang['quip.comment_remove'] = 'Удалить комментарий';
$_lang['quip.comment_remove_confirm'] = 'Вы уверены, что хотите удалить этот коментарий? Это не может быть отменено.';
$_lang['quip.comment_unapprove'] = 'Отклонить комментарий';
$_lang['quip.comment_undelete'] = 'Востановить комментарий';
$_lang['quip.comment_update'] = 'Редактировать комментарий';
$_lang['quip.comment_view'] = 'Просмотреть комментарий';
$_lang['quip.comment_will_be_moderated'] = 'Ваш комментарий успешно добавлен и ожидает проверки модератором. Вы получите сообщение по электронной почте, когда комментарий будет одобрен.';
$_lang['quip.comments'] = 'Комментарии';
$_lang['quip.delete'] = 'Удалить';
$_lang['quip.delete_selected'] = 'Удалить выбранные';
$_lang['quip.email'] = 'Электронная почта';
$_lang['quip.email_err_ns'] = 'Пожалуйста, укажите адрес электронной почты.';
$_lang['quip.err_fraud_attempt'] = 'Ошибка: идентификатор пользователя не совпадает. Обнаружена попытка мошеничества';
$_lang['quip.err_not_logged_in'] = 'Вы не авторизованны и поэтому не можете добавлять комментарии.';
$_lang['quip.hide_deleted'] = 'Скрыть удалённые';
$_lang['quip.intro_msg'] = 'Управление комментариями и темами.';
$_lang['quip.ip'] = 'IP';
$_lang['quip.latest_comments'] = 'Последние комментарии';
$_lang['quip.latest_comments_for'] = 'Latest Comments for';
$_lang['quip.latest_comments_msg'] = 'Просмотр последних комментариев.';
$_lang['quip.login_to_comment'] = 'Пожалуйста, авторизуйтесь для того, чтобы комментировать';
$_lang['quip.message_err_ns'] = 'Пожалуйста, введите комментарий.';
$_lang['quip.moderated'] = 'Модерируется';
$_lang['quip.moderated_desc'] = 'Новые сообщения в этой теме будут модерироваться.';
$_lang['quip.moderators'] = 'Модераторы';
$_lang['quip.moderators_desc'] = 'Список имён пользователей через запятую, которые могут модерировать эту тему.';
$_lang['quip.moderator_group'] = 'Группа модераторов';
$_lang['quip.moderator_group_desc'] = 'Группа пользователей члены которой могут модерировать эту тему.';
$_lang['quip.name'] = 'Имя';
$_lang['quip.name_err_ns'] = 'Пожалуйста, укажите имя.';
$_lang['quip.no_email_to_specified'] = 'Quip не смог послать отчёт о спаме, потому что адрес электронной почты администратора не указан.';
$_lang['quip.notify_me'] = 'Уведомлять о новых ответах';
$_lang['quip.post'] = 'Post';
$_lang['quip.posted'] = 'Опубликован';
$_lang['quip.postedon'] = 'Опубликован';
$_lang['quip.preview'] = 'Просмотр';
$_lang['quip.recaptcha_err_load'] = 'Невозможно загрузить класс сервиса reCaptcha.';
$_lang['quip.reply'] = 'Ответить';
$_lang['quip.remove'] = 'Удалить';
$_lang['quip.remove_selected'] = 'Удалить выбранные';
$_lang['quip.report_as_spam'] = 'Пометить как спам';
$_lang['quip.reported_as_spam'] = 'помечено как спам';
$_lang['quip.sfs_err_load'] = 'Невозможно загрузить класс StopForumSpam.';
$_lang['quip.show_deleted'] = 'Показать удаленные';
$_lang['quip.spam_blocked'] = 'Ваше сообщение было заблокировано спам фильтром: [[+fields]]';
$_lang['quip.spam_email'] = '<p>Здравствуйте,</p>

<p>Комментарий пользователя [[+username]] был помечен как спам:</p>

<p><a href="[[+url]]">[[+url]]</a></p>

<p>Это сообщение сгенирированно автоматически. На него не надо отвечать 
Идентификатор комментария: <strong>[[+id]]</strong></p>

<p>
Спасибо,<br />
<em>Quip</em>
</p>';
$_lang['quip.spam_email_subject'] = '[Quip] Обнаружен спам в комментариях';
$_lang['quip.spam_marked'] = ' - помеченные как спам.';
$_lang['quip.thread'] = 'Тема';
$_lang['quip.thread_autoclosed'] = 'Добавление комментариев закрыто.';
$_lang['quip.thread_err_ns'] = 'Тема не указана.';
$_lang['quip.thread_manage'] = 'Управление темой';
$_lang['quip.thread_msg'] = 'Здесь вы можете управлять комментариями в этой теме.';
$_lang['quip.thread_truncate'] = 'Очистить тему';
$_lang['quip.thread_truncate_confirm'] = 'Вы уверены, что хотите удалить все комментарии в этой теме?';
$_lang['quip.threads'] = 'Темы';
$_lang['quip.unapproved'] = 'Отклонённые';
$_lang['quip.unapproved_comments'] = 'Отклонённые комментарии';
$_lang['quip.unapproved_comments_msg'] = 'Управление отклонёнными комментариями.';
$_lang['quip.username_said'] = '<strong>[[+username]]</strong> сказал:';
$_lang['quip.view'] = 'Просмотр';
$_lang['quip.website'] = 'Вебсайт';


$_lang['setting_quip.allowedTags'] = 'Разрешённые теги';
$_lang['setting_quip.allowedTags_desc'] = 'Теги которые разрешены в комментариях. Список допустимых значений <a target="_blank" href="http://php.net/strip_tags">php.net/strip_tags</a> .';
$_lang['setting_quip.emailsFrom'] = 'From Email';
$_lang['setting_quip.emailsFrom_desc'] = 'The email address to send system emails from.';
$_lang['setting_quip.emailsTo'] = 'To Email';
$_lang['setting_quip.emailsTo_desc'] = 'The email address to send system emails to.';
$_lang['setting_quip.emailsReplyTo'] = 'Reply-To Email';
$_lang['setting_quip.emailsReplyTo_desc'] = 'The email address to set the reply-to to. Defaults to emailFrom.';
