<?php
/**
 * Quip
 *
 * Copyright 2010-11 by Shaun McCormick <shaun@modx.com>
 *
 * This file is part of Quip, a simple commenting component for MODx Revolution.
 *
 * Quip is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * Quip is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Quip; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA
 *
 * @package quip
 */
/**
 * Quip English language file
 *
 * @package quip
 * @subpackage lexicon
 */
$_lang['quip'] = 'Quip';
$_lang['quip_desc'] = 'Un composant simple de commentaires.';
$_lang['quip.ago'] = ' (il y a)';
$_lang['quip.ago_days'] = '[[+days]] jour';
$_lang['quip.ago_hours'] = '[[+hours]] h';
$_lang['quip.ago_minutes'] = '[[+minutes]] min';
$_lang['quip.ago_seconds'] = '[[+seconds]] sec';
$_lang['quip.approve_selected'] = 'Autoriser la sélection';
$_lang['quip.approved'] = 'Autorisé(s)';
$_lang['quip.allowed_tags'] = 'Tags autorisés : [[+tags]]';
$_lang['quip.anonymous'] = 'Anonyme';
$_lang['quip.author'] = 'Auteur';
$_lang['quip.back_to_threads'] = 'Retour à la liste des sujets';
$_lang['quip.body'] = 'Corps';
$_lang['quip.bulk_actions'] = 'Actions groupées';
$_lang['quip.close'] = 'Fermer';
$_lang['quip.comment'] = 'Commentaires';
$_lang['quip.comment_add_new'] = 'Ajouter un nouveau commentaire :';
$_lang['quip.comment_approve'] = 'Autoriser le commentaire';
$_lang['quip.comment_approve_selected'] = 'Autoriser les commentaires sélectionnés';
$_lang['quip.comment_approved'] = 'Commentaire approuvé';
$_lang['quip.comment_approved_msg'] = 'Le commentaire de [[+name]] datant de [[+createdon]] a été approuvé.';
$_lang['quip.comment_delete'] = 'Supprimer le commentaire';
$_lang['quip.comment_delete_selected'] = 'Supprimer les commentaires sélectionnés';
$_lang['quip.comment_deleted'] = 'Commentaire supprimé';
$_lang['quip.comment_deleted_msg'] = 'Le commentaire de [[+name]] datant de [[+createdon]] a été supprimé.';
$_lang['quip.comment_delete_confirm'] = 'Êtes-vous sûr de vouloir supprimer ce commentaire?';
$_lang['quip.comment_err_nf'] = 'Commentaire non trouvé.';
$_lang['quip.comment_err_ns'] = 'Commentaire non indiqué.';
$_lang['quip.comment_err_remove'] = 'Une erreur est survenue lors de la suppression du commentaire.';
$_lang['quip.comment_err_save'] = 'Une erreur est survenue lors de l\'enregistrement du commentaire.';
$_lang['quip.comment_remove'] = 'Supprimer définitivement le commentaire';
$_lang['quip.comment_remove_confirm'] = 'Êtes-vous sûr de vouloir supprimer définitivement ce commentaire? Cette opération est irreverssible.';
$_lang['quip.comment_remove_selected'] = 'Supprimer les commentaires séléectionnés';
$_lang['quip.comment_unapprove'] = 'Dépublier le commentaire';
$_lang['quip.comment_unapprove_selected'] = 'Dépublier les commentaires sélectionnés';
$_lang['quip.comment_undelete'] = 'Restaurer le commentaire';
$_lang['quip.comment_undelete_selected'] = 'Restaurer les commentaires sélectionnés';
$_lang['quip.comment_update'] = 'Modifier le commentaire';
$_lang['quip.comment_view'] = 'Voir le commentaire';
$_lang['quip.comment_will_be_moderated'] = 'Votre commentaire a été ajouté et est maintenant en attente de modération. Vous recevrez un email lorsque votre commentaire sera validé.';
$_lang['quip.comments'] = 'Commentaires';
$_lang['quip.delete'] = 'Supprimer';
$_lang['quip.delete_selected'] = 'Supprimer la sélection';
$_lang['quip.email'] = 'Email';
$_lang['quip.email_err_ns'] = 'Veuillez indiquer une adresse email.';
$_lang['quip.err_fraud_attempt'] = 'Erreur : les IDs des utilisateurs ne correspondent pas. Tentative de fraude détectée.';
$_lang['quip.err_not_logged_in'] = 'Vous n\'êtes pas identifié et donc non autorisé à poster des commentaires.';
$_lang['quip.hide_deleted'] = 'Masquer les commentaires supprimés';
$_lang['quip.intro_msg'] = 'Gérer vos commentaires et sujets Quip ici.';
$_lang['quip.ip'] = 'IP';
$_lang['quip.latest_comments'] = 'Derniers commentaires';
$_lang['quip.latest_comments_for'] = 'Derniers commentaires pour';
$_lang['quip.latest_comments_msg'] = 'Visionnez les derniers commentaires ici.';
$_lang['quip.login_to_comment'] = 'Veuillez vous identifier pour commenter.';
$_lang['quip.message_err_ns'] = 'Veuillez indiquer un message à poster.';
$_lang['quip.moderated'] = 'Modéré';
$_lang['quip.moderated_desc'] = 'Les nouveaux commentaires de ce sujet seront modérés.';
$_lang['quip.moderators'] = 'Modérateurs';
$_lang['quip.moderators_desc'] = 'Une liste de noms d\'utilisateurs qui pouvant modérer ce sujet (séparés par des virgules).';
$_lang['quip.moderator_group'] = 'Groupe modérateur';
$_lang['quip.moderator_group_desc'] = 'Un groupe d\'utilisateur pouvant modérer ce sujet.';
$_lang['quip.name'] = 'Nom';
$_lang['quip.name_err_ns'] = 'Veuillez indiquer un nom.';
$_lang['quip.no_email_to_specified'] = 'Quip ne peut envoyer de rapport de spam parcequ\'aucune adresse email d\'administrateur n\'a été indiquée.';
$_lang['quip.notify_me'] = 'Être informé des nouveaux messages';
$_lang['quip.post'] = 'Poster';
$_lang['quip.posted'] = 'Posté';
$_lang['quip.postedon'] = 'Posté le';
$_lang['quip.preview'] = 'Aperçu';
$_lang['quip.recaptcha_err_load'] = 'Impossible de charger la classe de service reCaptcha.';
$_lang['quip.reply'] = 'Répondre';
$_lang['quip.remove'] = 'Supprimer';
$_lang['quip.remove_selected'] = 'Supprimer la sélection';
$_lang['quip.report_as_spam'] = 'Reporter comme spam';
$_lang['quip.reported_as_spam'] = 'Reporté en tant que spam';
$_lang['quip.sfs_err_load'] = 'Impossible de charger la classe StopForumSpam.';
$_lang['quip.show_deleted'] = 'Afficher les messages supprimés';
$_lang['quip.spam_blocked'] = 'Votre commentaire a été bloqué par un filtre anti-spam : [[+fields]]';
$_lang['quip.spam_email'] = '<p>Bonjour,</p>

<p>Un commentaire de [[+username]] a été rapporté comme spam à l\'adresse :</p>

<p><a href="[[+url]]">[[+url]]</a></p>

<p>Ceci est un message automatique. Veuillez ne pas y répondre. l\'ID 
est: <strong>[[+id]]</strong></p>

<p>
Merci,<br />
<em>Quip</em>
</p>';
$_lang['quip.spam_email_subject'] = '[Quip] commentaire rapporté comme spam';
$_lang['quip.spam_marked'] = ' - marqué comme spam.';
$_lang['quip.thread'] = 'Sujet(s)';
$_lang['quip.thread_autoclosed'] = 'Les commentaires sur ce sujet ne sont plus acceptés.';
$_lang['quip.thread_err_ns'] = 'Pas de sujet d\'indiqué.';
$_lang['quip.thread_err_remove'] = 'Une erreur est survenue lors de la suppression de ce sujet.';
$_lang['quip.thread_err_save'] = 'Une erreur est survenue lors de l\'enregistrement de ce sujet.';
$_lang['quip.thread_manage'] = 'Gérer le sujet';
$_lang['quip.thread_msg'] = 'Vous pouvez gérer ici tous les commentaires de ce sujet.';
$_lang['quip.thread_remove'] = 'Supprimer le sujet';
$_lang['quip.thread_remove_confirm'] = 'Êtes-vous sûr de vouloir entièrement supprimer ce sujet? Cette opération est irreverssible.';
$_lang['quip.thread_remove_selected'] = 'Supprimer les sujets sélectionnés';
$_lang['quip.thread_remove_selected_confirm'] = 'Êtes-vous sûr de vouloir entièrement supprimer ces sujets? Cette opération est irreverssible.';
$_lang['quip.thread_truncate'] = 'Purger le sujet';
$_lang['quip.thread_truncate_confirm'] = 'Êtes-vous sûr de vouloir supprimer tous les commentaires de ce sujet?';
$_lang['quip.thread_truncate_selected'] = 'Purger les sujets sélectionnés';
$_lang['quip.thread_truncate_selected_confirm'] = 'Êtes-vous sûr de vouloir supprimer tous les commentaires de ces sujets?';
$_lang['quip.threads'] = 'Sujets';
$_lang['quip.unapproved'] = 'Non publié(s)';
$_lang['quip.unapproved_comments'] = 'Commentaires non publiés';
$_lang['quip.unapproved_comments_msg'] = 'Modérer tous les commentaires non publiés ici.';
$_lang['quip.username_said'] = '<strong>[[+username]]</strong> a écrit :';
$_lang['quip.view'] = 'Voir';
$_lang['quip.website'] = 'Site internet';

$_lang['area_tags'] = 'Tags';
$_lang['setting_quip.allowed_tags'] = 'Tags autorisés';
$_lang['setting_quip.allowed_tags_desc'] = 'Les tags autorisés dans les commentaires des utilisateurs. Voir <a target="_blank" href="http://php.net/strip_tags">php.net/strip_tags</a> pour la liste des valeurs acceptées.';
$_lang['setting_quip.emailsFrom'] = 'Expéditeur';
$_lang['setting_quip.emailsFrom_desc'] = 'L\'adresse email avec laquelle envoyer les emails « système ».';
$_lang['setting_quip.emailsTo'] = 'Destinataire';
$_lang['setting_quip.emailsTo_desc'] = 'L\'adresse email a qui envoyer les emails « système ».';
$_lang['setting_quip.emailsReplyTo'] = 'Email de réponse';
$_lang['setting_quip.emailsReplyTo_desc'] = 'L\'adresse email a utiliser comme adresse de réponse (Reply-to). Par défaut, l\'adresse expéditrice.';
$_lang['setting_quip.emails_from_name'] = 'Nom à afficher sur les emails';
$_lang['setting_quip.emails_from_name_desc'] = 'Le nom qui sera affiché dans le champ expéditeur (From).';